//
//  read.cpp
//  pbsAccounting
//
//  Created by Fabio Roberto Vitello on 16/06/17.
//  Copyright © 2017 Fabio Roberto Vitello. All rights reserved.
//

#include "read.hpp"


/*
 * $Id: read.c,v 1.1.1.1 2006/03/13 18:31:16 bino Exp $
 * (based based on pbs_accounting.c from
 *  Albino Aveleda, NACAD-COPPE/UFRJ)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "main.h"

/* read file(s) */
void read_file(char *file)
{
    int    len, nodes,cpu, hour, min, sec, test, linenum = 0, reqmemory,corememory=0;
    double cpu_used, wall_used, memorypercore;
    char   buffer[BUFSIZ], *p, *ptr, *line;
    char   uid[MAX_NAME_SIZE], gid[MAX_NAME_SIZE];
    GROUP  *pg, *pg_aux;
    USER   *pu, *pu_aux;
    FILE   *f_in;
    
    /* open PBS data file */
    if (f_stdin)
        f_in = stdin;
    else
        if ((f_in = fopen(file,"r")) == NULL) {
            printf("\tCan't open file %s.\n",file);
            exit(1);
        }
    
    /* read file */
    while(fgets(buffer, BUFSIZ, f_in) != NULL) {
        linenum++;
        if (strstr(buffer, " end") != NULL) {
            cpu_used = 0.0;
            len = strlen(buffer) + 1;
            line = static_cast<char*>(malloc(len * sizeof(char)));
            strcpy(line, buffer);
            
            ptr = strstr(line, "Resource_List.mem");
            if (ptr != NULL) {
                /* try node */
                p = strtok(ptr, "=");
                p = strtok(NULL, "=");
                p = strtok(p, " ");

                const char *unit = &p[strlen(p)-2];
                
                if ( strcmp (unit,"gb") == 0)
                {
                    p[strlen(p)-2] = 0;
                    reqmemory = atoi(p);
                    corememory = floor((float)reqmemory/((float)memorypernode/cpuvalue));
              //      if (corememory>cpuvalue)
                //        corememory=cpuvalue;
                }
                //    nodes = atoi(p);
            }

            strcpy(line, buffer);

            ptr = strstr(line, "Resource_List.ncpus");
            if (ptr == NULL) {
                /* try node */
                strcpy(line, buffer);
                ptr = strstr(line, "Resource_List.nodect");
            }
            /* num of cpu or nodes */
            if (ptr != NULL) {
                p = strtok(ptr, "=");
                p = strtok(NULL, "=");
                cpu = atoi(p);
                
               
                
                strcpy(line, buffer);
                ptr = strstr(line, "Resource_List.nodect");
                p = strtok(ptr, "=");
                p = strtok(NULL, "=");
                nodes = atoi(p);
                
                corememory=corememory/nodes;
                if (corememory>cpuvalue)
                    corememory=cpuvalue;
                
                if (corememory>(cpu/nodes))
                {
                    nodes=corememory*nodes;
                }
                else
                {
                    nodes=cpu;

                }
                
            } else {
                nodes = 1;
            }
            
            strcpy(line, buffer);

            
            ptr = strstr(line, "Resource_List.place");
            if (ptr != NULL) {
                p = strtok(ptr, "=");
                p = strtok(NULL, "=");
                p = strtok(p, " ");

                if (strcmp(p,"scatter:excl") == 0)
                {
                    
                    strcpy(line, buffer);
                    ptr = strstr(line, "Resource_List.nodect");
                    p = strtok(ptr, "=");
                    p = strtok(NULL, "=");
                    nodes = atoi(p)*cpuvalue;

                 //   printf ("nodo esclusivo");
                }

                
                
            }
           //printf("%d",nodes);

            
            
            /* search for user name */
            strcpy(line, buffer);
            ptr = strstr(line, ";user");
            if (ptr == NULL) {
                fprintf(stderr,
                        "Warning: No user (id) data on line %d, skipping...\n",
                        linenum);
                free(line);
                continue;
            }
            p = strtok(ptr, "=");
            p = strtok(NULL, "=");
            sscanf(p, "%s ", uid);
            p = strtok(NULL, "=");
            sscanf(p, "%s ", gid);

            strcpy(line, buffer);
            ptr = strstr(line, "account");

            if (ptr != NULL) {

                p = strtok(ptr, "=");
                p = strtok(NULL, "=");
                sscanf(p, "%s ", gid);
            }
            
            /* search for cpu time */
            if(f_cpu) {
                strcpy(line, buffer);
                ptr = strstr(line, "resources_used.cput");
                if (ptr == NULL) {
                    if(!noverbose)
                    {
                    fprintf(stderr,
                            "Warning: No used.cput data on line %d, skipping...\n",
                            linenum);
                    }
                    free(line);
                    continue;
                }
                p = strtok(ptr, "=");
                p = strtok(NULL, "=");
                sscanf(p, "%d:%d:%d ", &hour, &min, &sec);
                cpu_used = (double)((double)sec/60) + min + (hour * 60);
                /* cpu_used = (double)atof(p)/60; cpu minutes */
            }
            
            /* search for walltime */
            strcpy(line, buffer);
            ptr = strstr(line, "resources_used.walltime");
            if (ptr == NULL) {
                fprintf(stderr,
                        "Warning: No used.walltime data on line %d, skipping...\n",
                        linenum);
                free(line);
                continue;
            }
            p = strtok(ptr, "=");
            p = strtok(NULL, "=");
            sscanf(p, "%d:%d:%d ", &hour, &min, &sec);
            /* walltime minutes */
            wall_used = (double)((double)sec/60) + min + (hour * 60);
            
            free(line);
            
            /* lookup group */
            if (pgroups == NULL){
                pgroups = new_group();
                pg = pgroups;
                strcpy(pg->groupname,gid);
            } else {
                pg = pgroups;
                test = strcmp(gid,pg->groupname);
                if (test != 0) {
                    if (test < 0){
                        pgroups = new_group();
                        pgroups->p_next = pg;
                        pg = pgroups;
                        strcpy(pg->groupname,gid);
                    } else {
                        while ((pg->p_next != NULL) && (strcmp(gid,pg->p_next->groupname) >= 0))
                            pg = pg->p_next;
                        if (strcmp(gid, pg->groupname) > 0) {
                            if (pg->p_next == NULL){
                                pg->p_next = new_group();
                            } else {
                                pg_aux = new_group();
                                pg_aux->p_next = pg->p_next;
                                pg->p_next = pg_aux;
                            }
                            pg = pg->p_next;
                            strcpy(pg->groupname,gid);
                        }
                    }
                }
            }
            pg->num_jobs++;
            pg->nodes         += nodes;
            pg->cpu_time      += cpu_used;
            pg->wall_time     += wall_used;
            pg->all_cpu_time  += nodes * cpu_used;
            pg->all_wall_time += nodes * wall_used;
            
            /* lookup user */
            if (f_user) {
                if (pusers == NULL){
                    pusers = new_user();
                    pu = pusers;
                    strcpy(pu->username,uid);
                } else {
                    pu = pusers;
                    test = strcmp(uid,pu->username);
                    if (test != 0 ) {
                        if (test < 0) {
                            pusers = new_user();
                            pusers->p_next = pu;
                            pu = pusers;
                            strcpy(pu->username,uid);
                        } else {
                            while ((pu->p_next != NULL) && (strcmp(uid,pu->p_next->username) >= 0))
                                pu = pu->p_next;
                            if (strcmp(uid, pu->username) > 0) {
                                if (pu->p_next == NULL){
                                    pu->p_next = new_user();
                                } else {
                                    pu_aux = new_user();
                                    pu_aux->p_next = pu->p_next;
                                    pu->p_next = pu_aux;
                                }
                                pu = pu->p_next;
                                strcpy(pu->username,uid);
                            }
                        }
                    }
                }
                pu->num_jobs++;
                pu->nodes         += nodes;
                pu->cpu_time      += cpu_used;
                pu->wall_time     += wall_used;
                pu->all_cpu_time  += nodes * cpu_used;
                pu->all_wall_time += nodes * wall_used;
                pu->pg = pg;
            }
        }
    }
    
    /* close PBS data file */
    if (!f_stdin) fclose(f_in);
}
