//
//  print.cpp
//  pbsAccounting
//
//  Created by Fabio Roberto Vitello on 16/06/17.
//  Copyright © 2017 Fabio Roberto Vitello. All rights reserved.
//

#include "print.hpp"

/* $Id: print.c,v 1.1.1.1 2006/03/13 18:31:16 bino Exp $ */

#include <stdio.h>
#include <string.h>
#include "main.h"

/* print report */
void print_report(char *hostname)
{
    GROUP  *pg;
    USER   *pu;
    double total;
    
    if (!noverbose)
    {
        printf("\n*** Portable Batch System accounting ***\n");
        printf("Server Name: %s\n", hostname);
    }
    f_cpu=false;
    f_stat=false;
    /* print report user */
    if (f_user) {
        printf("\n*** PBS Per-User Usage Report ***\n");
        printf("User      Group     #Jobs    Wall(h)");
        if (f_cpu) {
            printf("     CPU(h)");
            if (f_stat) printf("  Efcy(%)");
        }
        if (f_stat) {
            printf("  Av.Wall(h)");
            if (f_cpu) printf("  Av.CPU(h)");
            printf("  Av.#CPU");
        }
        printf("   Sum Wall(h)");
        if (f_cpu) printf("   Sum CPU(h)");
        if (f_bill) printf("%14s",unit);
        printf("\n");
        pu = pusers;
        while (pu != NULL){
            printf("%-9s %-9s %5d %10.4f",pu->username,pu->pg->groupname,
                   pu->num_jobs,(pu->wall_time/60));
            if (f_cpu) {
                printf(" %10.4f",(pu->cpu_time/60));
                if (f_stat) printf("   %6.2f",(pu->cpu_time/60)*100/(pu->wall_time/60));
            }
            if (f_stat) {
                printf("  %10.4f",((pu->wall_time/60)/pu->num_jobs));
                if (f_cpu) printf(" %10.4f",((pu->cpu_time/60)/pu->num_jobs));
                printf("    %5.1f",(float)(pu->nodes/pu->num_jobs));
            }
            printf(" %13.4f",(pu->all_wall_time/60));
            if (f_cpu) printf("%13.4f",(pu->all_cpu_time/60));
            if (f_bill) {
                switch(opt) {
                    case 0:
                        total = value * pu->cpu_time/60;
                        break;
                    case 1:
                        total = value * pu->wall_time/60;
                        break;
                    case 2:
                        total = value * pu->all_cpu_time/60;
                        break;
                    case 3:
                        total = value * pu->all_wall_time/60;
                        break;
                    case 99:
                        total = value * pu->all_wall_time/60;
                        break;

                }
                printf("%14.2f",total);
            }
            printf("\n");
            pu = pu->p_next;
        }
    }
    
    /* print report group */
    if (f_group) {
        if (!noverbose)
        {
            printf("\n*** PBS Per-Group Usage Report ***\n");
            printf("Group     #Jobs    Wall(h)");
        }
        if (f_cpu && !noverbose) {
            printf("     CPU(h)");
            if (f_stat) printf("  Efcy(%)");
        }
        if (f_stat && !noverbose) {
            printf("  Av.Wall(h)");
            if (f_cpu) printf("  Av.CPU(h)");
            printf("  Av.#CPU");
        }
        if ( !noverbose)        printf("   Sum Wall(h)");
        if (f_cpu && !noverbose) printf("   Sum CPU(h)");
        if (f_bill && !noverbose) printf("%14s",unit);
        if ( !noverbose)  printf("\n");
        pg = pgroups;
        while (pg != NULL){
            if (noverbose)
            {
                printf("%-9s ",pg->groupname);
                printf(" %13.4f",(pg->all_wall_time/60));
            }
            else
            {
            printf("%-9s %5d %10.4f",pg->groupname,
                   pg->num_jobs,(pg->wall_time/60));
            if (f_cpu) {
                printf(" %10.4f",(pg->cpu_time/60));
                if (f_stat) printf("   %6.2f",(pg->cpu_time/60)*100/(pg->wall_time/60));
            }
            if (f_stat) {
                printf("  %10.4f",((pg->wall_time/60)/pg->num_jobs));
                if (f_cpu) printf(" %10.4f",((pg->cpu_time/60)/pg->num_jobs));
                printf("    %5.1f",(float)(pg->nodes/pg->num_jobs));
            }
            printf(" %13.4f",(pg->all_wall_time/60));
            if (f_cpu) printf("%13.4f",(pg->all_cpu_time/60));
            if (f_bill) {
                switch(opt) {
                    case 0:
                        total = value * pg->cpu_time/60;
                        break;
                    case 1:
                        total = value * pg->wall_time/60;
                        break;
                    case 2:
                        total = value * pg->all_cpu_time/60;
                        break;
                    case 3:
                        total = value * pg->all_wall_time/60;
                        break;
                }
                printf("%14.2f",total);
            }
            }
            printf("\n");
            pg = pg->p_next;
        }
    }
}
