//
//  alloc.cpp
//  pbsAccounting
//
//  Created by Fabio Roberto Vitello on 16/06/17.
//  Copyright © 2017 Fabio Roberto Vitello. All rights reserved.
//

#include "alloc.hpp"

/* $Id: alloc.c,v 1.1.1.1 2006/03/13 18:31:16 bino Exp $ */

#include <stdlib.h>
#include <string.h>
#include "main.h"

/* Allocation new group */
GROUP * new_group()
{
    GROUP *ptr;
    
    ptr = (GROUP *)malloc(sizeof(GROUP));
    if (ptr != NULL) {
        ptr->groupname[0]  = '\0';
        ptr->num_jobs      = 0;
        ptr->nodes         = 0;
        ptr->cpu_time      = 0.0;
        ptr->wall_time     = 0.0;
        ptr->all_cpu_time  = 0.0;
        ptr->all_wall_time = 0.0;
        ptr->p_next        = NULL;
        return(ptr);
    } else
        return(NULL);
}

/* Allocation new user */
USER * new_user()
{
    USER *ptr;
    
    ptr = (USER *)malloc(sizeof(USER));
    if (ptr != NULL) {
        ptr->username[0]   = '\0';
        ptr->num_jobs      = 0;
        ptr->nodes         = 0;
        ptr->cpu_time      = 0.0;
        ptr->wall_time     = 0.0;
        ptr->all_cpu_time  = 0.0;
        ptr->all_wall_time = 0.0;
        ptr->pg            = NULL;
        ptr->p_next        = NULL;
        return(ptr);
    } else
        return(NULL);
}


/* Clean groups */
void clean_groups(GROUP *ptr)
{
    GROUP *ptr_aux;
    
    while (ptr != NULL) {
        ptr_aux = ptr;
        ptr = ptr->p_next;
        free(ptr_aux);
    }
}

/* Clean users */
void clean_users(USER *ptr)
{
    USER *ptr_aux;
    
    while (ptr != NULL) {
        ptr_aux = ptr;
        ptr = ptr->p_next;
        free(ptr_aux);
    }
}
