//
//  main.h
//  pbsAccounting
//
//  Created by Fabio Roberto Vitello on 16/06/17.
//  Copyright © 2017 Fabio Roberto Vitello. All rights reserved.
//

#ifndef main_h
#define main_h

#include "read.hpp"
#include "print.hpp"
#include "alloc.hpp"

/* $Id: pbsacct.h,v 1.1.1.1 2006/03/13 18:31:16 bino Exp $ */

#define MAX_HOSTNAME_SIZE 256      /* max length of hostname */
#define MAX_NAME_SIZE     20       /* max length of name     */

typedef struct group GROUP;
typedef struct user  USER;

struct group {
    char   groupname[MAX_NAME_SIZE];
    int    num_jobs;
    int    nodes;
    double cpu_time;
    double wall_time;
    double all_cpu_time;
    double all_wall_time;
    GROUP  *p_next;
};

struct user {
    char   username[MAX_NAME_SIZE];
    int    num_jobs;
    int    nodes;
    double cpu_time;
    double wall_time;
    double all_cpu_time;
    double all_wall_time;
    GROUP  *pg;
    USER   *p_next;
};

/* global variables */
extern GROUP  *pgroups;
extern USER   *pusers;
extern int    f_user, f_group, f_bill, f_stat, f_cpu, f_stdin, opt;
extern char   unit[4];
extern double value;
extern int cpuvalue;


/* functions */
extern GROUP * new_group();
extern USER  * new_user();

#endif /* main_h */
