//
//  ShowTableViewController.m
//  VisIVOMobile
//
//  Created by Fabio Vitello on 9/03/12.
//  Copyright 2012 nothing. All rights reserved.
//

#import "ShowTableViewController.h"
//#import "CustomCellShowData.h"
#import "CustomCellView.h"
#import "ShowFieldViewController.h"



#import "SHKItem.h"
#import "SHKActionSheet.h"
#import "SHK.h"
#import "SHKFacebook.h"
#import "SHKMail.h"

#import "SHKConfiguration.h"

@implementation ShowTableViewController

@synthesize dataSource;

-(id) initWithVbtId:(NSString *)id andFileName:(NSString *)name andFileType:(int)t {
	if(self = [super init]){
        
        screenFrame = [[UIScreen mainScreen] bounds];
        
        vbtId=id;
        type=t;
        dataSource2 = [[NSMutableDictionary alloc] init];
        
        
        myTableView = [[UITableView alloc] initWithFrame:CGRectMake(screenFrame.origin.x, 
                                                                    screenFrame.origin.y, 
                                                                    screenFrame.size.width, 
                                                                    screenFrame.size.height)\
                                                   style:UITableViewStyleGrouped];
        
        
        myTableView.delegate = self;
        myTableView.dataSource = self;
        
        
        
        
        [self setView:myTableView];
        
        self.navigationItem.title=name;
        
        UIBarButtonItem *actionButton= [[UIBarButtonItem alloc ] initWithBarButtonSystemItem:UIBarButtonSystemItemAction target:self action:@selector(showOptions)];
        self.navigationItem.rightBarButtonItem = actionButton;
        [actionButton release];
        
        
        
        
        
        float diff=screenFrame.size.width-alert.bounds.size.width;
        
        indicator=[[UIActivityIndicatorView alloc]initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
        indicator.center =CGPointMake(screenFrame.size.width/2-diff/2,70);
        [indicator startAnimating];
        [alert addSubview:indicator];
        [indicator release];
        
        
        NSString *par=@"";
        if(type==2)
        {
            par=[NSString stringWithFormat:@"vbtId=%@&op=vbt_point",vbtId];
        }
        else if(type==3)
        {
            par=[NSString stringWithFormat:@"vbtId=%@&op=vbt_vol",vbtId];
        }
        
 //       dbHelper=[[DbHelper alloc]initWithReference:@"http://visivo-server.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
        dbHelper=[[DbHelper alloc]initWithReference:@"http://visivoportal.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
        dbHelper.delegate = self;
        dbHelper.delegateMethod = @selector(parseData:);
        dbHelper.delegateErrorMethod=@selector(parseError:);
        
        
        [dbHelper setPostParameter:par];
        
    }
	return self;
}

#pragma mark -
#pragma mark ActionSheetDelegate

- (void) showOptions
{
    NSArray *array = [[NSArray alloc] initWithObjects:
                      [NSString stringWithString:@"Send by Mail"],
                      nil];
    
    UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:@"Action"
                                                             delegate:self
                                                    cancelButtonTitle:nil
                                               destructiveButtonTitle:nil
                                                    otherButtonTitles:nil];
    
        
        [actionSheet addButtonWithTitle:[array objectAtIndex:0]];
        
    
    
    [actionSheet addButtonWithTitle:@"Cancel"];
    actionSheet.destructiveButtonIndex=1;
    
    [actionSheet showFromTabBar:self.tabBarController.tabBar];
}

- (void)actionSheet:(UIActionSheet *)actionSheet willDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if(buttonIndex == actionSheet.destructiveButtonIndex)
    {
    }
    else if(buttonIndex == 0) //Send mail Button
    {

        //   NSString *urlVBT=[NSString stringWithFormat:@"http://visivo-server.oact.inaf.it%@",[dataSource objectForKey:@"Path"]];
        NSString *urlVBT=[NSString stringWithFormat:@"http://visivoportal.oact.inaf.it%@",[dataSource objectForKey:@"Path"]];
        
        NSString *string=[NSString stringWithFormat:@"Table: \n%@ Header: \n%@.head",urlVBT,urlVBT];
        
        
        
        SHKItem *item = [SHKItem text:string];
        [SHKMail shareItem:item];
        
    }
    
}


#pragma mark -

-(void)parseError:(id)sender
{
    
	//Avviso l'utente che c'e' stato un errore durante la connessione al server
	UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle: NSLocalizedString(@"conn_error",@"") 
															 delegate:nil 
													cancelButtonTitle:@"OK" 
											   destructiveButtonTitle:nil 
													otherButtonTitles:nil]; 
	
	
	[actionSheet showInView:[[self view] window]];
	[actionSheet release];     
	
}


-(void)parseData:(id)sender {
	
	DbHelper *tmpConnection = (DbHelper *)sender;
	
    [dataSource2 setDictionary:tmpConnection.receivedDictionary ];
    
    
    [myTableView reloadData];
    
}


#pragma mark -
#pragma mark Table view data source


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 2;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    // Return the number of rows in the section.
    if (section==0) {
        return 1;

    }
    else     
    {
        if(type==2)
            return 4;
       // else if(type==3)
       //    return 10;
    }
    //if section!=0 and type!=2
    return 10;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    
    static NSString *CellIdentifier = @"Cell";
    
    CustomCellView *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
   // CustomCellShowData *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[CustomCellView alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier type:2] autorelease];
       // cell = [[[CustomCellShowData alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
    NSArray *allRows = [dataSource2 objectForKey:@"results"];
    
    NSMutableDictionary *tmpDataSource = [allRows objectAtIndex:0];

    if (indexPath.section == 0)
    {
        cell.primaryLabel.text=@"Creation Date";
        cell.secondaryLabel.text=[dataSource objectForKey:@"Date"];
    }
    else if (indexPath.section == 1)
    {
        // Set up the cell…
        switch (indexPath.row) {
            case 0:
                cell.primaryLabel.text = @"# of elements";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"Number_Of_Elements"];
                break;
            case 1:
                cell.primaryLabel.text = @"Type";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"Type_of_data"];
    
                break;
            case 2:
                cell.primaryLabel.text = @"Endianism";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"Endianism"];
                break;
            case 3: 
                cell.primaryLabel.text = @"Number of field";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"Number_of_fields"];
                cell.myImageViewEnd.image = [UIImage imageNamed:@"arrow.png"];
                
                break;
            case 4: 
                cell.primaryLabel.text = @"X cell number";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"XCellNumber"];
                
                break;
            case 5: 
                cell.primaryLabel.text = @"Y cell number";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"YCellNumber"];
                
                break;
            case 6: 
                cell.primaryLabel.text = @"Z cell number";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"ZCellNumber"];
                
                break;
            case 7: 
                cell.primaryLabel.text = @"X cell width";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"XCellWidth"];
                
                break;
            case 8: 
                cell.primaryLabel.text = @"Y cell width";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"YCellWidth"];
                
                break;
            case 9: 
                cell.primaryLabel.text = @"Z cell width";
                cell.secondaryLabel.text =[tmpDataSource objectForKey:@"ZCellWidth"];
                
                break;
                
        }   
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 1)
    {
        if (indexPath.row == 3)
        {
            ShowFieldViewController *showFieldVC = [[ShowFieldViewController alloc] initWithVbtId:vbtId];
            
            [self.navigationController pushViewController:showFieldVC animated:YES];
            [showFieldVC release];

        }
    }

}


- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
