//
//  ShowPictureViewController.m
//  VisIVOSmart
//
//  Created by Fabio Roberto Vitello on 12/03/12.
//  Copyright (c) 2012 nothing. All rights reserved.
//

#import "ShowPictureViewController.h"
#import "ImageDetailViewController.h"

//#import "ShareKit/Core/SHK.h"
//#import "ShareKit/Sharers/Services/Facebook/SHKFacebook.h"

#import "SHKItem.h"
#import "SHKActionSheet.h"
#import "SHK.h"
#import "SHKFacebook.h"
#import "SHKMail.h"

#import "SHKConfiguration.h"


@implementation ShowPictureViewController

@synthesize dataSource;
//@synthesize facebook;

-(id) init {
	if(self = [super init]){
        
        screenFrame = [[UIScreen mainScreen] bounds];
         
        UIBarButtonItem *actionButton= [[UIBarButtonItem alloc ] initWithBarButtonSystemItem:UIBarButtonSystemItemAction target:self action:@selector(showOptions)];
        self.navigationItem.rightBarButtonItem = actionButton;
		[actionButton release];

             

        
       	}
	return self;
}
/*
// Pre iOS 4.2 support
- (BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url {
    return [facebook handleOpenURL:url]; 
}

// For iOS 4.2+ support
- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url
  sourceApplication:(NSString *)sourceApplication annotation:(id)annotation {
    return [facebook handleOpenURL:url]; 
}

- (void)fbDidLogin {
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:[facebook accessToken] forKey:@"FBAccessTokenKey"];
    [defaults setObject:[facebook expirationDate] forKey:@"FBExpirationDateKey"];
    [defaults synchronize];
    
}
*/

- (void) showOptions
{
    NSArray *array = [[NSArray alloc] initWithObjects:
                      [NSString stringWithString:@"Info"],
                      [NSString stringWithString:@"Share on Facebook"],
                      [NSString stringWithString:@"Send by Mail"],
                      nil];
    
    UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:@"Action"
                                                             delegate:self
                                                    cancelButtonTitle:nil
                                               destructiveButtonTitle:nil
                                                    otherButtonTitles:nil];
    
    for (int i = 0; i <= 2; i++) {
        
        [actionSheet addButtonWithTitle:[array objectAtIndex:i]];
        
    }
    
    
    
    [actionSheet addButtonWithTitle:@"Cancel"];
    actionSheet.destructiveButtonIndex=3;
    
    [actionSheet showFromTabBar:self.tabBarController.tabBar];
}

- (void)actionSheet:(UIActionSheet *)actionSheet willDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if(buttonIndex == actionSheet.destructiveButtonIndex)
    {
    }
    else if(buttonIndex == 0) //INFO Button
    {
        ImageDetailViewController *detailPictVC = [[ImageDetailViewController alloc] initWithImgId:[dataSource objectForKey:@"Id"]];
        
        //Mostro la view associata al view controller creato pushandolo nel mio navigation controller
        [self.navigationController pushViewController:detailPictVC animated:YES];
        [detailPictVC release];
    }
    else if(buttonIndex == 1) //Share on facebook Button
    {
        
        /*
         //Here you load ShareKit submodule with app specific configuration
         DefaultSHKConfigurator *configurator = [[DefaultSHKConfigurator alloc] init];
         [SHKConfiguration sharedInstanceWithConfigurator:configurator];
         [configurator release];
         */
        SHKItem *item = [SHKItem image:imageview.image title:@""];
        // SHKActionSheet *actionSheet = [SHKActionSheet actionSheetForItem:item];
        
        //[actionSheet showFromToolbar:self.navigationController.toolbar];
        

        [SHKFacebook shareItem:item];
        
        
    }
    else if(buttonIndex == 2) //Send mail Button
    {
        SHKItem *item = [SHKItem image:imageview.image title:@""];
        [SHKMail shareItem:item];
                
        
    }
    
}


- (void) loadImageInBackground {
    
	    
    
    NSString *urlAddress = [dataSource objectForKey:@"Path"];
    urlAddress = [urlAddress stringByReplacingOccurrencesOfString:@"/VisIVOWeb/" withString:@"http://visivoportal.oact.inaf.it/VisIVOWeb/"];
 //   urlAddress = [urlAddress stringByReplacingOccurrencesOfString:@"/VisIVOWeb/" withString:@"http://visivo-server.oact.inaf.it/VisIVOWeb/"];
    
    
	// Retrieve the remote image
	NSURL *imgURL = [NSURL URLWithString:urlAddress];
    
	NSData *imgData = [NSData dataWithContentsOfURL:imgURL];
	UIImage *img    = [[UIImage alloc] initWithData:imgData];
	
	// Image retrieved, call main thread method to update image, passing it the downloaded UIImage
	[self performSelectorOnMainThread:@selector(assignImage:) withObject:img waitUntilDone:YES];
		
}

- (void) assignImage:(UIImage *)img
{
		
    imageview= [[UIImageView alloc] initWithImage: img];
    
    [imageview setImage:img]; 
    
    UIScrollView* scrollView =[[UIScrollView alloc] initWithFrame:screenFrame];
    scrollView.contentSize = CGSizeMake(imageview.frame.size.width , imageview.frame.size.height);
    scrollView.maximumZoomScale = 100;
    scrollView.minimumZoomScale = 0.5;
    scrollView.contentOffset= CGPointMake(imageview.frame.size.width/3, imageview.frame.size.height/4);
    
    scrollView.clipsToBounds = YES;
    scrollView.delegate = self;
    
    
    [scrollView addSubview:imageview];
    
    
    [self.view addSubview:scrollView];
    
    
    [imageview release];
    [scrollView release];
	
    [alert dismissWithClickedButtonIndex:0 animated:YES];

	
}



- (void)loadView {
	
	
    
	UIView *mainScreen= [[UIView alloc] initWithFrame:screenFrame];	
	[mainScreen setBackgroundColor:[UIColor whiteColor]];
    
    [self setView:mainScreen];
    [mainScreen release];

    
    alert=[[UIAlertView alloc] initWithTitle: NSLocalizedString(@"loading",@"") message:nil delegate:self cancelButtonTitle:nil otherButtonTitles:nil];
    
    [alert show];
    
    float diff=screenFrame.size.width-alert.bounds.size.width;
    
    indicator=[[UIActivityIndicatorView alloc]initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
    indicator.center =CGPointMake(screenFrame.size.width/2-diff/2,70);
    [indicator startAnimating];
    [alert addSubview:indicator];
    [indicator release];
    
    [self performSelectorInBackground:@selector(loadImageInBackground) withObject:nil];
    



    
}

-(UIView *) viewForZoomingInScrollView:(UIScrollView *)inScroll {
    return imageview;
}



- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
