/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */

#import <Foundation/Foundation.h>

#import "TProtocol.h"
#import "TApplicationException.h"
#import "TProtocolUtil.h"
#import "TProcessor.h"

#import "Types.h"
#import "Errors.h"

@interface EDAMPublicUserInfo : NSObject <NSCoding> {
  EDAMUserID __userId;
  NSString * __shardId;
  int __privilege;
  NSString * __username;

  BOOL __userId_isset;
  BOOL __shardId_isset;
  BOOL __privilege_isset;
  BOOL __username_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=userId, setter=setUserId:) EDAMUserID userId;
@property (nonatomic, retain, getter=shardId, setter=setShardId:) NSString * shardId;
@property (nonatomic, getter=privilege, setter=setPrivilege:) int privilege;
@property (nonatomic, retain, getter=username, setter=setUsername:) NSString * username;
#endif

- (id) initWithUserId: (EDAMUserID) userId shardId: (NSString *) shardId privilege: (int) privilege username: (NSString *) username;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMUserID) userId;
- (void) setUserId: (EDAMUserID) userId;
- (BOOL) userIdIsSet;

- (NSString *) shardId;
- (void) setShardId: (NSString *) shardId;
- (BOOL) shardIdIsSet;

- (int) privilege;
- (void) setPrivilege: (int) privilege;
- (BOOL) privilegeIsSet;

- (NSString *) username;
- (void) setUsername: (NSString *) username;
- (BOOL) usernameIsSet;

@end

@interface EDAMAuthenticationResult : NSObject <NSCoding> {
  EDAMTimestamp __currentTime;
  NSString * __authenticationToken;
  EDAMTimestamp __expiration;
  EDAMUser * __user;
  EDAMPublicUserInfo * __publicUserInfo;

  BOOL __currentTime_isset;
  BOOL __authenticationToken_isset;
  BOOL __expiration_isset;
  BOOL __user_isset;
  BOOL __publicUserInfo_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=currentTime, setter=setCurrentTime:) EDAMTimestamp currentTime;
@property (nonatomic, retain, getter=authenticationToken, setter=setAuthenticationToken:) NSString * authenticationToken;
@property (nonatomic, getter=expiration, setter=setExpiration:) EDAMTimestamp expiration;
@property (nonatomic, retain, getter=user, setter=setUser:) EDAMUser * user;
@property (nonatomic, retain, getter=publicUserInfo, setter=setPublicUserInfo:) EDAMPublicUserInfo * publicUserInfo;
#endif

- (id) initWithCurrentTime: (EDAMTimestamp) currentTime authenticationToken: (NSString *) authenticationToken expiration: (EDAMTimestamp) expiration user: (EDAMUser *) user publicUserInfo: (EDAMPublicUserInfo *) publicUserInfo;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMTimestamp) currentTime;
- (void) setCurrentTime: (EDAMTimestamp) currentTime;
- (BOOL) currentTimeIsSet;

- (NSString *) authenticationToken;
- (void) setAuthenticationToken: (NSString *) authenticationToken;
- (BOOL) authenticationTokenIsSet;

- (EDAMTimestamp) expiration;
- (void) setExpiration: (EDAMTimestamp) expiration;
- (BOOL) expirationIsSet;

- (EDAMUser *) user;
- (void) setUser: (EDAMUser *) user;
- (BOOL) userIsSet;

- (EDAMPublicUserInfo *) publicUserInfo;
- (void) setPublicUserInfo: (EDAMPublicUserInfo *) publicUserInfo;
- (BOOL) publicUserInfoIsSet;

@end

@protocol EDAMUserStore <NSObject>
- (BOOL) checkVersion: (NSString *) clientName : (int16_t) edamVersionMajor : (int16_t) edamVersionMinor;  // throws TException
- (EDAMAuthenticationResult *) authenticate: (NSString *) username : (NSString *) password : (NSString *) consumerKey : (NSString *) consumerSecret;  // throws EDAMUserException *, EDAMSystemException *, TException
- (EDAMAuthenticationResult *) refreshAuthentication: (NSString *) authenticationToken;  // throws EDAMUserException *, EDAMSystemException *, TException
- (EDAMUser *) getUser: (NSString *) authenticationToken;  // throws EDAMUserException *, EDAMSystemException *, TException
- (EDAMPublicUserInfo *) getPublicUserInfo: (NSString *) username;  // throws EDAMNotFoundException *, EDAMSystemException *, EDAMUserException *, TException
@end

@interface EDAMUserStoreClient : NSObject <EDAMUserStore> {
  id <TProtocol> inProtocol;
  id <TProtocol> outProtocol;
}
- (id) initWithProtocol: (id <TProtocol>) protocol;
- (id) initWithInProtocol: (id <TProtocol>) inProtocol outProtocol: (id <TProtocol>) outProtocol;
@end

@interface EDAMUserStoreProcessor : NSObject <TProcessor> {
  id <EDAMUserStore> mService;
  NSDictionary * mMethodMap;
}
- (id) initWithUserStore: (id <EDAMUserStore>) service;
- (id<EDAMUserStore>) service;
@end

@interface EDAMUserStoreConstants : NSObject {
}
+ (int16_t) EDAM_VERSION_MAJOR;
+ (int16_t) EDAM_VERSION_MINOR;
@end
