/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */

#import <Foundation/Foundation.h>

#import "TProtocol.h"
#import "TApplicationException.h"
#import "TProtocolUtil.h"
#import "TProcessor.h"

#import "EDAMLimits.h"

enum EDAMPrivilegeLevel {
  PrivilegeLevel_NORMAL = 1,
  PrivilegeLevel_PREMIUM = 3,
  PrivilegeLevel_MANAGER = 7,
  PrivilegeLevel_SUPPORT = 8,
  PrivilegeLevel_ADMIN = 9
};

enum EDAMQueryFormat {
  QueryFormat_USER = 1,
  QueryFormat_SEXP = 2
};

enum EDAMNoteSortOrder {
  NoteSortOrder_CREATED = 1,
  NoteSortOrder_UPDATED = 2,
  NoteSortOrder_RELEVANCE = 3,
  NoteSortOrder_UPDATE_SEQUENCE_NUMBER = 4,
  NoteSortOrder_TITLE = 5
};

enum EDAMPremiumOrderStatus {
  PremiumOrderStatus_NONE = 0,
  PremiumOrderStatus_PENDING = 1,
  PremiumOrderStatus_ACTIVE = 2,
  PremiumOrderStatus_FAILED = 3,
  PremiumOrderStatus_CANCELLATION_PENDING = 4,
  PremiumOrderStatus_CANCELED = 5
};

typedef int32_t EDAMUserID;

typedef NSString * EDAMGuid;

typedef int64_t EDAMTimestamp;

@interface EDAMData : NSObject <NSCoding> {
  NSData * __bodyHash;
  int32_t __size;
  NSData * __body;

  BOOL __bodyHash_isset;
  BOOL __size_isset;
  BOOL __body_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=bodyHash, setter=setBodyHash:) NSData * bodyHash;
@property (nonatomic, getter=size, setter=setSize:) int32_t size;
@property (nonatomic, retain, getter=body, setter=setBody:) NSData * body;
#endif

- (id) initWithBodyHash: (NSData *) bodyHash size: (int32_t) size body: (NSData *) body;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (NSData *) bodyHash;
- (void) setBodyHash: (NSData *) bodyHash;
- (BOOL) bodyHashIsSet;

- (int32_t) size;
- (void) setSize: (int32_t) size;
- (BOOL) sizeIsSet;

- (NSData *) body;
- (void) setBody: (NSData *) body;
- (BOOL) bodyIsSet;

@end

@interface EDAMUserAttributes : NSObject <NSCoding> {
  NSString * __defaultLocationName;
  double __defaultLatitude;
  double __defaultLongitude;
  BOOL __preactivation;
  NSArray * __viewedPromotions;
  NSString * __incomingEmailAddress;
  NSArray * __recentMailedAddresses;
  NSString * __comments;
  EDAMTimestamp __dateAgreedToTermsOfService;
  int32_t __maxReferrals;
  int32_t __referralCount;
  NSString * __refererCode;
  EDAMTimestamp __sentEmailDate;
  int32_t __sentEmailCount;
  int32_t __dailyEmailLimit;
  EDAMTimestamp __emailOptOutDate;
  EDAMTimestamp __partnerEmailOptInDate;
  NSString * __preferredLanguage;
  NSString * __preferredCountry;
  BOOL __clipFullPage;
  NSString * __twitterUserName;
  NSString * __twitterId;
  NSString * __groupName;
  NSString * __recognitionLanguage;
  int64_t __customerProfileId;
  NSString * __referralProof;

  BOOL __defaultLocationName_isset;
  BOOL __defaultLatitude_isset;
  BOOL __defaultLongitude_isset;
  BOOL __preactivation_isset;
  BOOL __viewedPromotions_isset;
  BOOL __incomingEmailAddress_isset;
  BOOL __recentMailedAddresses_isset;
  BOOL __comments_isset;
  BOOL __dateAgreedToTermsOfService_isset;
  BOOL __maxReferrals_isset;
  BOOL __referralCount_isset;
  BOOL __refererCode_isset;
  BOOL __sentEmailDate_isset;
  BOOL __sentEmailCount_isset;
  BOOL __dailyEmailLimit_isset;
  BOOL __emailOptOutDate_isset;
  BOOL __partnerEmailOptInDate_isset;
  BOOL __preferredLanguage_isset;
  BOOL __preferredCountry_isset;
  BOOL __clipFullPage_isset;
  BOOL __twitterUserName_isset;
  BOOL __twitterId_isset;
  BOOL __groupName_isset;
  BOOL __recognitionLanguage_isset;
  BOOL __customerProfileId_isset;
  BOOL __referralProof_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=defaultLocationName, setter=setDefaultLocationName:) NSString * defaultLocationName;
@property (nonatomic, getter=defaultLatitude, setter=setDefaultLatitude:) double defaultLatitude;
@property (nonatomic, getter=defaultLongitude, setter=setDefaultLongitude:) double defaultLongitude;
@property (nonatomic, getter=preactivation, setter=setPreactivation:) BOOL preactivation;
@property (nonatomic, retain, getter=viewedPromotions, setter=setViewedPromotions:) NSArray * viewedPromotions;
@property (nonatomic, retain, getter=incomingEmailAddress, setter=setIncomingEmailAddress:) NSString * incomingEmailAddress;
@property (nonatomic, retain, getter=recentMailedAddresses, setter=setRecentMailedAddresses:) NSArray * recentMailedAddresses;
@property (nonatomic, retain, getter=comments, setter=setComments:) NSString * comments;
@property (nonatomic, getter=dateAgreedToTermsOfService, setter=setDateAgreedToTermsOfService:) EDAMTimestamp dateAgreedToTermsOfService;
@property (nonatomic, getter=maxReferrals, setter=setMaxReferrals:) int32_t maxReferrals;
@property (nonatomic, getter=referralCount, setter=setReferralCount:) int32_t referralCount;
@property (nonatomic, retain, getter=refererCode, setter=setRefererCode:) NSString * refererCode;
@property (nonatomic, getter=sentEmailDate, setter=setSentEmailDate:) EDAMTimestamp sentEmailDate;
@property (nonatomic, getter=sentEmailCount, setter=setSentEmailCount:) int32_t sentEmailCount;
@property (nonatomic, getter=dailyEmailLimit, setter=setDailyEmailLimit:) int32_t dailyEmailLimit;
@property (nonatomic, getter=emailOptOutDate, setter=setEmailOptOutDate:) EDAMTimestamp emailOptOutDate;
@property (nonatomic, getter=partnerEmailOptInDate, setter=setPartnerEmailOptInDate:) EDAMTimestamp partnerEmailOptInDate;
@property (nonatomic, retain, getter=preferredLanguage, setter=setPreferredLanguage:) NSString * preferredLanguage;
@property (nonatomic, retain, getter=preferredCountry, setter=setPreferredCountry:) NSString * preferredCountry;
@property (nonatomic, getter=clipFullPage, setter=setClipFullPage:) BOOL clipFullPage;
@property (nonatomic, retain, getter=twitterUserName, setter=setTwitterUserName:) NSString * twitterUserName;
@property (nonatomic, retain, getter=twitterId, setter=setTwitterId:) NSString * twitterId;
@property (nonatomic, retain, getter=groupName, setter=setGroupName:) NSString * groupName;
@property (nonatomic, retain, getter=recognitionLanguage, setter=setRecognitionLanguage:) NSString * recognitionLanguage;
@property (nonatomic, getter=customerProfileId, setter=setCustomerProfileId:) int64_t customerProfileId;
@property (nonatomic, retain, getter=referralProof, setter=setReferralProof:) NSString * referralProof;
#endif

- (id) initWithDefaultLocationName: (NSString *) defaultLocationName defaultLatitude: (double) defaultLatitude defaultLongitude: (double) defaultLongitude preactivation: (BOOL) preactivation viewedPromotions: (NSArray *) viewedPromotions incomingEmailAddress: (NSString *) incomingEmailAddress recentMailedAddresses: (NSArray *) recentMailedAddresses comments: (NSString *) comments dateAgreedToTermsOfService: (EDAMTimestamp) dateAgreedToTermsOfService maxReferrals: (int32_t) maxReferrals referralCount: (int32_t) referralCount refererCode: (NSString *) refererCode sentEmailDate: (EDAMTimestamp) sentEmailDate sentEmailCount: (int32_t) sentEmailCount dailyEmailLimit: (int32_t) dailyEmailLimit emailOptOutDate: (EDAMTimestamp) emailOptOutDate partnerEmailOptInDate: (EDAMTimestamp) partnerEmailOptInDate preferredLanguage: (NSString *) preferredLanguage preferredCountry: (NSString *) preferredCountry clipFullPage: (BOOL) clipFullPage twitterUserName: (NSString *) twitterUserName twitterId: (NSString *) twitterId groupName: (NSString *) groupName recognitionLanguage: (NSString *) recognitionLanguage customerProfileId: (int64_t) customerProfileId referralProof: (NSString *) referralProof;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (NSString *) defaultLocationName;
- (void) setDefaultLocationName: (NSString *) defaultLocationName;
- (BOOL) defaultLocationNameIsSet;

- (double) defaultLatitude;
- (void) setDefaultLatitude: (double) defaultLatitude;
- (BOOL) defaultLatitudeIsSet;

- (double) defaultLongitude;
- (void) setDefaultLongitude: (double) defaultLongitude;
- (BOOL) defaultLongitudeIsSet;

- (BOOL) preactivation;
- (void) setPreactivation: (BOOL) preactivation;
- (BOOL) preactivationIsSet;

- (NSArray *) viewedPromotions;
- (void) setViewedPromotions: (NSArray *) viewedPromotions;
- (BOOL) viewedPromotionsIsSet;

- (NSString *) incomingEmailAddress;
- (void) setIncomingEmailAddress: (NSString *) incomingEmailAddress;
- (BOOL) incomingEmailAddressIsSet;

- (NSArray *) recentMailedAddresses;
- (void) setRecentMailedAddresses: (NSArray *) recentMailedAddresses;
- (BOOL) recentMailedAddressesIsSet;

- (NSString *) comments;
- (void) setComments: (NSString *) comments;
- (BOOL) commentsIsSet;

- (EDAMTimestamp) dateAgreedToTermsOfService;
- (void) setDateAgreedToTermsOfService: (EDAMTimestamp) dateAgreedToTermsOfService;
- (BOOL) dateAgreedToTermsOfServiceIsSet;

- (int32_t) maxReferrals;
- (void) setMaxReferrals: (int32_t) maxReferrals;
- (BOOL) maxReferralsIsSet;

- (int32_t) referralCount;
- (void) setReferralCount: (int32_t) referralCount;
- (BOOL) referralCountIsSet;

- (NSString *) refererCode;
- (void) setRefererCode: (NSString *) refererCode;
- (BOOL) refererCodeIsSet;

- (EDAMTimestamp) sentEmailDate;
- (void) setSentEmailDate: (EDAMTimestamp) sentEmailDate;
- (BOOL) sentEmailDateIsSet;

- (int32_t) sentEmailCount;
- (void) setSentEmailCount: (int32_t) sentEmailCount;
- (BOOL) sentEmailCountIsSet;

- (int32_t) dailyEmailLimit;
- (void) setDailyEmailLimit: (int32_t) dailyEmailLimit;
- (BOOL) dailyEmailLimitIsSet;

- (EDAMTimestamp) emailOptOutDate;
- (void) setEmailOptOutDate: (EDAMTimestamp) emailOptOutDate;
- (BOOL) emailOptOutDateIsSet;

- (EDAMTimestamp) partnerEmailOptInDate;
- (void) setPartnerEmailOptInDate: (EDAMTimestamp) partnerEmailOptInDate;
- (BOOL) partnerEmailOptInDateIsSet;

- (NSString *) preferredLanguage;
- (void) setPreferredLanguage: (NSString *) preferredLanguage;
- (BOOL) preferredLanguageIsSet;

- (NSString *) preferredCountry;
- (void) setPreferredCountry: (NSString *) preferredCountry;
- (BOOL) preferredCountryIsSet;

- (BOOL) clipFullPage;
- (void) setClipFullPage: (BOOL) clipFullPage;
- (BOOL) clipFullPageIsSet;

- (NSString *) twitterUserName;
- (void) setTwitterUserName: (NSString *) twitterUserName;
- (BOOL) twitterUserNameIsSet;

- (NSString *) twitterId;
- (void) setTwitterId: (NSString *) twitterId;
- (BOOL) twitterIdIsSet;

- (NSString *) groupName;
- (void) setGroupName: (NSString *) groupName;
- (BOOL) groupNameIsSet;

- (NSString *) recognitionLanguage;
- (void) setRecognitionLanguage: (NSString *) recognitionLanguage;
- (BOOL) recognitionLanguageIsSet;

- (int64_t) customerProfileId;
- (void) setCustomerProfileId: (int64_t) customerProfileId;
- (BOOL) customerProfileIdIsSet;

- (NSString *) referralProof;
- (void) setReferralProof: (NSString *) referralProof;
- (BOOL) referralProofIsSet;

@end

@interface EDAMAccounting : NSObject <NSCoding> {
  int64_t __uploadLimit;
  EDAMTimestamp __uploadLimitEnd;
  int64_t __uploadLimitNextMonth;
  int __premiumServiceStatus;
  NSString * __premiumOrderNumber;
  NSString * __premiumCommerceService;
  EDAMTimestamp __premiumServiceStart;
  NSString * __premiumServiceSKU;
  EDAMTimestamp __lastSuccessfulCharge;
  EDAMTimestamp __lastFailedCharge;
  NSString * __lastFailedChargeReason;
  EDAMTimestamp __nextPaymentDue;
  EDAMTimestamp __premiumLockUntil;
  EDAMTimestamp __updated;
  NSString * __premiumSubscriptionNumber;
  EDAMTimestamp __lastRequestedCharge;

  BOOL __uploadLimit_isset;
  BOOL __uploadLimitEnd_isset;
  BOOL __uploadLimitNextMonth_isset;
  BOOL __premiumServiceStatus_isset;
  BOOL __premiumOrderNumber_isset;
  BOOL __premiumCommerceService_isset;
  BOOL __premiumServiceStart_isset;
  BOOL __premiumServiceSKU_isset;
  BOOL __lastSuccessfulCharge_isset;
  BOOL __lastFailedCharge_isset;
  BOOL __lastFailedChargeReason_isset;
  BOOL __nextPaymentDue_isset;
  BOOL __premiumLockUntil_isset;
  BOOL __updated_isset;
  BOOL __premiumSubscriptionNumber_isset;
  BOOL __lastRequestedCharge_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=uploadLimit, setter=setUploadLimit:) int64_t uploadLimit;
@property (nonatomic, getter=uploadLimitEnd, setter=setUploadLimitEnd:) EDAMTimestamp uploadLimitEnd;
@property (nonatomic, getter=uploadLimitNextMonth, setter=setUploadLimitNextMonth:) int64_t uploadLimitNextMonth;
@property (nonatomic, getter=premiumServiceStatus, setter=setPremiumServiceStatus:) int premiumServiceStatus;
@property (nonatomic, retain, getter=premiumOrderNumber, setter=setPremiumOrderNumber:) NSString * premiumOrderNumber;
@property (nonatomic, retain, getter=premiumCommerceService, setter=setPremiumCommerceService:) NSString * premiumCommerceService;
@property (nonatomic, getter=premiumServiceStart, setter=setPremiumServiceStart:) EDAMTimestamp premiumServiceStart;
@property (nonatomic, retain, getter=premiumServiceSKU, setter=setPremiumServiceSKU:) NSString * premiumServiceSKU;
@property (nonatomic, getter=lastSuccessfulCharge, setter=setLastSuccessfulCharge:) EDAMTimestamp lastSuccessfulCharge;
@property (nonatomic, getter=lastFailedCharge, setter=setLastFailedCharge:) EDAMTimestamp lastFailedCharge;
@property (nonatomic, retain, getter=lastFailedChargeReason, setter=setLastFailedChargeReason:) NSString * lastFailedChargeReason;
@property (nonatomic, getter=nextPaymentDue, setter=setNextPaymentDue:) EDAMTimestamp nextPaymentDue;
@property (nonatomic, getter=premiumLockUntil, setter=setPremiumLockUntil:) EDAMTimestamp premiumLockUntil;
@property (nonatomic, getter=updated, setter=setUpdated:) EDAMTimestamp updated;
@property (nonatomic, retain, getter=premiumSubscriptionNumber, setter=setPremiumSubscriptionNumber:) NSString * premiumSubscriptionNumber;
@property (nonatomic, getter=lastRequestedCharge, setter=setLastRequestedCharge:) EDAMTimestamp lastRequestedCharge;
#endif

- (id) initWithUploadLimit: (int64_t) uploadLimit uploadLimitEnd: (EDAMTimestamp) uploadLimitEnd uploadLimitNextMonth: (int64_t) uploadLimitNextMonth premiumServiceStatus: (int) premiumServiceStatus premiumOrderNumber: (NSString *) premiumOrderNumber premiumCommerceService: (NSString *) premiumCommerceService premiumServiceStart: (EDAMTimestamp) premiumServiceStart premiumServiceSKU: (NSString *) premiumServiceSKU lastSuccessfulCharge: (EDAMTimestamp) lastSuccessfulCharge lastFailedCharge: (EDAMTimestamp) lastFailedCharge lastFailedChargeReason: (NSString *) lastFailedChargeReason nextPaymentDue: (EDAMTimestamp) nextPaymentDue premiumLockUntil: (EDAMTimestamp) premiumLockUntil updated: (EDAMTimestamp) updated premiumSubscriptionNumber: (NSString *) premiumSubscriptionNumber lastRequestedCharge: (EDAMTimestamp) lastRequestedCharge;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (int64_t) uploadLimit;
- (void) setUploadLimit: (int64_t) uploadLimit;
- (BOOL) uploadLimitIsSet;

- (EDAMTimestamp) uploadLimitEnd;
- (void) setUploadLimitEnd: (EDAMTimestamp) uploadLimitEnd;
- (BOOL) uploadLimitEndIsSet;

- (int64_t) uploadLimitNextMonth;
- (void) setUploadLimitNextMonth: (int64_t) uploadLimitNextMonth;
- (BOOL) uploadLimitNextMonthIsSet;

- (int) premiumServiceStatus;
- (void) setPremiumServiceStatus: (int) premiumServiceStatus;
- (BOOL) premiumServiceStatusIsSet;

- (NSString *) premiumOrderNumber;
- (void) setPremiumOrderNumber: (NSString *) premiumOrderNumber;
- (BOOL) premiumOrderNumberIsSet;

- (NSString *) premiumCommerceService;
- (void) setPremiumCommerceService: (NSString *) premiumCommerceService;
- (BOOL) premiumCommerceServiceIsSet;

- (EDAMTimestamp) premiumServiceStart;
- (void) setPremiumServiceStart: (EDAMTimestamp) premiumServiceStart;
- (BOOL) premiumServiceStartIsSet;

- (NSString *) premiumServiceSKU;
- (void) setPremiumServiceSKU: (NSString *) premiumServiceSKU;
- (BOOL) premiumServiceSKUIsSet;

- (EDAMTimestamp) lastSuccessfulCharge;
- (void) setLastSuccessfulCharge: (EDAMTimestamp) lastSuccessfulCharge;
- (BOOL) lastSuccessfulChargeIsSet;

- (EDAMTimestamp) lastFailedCharge;
- (void) setLastFailedCharge: (EDAMTimestamp) lastFailedCharge;
- (BOOL) lastFailedChargeIsSet;

- (NSString *) lastFailedChargeReason;
- (void) setLastFailedChargeReason: (NSString *) lastFailedChargeReason;
- (BOOL) lastFailedChargeReasonIsSet;

- (EDAMTimestamp) nextPaymentDue;
- (void) setNextPaymentDue: (EDAMTimestamp) nextPaymentDue;
- (BOOL) nextPaymentDueIsSet;

- (EDAMTimestamp) premiumLockUntil;
- (void) setPremiumLockUntil: (EDAMTimestamp) premiumLockUntil;
- (BOOL) premiumLockUntilIsSet;

- (EDAMTimestamp) updated;
- (void) setUpdated: (EDAMTimestamp) updated;
- (BOOL) updatedIsSet;

- (NSString *) premiumSubscriptionNumber;
- (void) setPremiumSubscriptionNumber: (NSString *) premiumSubscriptionNumber;
- (BOOL) premiumSubscriptionNumberIsSet;

- (EDAMTimestamp) lastRequestedCharge;
- (void) setLastRequestedCharge: (EDAMTimestamp) lastRequestedCharge;
- (BOOL) lastRequestedChargeIsSet;

@end

@interface EDAMUser : NSObject <NSCoding> {
  EDAMUserID __id;
  NSString * __username;
  NSString * __email;
  NSString * __name;
  NSString * __timezone;
  int __privilege;
  EDAMTimestamp __created;
  EDAMTimestamp __updated;
  EDAMTimestamp __deleted;
  BOOL __active;
  NSString * __shardId;
  EDAMUserAttributes * __attributes;
  EDAMAccounting * __accounting;

  BOOL __id_isset;
  BOOL __username_isset;
  BOOL __email_isset;
  BOOL __name_isset;
  BOOL __timezone_isset;
  BOOL __privilege_isset;
  BOOL __created_isset;
  BOOL __updated_isset;
  BOOL __deleted_isset;
  BOOL __active_isset;
  BOOL __shardId_isset;
  BOOL __attributes_isset;
  BOOL __accounting_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=id, setter=setId:) EDAMUserID id;
@property (nonatomic, retain, getter=username, setter=setUsername:) NSString * username;
@property (nonatomic, retain, getter=email, setter=setEmail:) NSString * email;
@property (nonatomic, retain, getter=name, setter=setName:) NSString * name;
@property (nonatomic, retain, getter=timezone, setter=setTimezone:) NSString * timezone;
@property (nonatomic, getter=privilege, setter=setPrivilege:) int privilege;
@property (nonatomic, getter=created, setter=setCreated:) EDAMTimestamp created;
@property (nonatomic, getter=updated, setter=setUpdated:) EDAMTimestamp updated;
@property (nonatomic, getter=deleted, setter=setDeleted:) EDAMTimestamp deleted;
@property (nonatomic, getter=active, setter=setActive:) BOOL active;
@property (nonatomic, retain, getter=shardId, setter=setShardId:) NSString * shardId;
@property (nonatomic, retain, getter=attributes, setter=setAttributes:) EDAMUserAttributes * attributes;
@property (nonatomic, retain, getter=accounting, setter=setAccounting:) EDAMAccounting * accounting;
#endif

- (id) initWithId: (EDAMUserID) id username: (NSString *) username email: (NSString *) email name: (NSString *) name timezone: (NSString *) timezone privilege: (int) privilege created: (EDAMTimestamp) created updated: (EDAMTimestamp) updated deleted: (EDAMTimestamp) deleted active: (BOOL) active shardId: (NSString *) shardId attributes: (EDAMUserAttributes *) attributes accounting: (EDAMAccounting *) accounting;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMUserID) id;
- (void) setId: (EDAMUserID) id;
- (BOOL) idIsSet;

- (NSString *) username;
- (void) setUsername: (NSString *) username;
- (BOOL) usernameIsSet;

- (NSString *) email;
- (void) setEmail: (NSString *) email;
- (BOOL) emailIsSet;

- (NSString *) name;
- (void) setName: (NSString *) name;
- (BOOL) nameIsSet;

- (NSString *) timezone;
- (void) setTimezone: (NSString *) timezone;
- (BOOL) timezoneIsSet;

- (int) privilege;
- (void) setPrivilege: (int) privilege;
- (BOOL) privilegeIsSet;

- (EDAMTimestamp) created;
- (void) setCreated: (EDAMTimestamp) created;
- (BOOL) createdIsSet;

- (EDAMTimestamp) updated;
- (void) setUpdated: (EDAMTimestamp) updated;
- (BOOL) updatedIsSet;

- (EDAMTimestamp) deleted;
- (void) setDeleted: (EDAMTimestamp) deleted;
- (BOOL) deletedIsSet;

- (BOOL) active;
- (void) setActive: (BOOL) active;
- (BOOL) activeIsSet;

- (NSString *) shardId;
- (void) setShardId: (NSString *) shardId;
- (BOOL) shardIdIsSet;

- (EDAMUserAttributes *) attributes;
- (void) setAttributes: (EDAMUserAttributes *) attributes;
- (BOOL) attributesIsSet;

- (EDAMAccounting *) accounting;
- (void) setAccounting: (EDAMAccounting *) accounting;
- (BOOL) accountingIsSet;

@end

@interface EDAMTag : NSObject <NSCoding> {
  EDAMGuid __guid;
  NSString * __name;
  EDAMGuid __parentGuid;
  int32_t __updateSequenceNum;

  BOOL __guid_isset;
  BOOL __name_isset;
  BOOL __parentGuid_isset;
  BOOL __updateSequenceNum_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=guid, setter=setGuid:) EDAMGuid guid;
@property (nonatomic, retain, getter=name, setter=setName:) NSString * name;
@property (nonatomic, retain, getter=parentGuid, setter=setParentGuid:) EDAMGuid parentGuid;
@property (nonatomic, getter=updateSequenceNum, setter=setUpdateSequenceNum:) int32_t updateSequenceNum;
#endif

- (id) initWithGuid: (EDAMGuid) guid name: (NSString *) name parentGuid: (EDAMGuid) parentGuid updateSequenceNum: (int32_t) updateSequenceNum;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMGuid) guid;
- (void) setGuid: (EDAMGuid) guid;
- (BOOL) guidIsSet;

- (NSString *) name;
- (void) setName: (NSString *) name;
- (BOOL) nameIsSet;

- (EDAMGuid) parentGuid;
- (void) setParentGuid: (EDAMGuid) parentGuid;
- (BOOL) parentGuidIsSet;

- (int32_t) updateSequenceNum;
- (void) setUpdateSequenceNum: (int32_t) updateSequenceNum;
- (BOOL) updateSequenceNumIsSet;

@end

@interface EDAMResourceAttributes : NSObject <NSCoding> {
  NSString * __sourceURL;
  EDAMTimestamp __timestamp;
  double __latitude;
  double __longitude;
  double __altitude;
  NSString * __cameraMake;
  NSString * __cameraModel;
  BOOL __clientWillIndex;
  NSString * __recoType;
  NSString * __fileName;
  BOOL __attachment;

  BOOL __sourceURL_isset;
  BOOL __timestamp_isset;
  BOOL __latitude_isset;
  BOOL __longitude_isset;
  BOOL __altitude_isset;
  BOOL __cameraMake_isset;
  BOOL __cameraModel_isset;
  BOOL __clientWillIndex_isset;
  BOOL __recoType_isset;
  BOOL __fileName_isset;
  BOOL __attachment_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=sourceURL, setter=setSourceURL:) NSString * sourceURL;
@property (nonatomic, getter=timestamp, setter=setTimestamp:) EDAMTimestamp timestamp;
@property (nonatomic, getter=latitude, setter=setLatitude:) double latitude;
@property (nonatomic, getter=longitude, setter=setLongitude:) double longitude;
@property (nonatomic, getter=altitude, setter=setAltitude:) double altitude;
@property (nonatomic, retain, getter=cameraMake, setter=setCameraMake:) NSString * cameraMake;
@property (nonatomic, retain, getter=cameraModel, setter=setCameraModel:) NSString * cameraModel;
@property (nonatomic, getter=clientWillIndex, setter=setClientWillIndex:) BOOL clientWillIndex;
@property (nonatomic, retain, getter=recoType, setter=setRecoType:) NSString * recoType;
@property (nonatomic, retain, getter=fileName, setter=setFileName:) NSString * fileName;
@property (nonatomic, getter=attachment, setter=setAttachment:) BOOL attachment;
#endif

- (id) initWithSourceURL: (NSString *) sourceURL timestamp: (EDAMTimestamp) timestamp latitude: (double) latitude longitude: (double) longitude altitude: (double) altitude cameraMake: (NSString *) cameraMake cameraModel: (NSString *) cameraModel clientWillIndex: (BOOL) clientWillIndex recoType: (NSString *) recoType fileName: (NSString *) fileName attachment: (BOOL) attachment;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (NSString *) sourceURL;
- (void) setSourceURL: (NSString *) sourceURL;
- (BOOL) sourceURLIsSet;

- (EDAMTimestamp) timestamp;
- (void) setTimestamp: (EDAMTimestamp) timestamp;
- (BOOL) timestampIsSet;

- (double) latitude;
- (void) setLatitude: (double) latitude;
- (BOOL) latitudeIsSet;

- (double) longitude;
- (void) setLongitude: (double) longitude;
- (BOOL) longitudeIsSet;

- (double) altitude;
- (void) setAltitude: (double) altitude;
- (BOOL) altitudeIsSet;

- (NSString *) cameraMake;
- (void) setCameraMake: (NSString *) cameraMake;
- (BOOL) cameraMakeIsSet;

- (NSString *) cameraModel;
- (void) setCameraModel: (NSString *) cameraModel;
- (BOOL) cameraModelIsSet;

- (BOOL) clientWillIndex;
- (void) setClientWillIndex: (BOOL) clientWillIndex;
- (BOOL) clientWillIndexIsSet;

- (NSString *) recoType;
- (void) setRecoType: (NSString *) recoType;
- (BOOL) recoTypeIsSet;

- (NSString *) fileName;
- (void) setFileName: (NSString *) fileName;
- (BOOL) fileNameIsSet;

- (BOOL) attachment;
- (void) setAttachment: (BOOL) attachment;
- (BOOL) attachmentIsSet;

@end

@interface EDAMResource : NSObject <NSCoding> {
  EDAMGuid __guid;
  EDAMGuid __noteGuid;
  EDAMData * __data;
  NSString * __mime;
  int16_t __width;
  int16_t __height;
  int16_t __duration;
  BOOL __active;
  EDAMData * __recognition;
  EDAMResourceAttributes * __attributes;
  int32_t __updateSequenceNum;
  EDAMData * __alternateData;

  BOOL __guid_isset;
  BOOL __noteGuid_isset;
  BOOL __data_isset;
  BOOL __mime_isset;
  BOOL __width_isset;
  BOOL __height_isset;
  BOOL __duration_isset;
  BOOL __active_isset;
  BOOL __recognition_isset;
  BOOL __attributes_isset;
  BOOL __updateSequenceNum_isset;
  BOOL __alternateData_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=guid, setter=setGuid:) EDAMGuid guid;
@property (nonatomic, retain, getter=noteGuid, setter=setNoteGuid:) EDAMGuid noteGuid;
@property (nonatomic, retain, getter=data, setter=setData:) EDAMData * data;
@property (nonatomic, retain, getter=mime, setter=setMime:) NSString * mime;
@property (nonatomic, getter=width, setter=setWidth:) int16_t width;
@property (nonatomic, getter=height, setter=setHeight:) int16_t height;
@property (nonatomic, getter=duration, setter=setDuration:) int16_t duration;
@property (nonatomic, getter=active, setter=setActive:) BOOL active;
@property (nonatomic, retain, getter=recognition, setter=setRecognition:) EDAMData * recognition;
@property (nonatomic, retain, getter=attributes, setter=setAttributes:) EDAMResourceAttributes * attributes;
@property (nonatomic, getter=updateSequenceNum, setter=setUpdateSequenceNum:) int32_t updateSequenceNum;
@property (nonatomic, retain, getter=alternateData, setter=setAlternateData:) EDAMData * alternateData;
#endif

- (id) initWithGuid: (EDAMGuid) guid noteGuid: (EDAMGuid) noteGuid data: (EDAMData *) data mime: (NSString *) mime width: (int16_t) width height: (int16_t) height duration: (int16_t) duration active: (BOOL) active recognition: (EDAMData *) recognition attributes: (EDAMResourceAttributes *) attributes updateSequenceNum: (int32_t) updateSequenceNum alternateData: (EDAMData *) alternateData;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMGuid) guid;
- (void) setGuid: (EDAMGuid) guid;
- (BOOL) guidIsSet;

- (EDAMGuid) noteGuid;
- (void) setNoteGuid: (EDAMGuid) noteGuid;
- (BOOL) noteGuidIsSet;

- (EDAMData *) data;
- (void) setData: (EDAMData *) data;
- (BOOL) dataIsSet;

- (NSString *) mime;
- (void) setMime: (NSString *) mime;
- (BOOL) mimeIsSet;

- (int16_t) width;
- (void) setWidth: (int16_t) width;
- (BOOL) widthIsSet;

- (int16_t) height;
- (void) setHeight: (int16_t) height;
- (BOOL) heightIsSet;

- (int16_t) duration;
- (void) setDuration: (int16_t) duration;
- (BOOL) durationIsSet;

- (BOOL) active;
- (void) setActive: (BOOL) active;
- (BOOL) activeIsSet;

- (EDAMData *) recognition;
- (void) setRecognition: (EDAMData *) recognition;
- (BOOL) recognitionIsSet;

- (EDAMResourceAttributes *) attributes;
- (void) setAttributes: (EDAMResourceAttributes *) attributes;
- (BOOL) attributesIsSet;

- (int32_t) updateSequenceNum;
- (void) setUpdateSequenceNum: (int32_t) updateSequenceNum;
- (BOOL) updateSequenceNumIsSet;

- (EDAMData *) alternateData;
- (void) setAlternateData: (EDAMData *) alternateData;
- (BOOL) alternateDataIsSet;

@end

@interface EDAMNoteAttributes : NSObject <NSCoding> {
  EDAMTimestamp __subjectDate;
  double __latitude;
  double __longitude;
  double __altitude;
  NSString * __author;
  NSString * __source;
  NSString * __sourceURL;
  NSString * __sourceApplication;

  BOOL __subjectDate_isset;
  BOOL __latitude_isset;
  BOOL __longitude_isset;
  BOOL __altitude_isset;
  BOOL __author_isset;
  BOOL __source_isset;
  BOOL __sourceURL_isset;
  BOOL __sourceApplication_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=subjectDate, setter=setSubjectDate:) EDAMTimestamp subjectDate;
@property (nonatomic, getter=latitude, setter=setLatitude:) double latitude;
@property (nonatomic, getter=longitude, setter=setLongitude:) double longitude;
@property (nonatomic, getter=altitude, setter=setAltitude:) double altitude;
@property (nonatomic, retain, getter=author, setter=setAuthor:) NSString * author;
@property (nonatomic, retain, getter=source, setter=setSource:) NSString * source;
@property (nonatomic, retain, getter=sourceURL, setter=setSourceURL:) NSString * sourceURL;
@property (nonatomic, retain, getter=sourceApplication, setter=setSourceApplication:) NSString * sourceApplication;
#endif

- (id) initWithSubjectDate: (EDAMTimestamp) subjectDate latitude: (double) latitude longitude: (double) longitude altitude: (double) altitude author: (NSString *) author source: (NSString *) source sourceURL: (NSString *) sourceURL sourceApplication: (NSString *) sourceApplication;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMTimestamp) subjectDate;
- (void) setSubjectDate: (EDAMTimestamp) subjectDate;
- (BOOL) subjectDateIsSet;

- (double) latitude;
- (void) setLatitude: (double) latitude;
- (BOOL) latitudeIsSet;

- (double) longitude;
- (void) setLongitude: (double) longitude;
- (BOOL) longitudeIsSet;

- (double) altitude;
- (void) setAltitude: (double) altitude;
- (BOOL) altitudeIsSet;

- (NSString *) author;
- (void) setAuthor: (NSString *) author;
- (BOOL) authorIsSet;

- (NSString *) source;
- (void) setSource: (NSString *) source;
- (BOOL) sourceIsSet;

- (NSString *) sourceURL;
- (void) setSourceURL: (NSString *) sourceURL;
- (BOOL) sourceURLIsSet;

- (NSString *) sourceApplication;
- (void) setSourceApplication: (NSString *) sourceApplication;
- (BOOL) sourceApplicationIsSet;

@end

@interface EDAMNote : NSObject <NSCoding> {
  EDAMGuid __guid;
  NSString * __title;
  NSString * __content;
  NSData * __contentHash;
  int32_t __contentLength;
  EDAMTimestamp __created;
  EDAMTimestamp __updated;
  EDAMTimestamp __deleted;
  BOOL __active;
  int32_t __updateSequenceNum;
  NSString * __notebookGuid;
  NSArray * __tagGuids;
  NSArray * __resources;
  EDAMNoteAttributes * __attributes;
  NSArray * __tagNames;

  BOOL __guid_isset;
  BOOL __title_isset;
  BOOL __content_isset;
  BOOL __contentHash_isset;
  BOOL __contentLength_isset;
  BOOL __created_isset;
  BOOL __updated_isset;
  BOOL __deleted_isset;
  BOOL __active_isset;
  BOOL __updateSequenceNum_isset;
  BOOL __notebookGuid_isset;
  BOOL __tagGuids_isset;
  BOOL __resources_isset;
  BOOL __attributes_isset;
  BOOL __tagNames_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=guid, setter=setGuid:) EDAMGuid guid;
@property (nonatomic, retain, getter=title, setter=setTitle:) NSString * title;
@property (nonatomic, retain, getter=content, setter=setContent:) NSString * content;
@property (nonatomic, retain, getter=contentHash, setter=setContentHash:) NSData * contentHash;
@property (nonatomic, getter=contentLength, setter=setContentLength:) int32_t contentLength;
@property (nonatomic, getter=created, setter=setCreated:) EDAMTimestamp created;
@property (nonatomic, getter=updated, setter=setUpdated:) EDAMTimestamp updated;
@property (nonatomic, getter=deleted, setter=setDeleted:) EDAMTimestamp deleted;
@property (nonatomic, getter=active, setter=setActive:) BOOL active;
@property (nonatomic, getter=updateSequenceNum, setter=setUpdateSequenceNum:) int32_t updateSequenceNum;
@property (nonatomic, retain, getter=notebookGuid, setter=setNotebookGuid:) NSString * notebookGuid;
@property (nonatomic, retain, getter=tagGuids, setter=setTagGuids:) NSArray * tagGuids;
@property (nonatomic, retain, getter=resources, setter=setResources:) NSArray * resources;
@property (nonatomic, retain, getter=attributes, setter=setAttributes:) EDAMNoteAttributes * attributes;
@property (nonatomic, retain, getter=tagNames, setter=setTagNames:) NSArray * tagNames;
#endif

- (id) initWithGuid: (EDAMGuid) guid title: (NSString *) title content: (NSString *) content contentHash: (NSData *) contentHash contentLength: (int32_t) contentLength created: (EDAMTimestamp) created updated: (EDAMTimestamp) updated deleted: (EDAMTimestamp) deleted active: (BOOL) active updateSequenceNum: (int32_t) updateSequenceNum notebookGuid: (NSString *) notebookGuid tagGuids: (NSArray *) tagGuids resources: (NSArray *) resources attributes: (EDAMNoteAttributes *) attributes tagNames: (NSArray *) tagNames;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMGuid) guid;
- (void) setGuid: (EDAMGuid) guid;
- (BOOL) guidIsSet;

- (NSString *) title;
- (void) setTitle: (NSString *) title;
- (BOOL) titleIsSet;

- (NSString *) content;
- (void) setContent: (NSString *) content;
- (BOOL) contentIsSet;

- (NSData *) contentHash;
- (void) setContentHash: (NSData *) contentHash;
- (BOOL) contentHashIsSet;

- (int32_t) contentLength;
- (void) setContentLength: (int32_t) contentLength;
- (BOOL) contentLengthIsSet;

- (EDAMTimestamp) created;
- (void) setCreated: (EDAMTimestamp) created;
- (BOOL) createdIsSet;

- (EDAMTimestamp) updated;
- (void) setUpdated: (EDAMTimestamp) updated;
- (BOOL) updatedIsSet;

- (EDAMTimestamp) deleted;
- (void) setDeleted: (EDAMTimestamp) deleted;
- (BOOL) deletedIsSet;

- (BOOL) active;
- (void) setActive: (BOOL) active;
- (BOOL) activeIsSet;

- (int32_t) updateSequenceNum;
- (void) setUpdateSequenceNum: (int32_t) updateSequenceNum;
- (BOOL) updateSequenceNumIsSet;

- (NSString *) notebookGuid;
- (void) setNotebookGuid: (NSString *) notebookGuid;
- (BOOL) notebookGuidIsSet;

- (NSArray *) tagGuids;
- (void) setTagGuids: (NSArray *) tagGuids;
- (BOOL) tagGuidsIsSet;

- (NSArray *) resources;
- (void) setResources: (NSArray *) resources;
- (BOOL) resourcesIsSet;

- (EDAMNoteAttributes *) attributes;
- (void) setAttributes: (EDAMNoteAttributes *) attributes;
- (BOOL) attributesIsSet;

- (NSArray *) tagNames;
- (void) setTagNames: (NSArray *) tagNames;
- (BOOL) tagNamesIsSet;

@end

@interface EDAMPublishing : NSObject <NSCoding> {
  NSString * __uri;
  int __order;
  BOOL __ascending;
  NSString * __publicDescription;

  BOOL __uri_isset;
  BOOL __order_isset;
  BOOL __ascending_isset;
  BOOL __publicDescription_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=uri, setter=setUri:) NSString * uri;
@property (nonatomic, getter=order, setter=setOrder:) int order;
@property (nonatomic, getter=ascending, setter=setAscending:) BOOL ascending;
@property (nonatomic, retain, getter=publicDescription, setter=setPublicDescription:) NSString * publicDescription;
#endif

- (id) initWithUri: (NSString *) uri order: (int) order ascending: (BOOL) ascending publicDescription: (NSString *) publicDescription;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (NSString *) uri;
- (void) setUri: (NSString *) uri;
- (BOOL) uriIsSet;

- (int) order;
- (void) setOrder: (int) order;
- (BOOL) orderIsSet;

- (BOOL) ascending;
- (void) setAscending: (BOOL) ascending;
- (BOOL) ascendingIsSet;

- (NSString *) publicDescription;
- (void) setPublicDescription: (NSString *) publicDescription;
- (BOOL) publicDescriptionIsSet;

@end

@interface EDAMNotebook : NSObject <NSCoding> {
  EDAMGuid __guid;
  NSString * __name;
  int32_t __updateSequenceNum;
  BOOL __defaultNotebook;
  EDAMTimestamp __serviceCreated;
  EDAMTimestamp __serviceUpdated;
  EDAMPublishing * __publishing;
  BOOL __published;
  NSString * __stack;

  BOOL __guid_isset;
  BOOL __name_isset;
  BOOL __updateSequenceNum_isset;
  BOOL __defaultNotebook_isset;
  BOOL __serviceCreated_isset;
  BOOL __serviceUpdated_isset;
  BOOL __publishing_isset;
  BOOL __published_isset;
  BOOL __stack_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=guid, setter=setGuid:) EDAMGuid guid;
@property (nonatomic, retain, getter=name, setter=setName:) NSString * name;
@property (nonatomic, getter=updateSequenceNum, setter=setUpdateSequenceNum:) int32_t updateSequenceNum;
@property (nonatomic, getter=defaultNotebook, setter=setDefaultNotebook:) BOOL defaultNotebook;
@property (nonatomic, getter=serviceCreated, setter=setServiceCreated:) EDAMTimestamp serviceCreated;
@property (nonatomic, getter=serviceUpdated, setter=setServiceUpdated:) EDAMTimestamp serviceUpdated;
@property (nonatomic, retain, getter=publishing, setter=setPublishing:) EDAMPublishing * publishing;
@property (nonatomic, getter=published, setter=setPublished:) BOOL published;
@property (nonatomic, retain, getter=stack, setter=setStack:) NSString * stack;
#endif

- (id) initWithGuid: (EDAMGuid) guid name: (NSString *) name updateSequenceNum: (int32_t) updateSequenceNum defaultNotebook: (BOOL) defaultNotebook serviceCreated: (EDAMTimestamp) serviceCreated serviceUpdated: (EDAMTimestamp) serviceUpdated publishing: (EDAMPublishing *) publishing published: (BOOL) published stack: (NSString *) stack;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMGuid) guid;
- (void) setGuid: (EDAMGuid) guid;
- (BOOL) guidIsSet;

- (NSString *) name;
- (void) setName: (NSString *) name;
- (BOOL) nameIsSet;

- (int32_t) updateSequenceNum;
- (void) setUpdateSequenceNum: (int32_t) updateSequenceNum;
- (BOOL) updateSequenceNumIsSet;

- (BOOL) defaultNotebook;
- (void) setDefaultNotebook: (BOOL) defaultNotebook;
- (BOOL) defaultNotebookIsSet;

- (EDAMTimestamp) serviceCreated;
- (void) setServiceCreated: (EDAMTimestamp) serviceCreated;
- (BOOL) serviceCreatedIsSet;

- (EDAMTimestamp) serviceUpdated;
- (void) setServiceUpdated: (EDAMTimestamp) serviceUpdated;
- (BOOL) serviceUpdatedIsSet;

- (EDAMPublishing *) publishing;
- (void) setPublishing: (EDAMPublishing *) publishing;
- (BOOL) publishingIsSet;

- (BOOL) published;
- (void) setPublished: (BOOL) published;
- (BOOL) publishedIsSet;

- (NSString *) stack;
- (void) setStack: (NSString *) stack;
- (BOOL) stackIsSet;

@end

@interface EDAMSavedSearch : NSObject <NSCoding> {
  EDAMGuid __guid;
  NSString * __name;
  NSString * __query;
  int __format;
  int32_t __updateSequenceNum;

  BOOL __guid_isset;
  BOOL __name_isset;
  BOOL __query_isset;
  BOOL __format_isset;
  BOOL __updateSequenceNum_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, retain, getter=guid, setter=setGuid:) EDAMGuid guid;
@property (nonatomic, retain, getter=name, setter=setName:) NSString * name;
@property (nonatomic, retain, getter=query, setter=setQuery:) NSString * query;
@property (nonatomic, getter=format, setter=setFormat:) int format;
@property (nonatomic, getter=updateSequenceNum, setter=setUpdateSequenceNum:) int32_t updateSequenceNum;
#endif

- (id) initWithGuid: (EDAMGuid) guid name: (NSString *) name query: (NSString *) query format: (int) format updateSequenceNum: (int32_t) updateSequenceNum;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (EDAMGuid) guid;
- (void) setGuid: (EDAMGuid) guid;
- (BOOL) guidIsSet;

- (NSString *) name;
- (void) setName: (NSString *) name;
- (BOOL) nameIsSet;

- (NSString *) query;
- (void) setQuery: (NSString *) query;
- (BOOL) queryIsSet;

- (int) format;
- (void) setFormat: (int) format;
- (BOOL) formatIsSet;

- (int32_t) updateSequenceNum;
- (void) setUpdateSequenceNum: (int32_t) updateSequenceNum;
- (BOOL) updateSequenceNumIsSet;

@end

@interface EDAMAd : NSObject <NSCoding> {
  int32_t __id;
  int16_t __width;
  int16_t __height;
  NSString * __advertiserName;
  NSString * __imageUrl;
  NSString * __destinationUrl;
  int16_t __displaySeconds;
  double __score;
  NSData * __image;
  NSString * __imageMime;
  NSString * __html;
  double __displayFrequency;

  BOOL __id_isset;
  BOOL __width_isset;
  BOOL __height_isset;
  BOOL __advertiserName_isset;
  BOOL __imageUrl_isset;
  BOOL __destinationUrl_isset;
  BOOL __displaySeconds_isset;
  BOOL __score_isset;
  BOOL __image_isset;
  BOOL __imageMime_isset;
  BOOL __html_isset;
  BOOL __displayFrequency_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=id, setter=setId:) int32_t id;
@property (nonatomic, getter=width, setter=setWidth:) int16_t width;
@property (nonatomic, getter=height, setter=setHeight:) int16_t height;
@property (nonatomic, retain, getter=advertiserName, setter=setAdvertiserName:) NSString * advertiserName;
@property (nonatomic, retain, getter=imageUrl, setter=setImageUrl:) NSString * imageUrl;
@property (nonatomic, retain, getter=destinationUrl, setter=setDestinationUrl:) NSString * destinationUrl;
@property (nonatomic, getter=displaySeconds, setter=setDisplaySeconds:) int16_t displaySeconds;
@property (nonatomic, getter=score, setter=setScore:) double score;
@property (nonatomic, retain, getter=image, setter=setImage:) NSData * image;
@property (nonatomic, retain, getter=imageMime, setter=setImageMime:) NSString * imageMime;
@property (nonatomic, retain, getter=html, setter=setHtml:) NSString * html;
@property (nonatomic, getter=displayFrequency, setter=setDisplayFrequency:) double displayFrequency;
#endif

- (id) initWithId: (int32_t) id width: (int16_t) width height: (int16_t) height advertiserName: (NSString *) advertiserName imageUrl: (NSString *) imageUrl destinationUrl: (NSString *) destinationUrl displaySeconds: (int16_t) displaySeconds score: (double) score image: (NSData *) image imageMime: (NSString *) imageMime html: (NSString *) html displayFrequency: (double) displayFrequency;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (int32_t) id;
- (void) setId: (int32_t) id;
- (BOOL) idIsSet;

- (int16_t) width;
- (void) setWidth: (int16_t) width;
- (BOOL) widthIsSet;

- (int16_t) height;
- (void) setHeight: (int16_t) height;
- (BOOL) heightIsSet;

- (NSString *) advertiserName;
- (void) setAdvertiserName: (NSString *) advertiserName;
- (BOOL) advertiserNameIsSet;

- (NSString *) imageUrl;
- (void) setImageUrl: (NSString *) imageUrl;
- (BOOL) imageUrlIsSet;

- (NSString *) destinationUrl;
- (void) setDestinationUrl: (NSString *) destinationUrl;
- (BOOL) destinationUrlIsSet;

- (int16_t) displaySeconds;
- (void) setDisplaySeconds: (int16_t) displaySeconds;
- (BOOL) displaySecondsIsSet;

- (double) score;
- (void) setScore: (double) score;
- (BOOL) scoreIsSet;

- (NSData *) image;
- (void) setImage: (NSData *) image;
- (BOOL) imageIsSet;

- (NSString *) imageMime;
- (void) setImageMime: (NSString *) imageMime;
- (BOOL) imageMimeIsSet;

- (NSString *) html;
- (void) setHtml: (NSString *) html;
- (BOOL) htmlIsSet;

- (double) displayFrequency;
- (void) setDisplayFrequency: (double) displayFrequency;
- (BOOL) displayFrequencyIsSet;

@end

@interface EDAMSharedNotebook : NSObject <NSCoding> {
  int64_t __id;
  int32_t __userId;
  NSString * __notebookGuid;
  NSString * __email;
  BOOL __notebookModifiable;
  BOOL __requireLogin;
  EDAMTimestamp __serviceCreated;
  NSString * __shareKey;
  NSString * __username;

  BOOL __id_isset;
  BOOL __userId_isset;
  BOOL __notebookGuid_isset;
  BOOL __email_isset;
  BOOL __notebookModifiable_isset;
  BOOL __requireLogin_isset;
  BOOL __serviceCreated_isset;
  BOOL __shareKey_isset;
  BOOL __username_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=id, setter=setId:) int64_t id;
@property (nonatomic, getter=userId, setter=setUserId:) int32_t userId;
@property (nonatomic, retain, getter=notebookGuid, setter=setNotebookGuid:) NSString * notebookGuid;
@property (nonatomic, retain, getter=email, setter=setEmail:) NSString * email;
@property (nonatomic, getter=notebookModifiable, setter=setNotebookModifiable:) BOOL notebookModifiable;
@property (nonatomic, getter=requireLogin, setter=setRequireLogin:) BOOL requireLogin;
@property (nonatomic, getter=serviceCreated, setter=setServiceCreated:) EDAMTimestamp serviceCreated;
@property (nonatomic, retain, getter=shareKey, setter=setShareKey:) NSString * shareKey;
@property (nonatomic, retain, getter=username, setter=setUsername:) NSString * username;
#endif

- (id) initWithId: (int64_t) id userId: (int32_t) userId notebookGuid: (NSString *) notebookGuid email: (NSString *) email notebookModifiable: (BOOL) notebookModifiable requireLogin: (BOOL) requireLogin serviceCreated: (EDAMTimestamp) serviceCreated shareKey: (NSString *) shareKey username: (NSString *) username;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (int64_t) id;
- (void) setId: (int64_t) id;
- (BOOL) idIsSet;

- (int32_t) userId;
- (void) setUserId: (int32_t) userId;
- (BOOL) userIdIsSet;

- (NSString *) notebookGuid;
- (void) setNotebookGuid: (NSString *) notebookGuid;
- (BOOL) notebookGuidIsSet;

- (NSString *) email;
- (void) setEmail: (NSString *) email;
- (BOOL) emailIsSet;

- (BOOL) notebookModifiable;
- (void) setNotebookModifiable: (BOOL) notebookModifiable;
- (BOOL) notebookModifiableIsSet;

- (BOOL) requireLogin;
- (void) setRequireLogin: (BOOL) requireLogin;
- (BOOL) requireLoginIsSet;

- (EDAMTimestamp) serviceCreated;
- (void) setServiceCreated: (EDAMTimestamp) serviceCreated;
- (BOOL) serviceCreatedIsSet;

- (NSString *) shareKey;
- (void) setShareKey: (NSString *) shareKey;
- (BOOL) shareKeyIsSet;

- (NSString *) username;
- (void) setUsername: (NSString *) username;
- (BOOL) usernameIsSet;

@end

@interface EDAMLinkedNotebook : NSObject <NSCoding> {
  int64_t __id;
  NSString * __shareName;
  NSString * __username;
  NSString * __shardId;
  NSString * __shareKey;
  NSString * __uri;

  BOOL __id_isset;
  BOOL __shareName_isset;
  BOOL __username_isset;
  BOOL __shardId_isset;
  BOOL __shareKey_isset;
  BOOL __uri_isset;
}

#if TARGET_OS_IPHONE || (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5)
@property (nonatomic, getter=id, setter=setId:) int64_t id;
@property (nonatomic, retain, getter=shareName, setter=setShareName:) NSString * shareName;
@property (nonatomic, retain, getter=username, setter=setUsername:) NSString * username;
@property (nonatomic, retain, getter=shardId, setter=setShardId:) NSString * shardId;
@property (nonatomic, retain, getter=shareKey, setter=setShareKey:) NSString * shareKey;
@property (nonatomic, retain, getter=uri, setter=setUri:) NSString * uri;
#endif

- (id) initWithId: (int64_t) id shareName: (NSString *) shareName username: (NSString *) username shardId: (NSString *) shardId shareKey: (NSString *) shareKey uri: (NSString *) uri;

- (void) read: (id <TProtocol>) inProtocol;
- (void) write: (id <TProtocol>) outProtocol;

- (int64_t) id;
- (void) setId: (int64_t) id;
- (BOOL) idIsSet;

- (NSString *) shareName;
- (void) setShareName: (NSString *) shareName;
- (BOOL) shareNameIsSet;

- (NSString *) username;
- (void) setUsername: (NSString *) username;
- (BOOL) usernameIsSet;

- (NSString *) shardId;
- (void) setShardId: (NSString *) shardId;
- (BOOL) shardIdIsSet;

- (NSString *) shareKey;
- (void) setShareKey: (NSString *) shareKey;
- (BOOL) shareKeyIsSet;

- (NSString *) uri;
- (void) setUri: (NSString *) uri;
- (BOOL) uriIsSet;

@end

@interface EDAMTypesConstants : NSObject {
}
+ (NSString *) EDAM_NOTE_SOURCE_WEB_CLIP;
+ (NSString *) EDAM_NOTE_SOURCE_MAIL_CLIP;
+ (NSString *) EDAM_NOTE_SOURCE_MAIL_SMTP_GATEWAY;
@end
