//
//  ImageDetailViewController.m
//  VisIVOMobile
//
//  Created by Fabio Roberto Vitello on 30/03/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ImageDetailViewController.h"
#import "CustomCellView.h"

@implementation ImageDetailViewController

-(id) initWithImgId:(NSString *)imgId
{
    if(self = [super init])
    {
                
        dataSource = [[NSMutableDictionary alloc] init];
        
        CGRect frame= [[UIScreen mainScreen]bounds];
        myTableView = [[UITableView alloc] initWithFrame:CGRectMake(frame.origin.x, 
                                                                    frame.origin.y, 
                                                                    frame.size.width, 
                                                                    frame.size.height) style:UITableViewStyleGrouped];
        myTableView.delegate = self;
        myTableView.dataSource = self;
        
        [self setView:myTableView];
        
        [self setTitle:@"Image Detail"];
        
        
        NSLog(@"imgId=%@",imgId);

        NSString* par=[NSString stringWithFormat:@"imgId=%@&op=img_detail",imgId];

    
        //dbHelper=[[DbHelper alloc]initWithReference:@"http://visivo-server.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
                dbHelper=[[DbHelper alloc]initWithReference:@"http://visivoportal.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
        dbHelper.delegate = self;
        dbHelper.delegateMethod = @selector(parseData:);
        dbHelper.delegateErrorMethod=@selector(parseError:);
    
    
    
        [dbHelper setPostParameter:par];
    
        
    }
    return self;
}



- (void)viewDidLoad {
    
    
}


#pragma mark -
#pragma mark UITableView delegate and dataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	
    if (section == 0)
    {
        return 2;
    }
    else if(section ==1)
    {
        return 3;
    }
    else {
        return 3;
    }
}


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
           return 3;
   

}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *CellIdentifier = @"Cell";
    
    CustomCellView *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[CustomCellView alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier type:2] autorelease];
    }
    
    
    NSMutableDictionary *allRows = [dataSource objectForKey:@"results"];
        
    
    
    
    if (indexPath.section == 0)
    {
        if(indexPath.row==0)
        {
            cell.primaryLabel.text=@"Width";
            cell.secondaryLabel.text=[allRows objectForKey:@"Width"];
        }
        if(indexPath.row==1)
        {   
            cell.primaryLabel.text=@"Height";
            cell.secondaryLabel.text=[allRows objectForKey:@"Height"];
            
        }
    }
    else if (indexPath.section == 1)
    {
        if(indexPath.row==0)
        {
            cell.primaryLabel.text=@"Azimuth";
             cell.secondaryLabel.text=[allRows objectForKey:@"CamAzim"];
        }
        else if(indexPath.row==1)
        {
            cell.primaryLabel.text=@"Elevation";
            cell.secondaryLabel.text=[allRows objectForKey:@"CamElev"];

        }
        else if(indexPath.row==2)
        {
            cell.primaryLabel.text=@"Zoom";
            cell.secondaryLabel.text=[allRows objectForKey:@"CamZoom"];

        }
        
    }
    
    else if (indexPath.section == 2)
    {
        if(indexPath.row==0)
        {
            cell.primaryLabel.text=@"LUT";
            if([allRows objectForKey:@"colorTable"])
            {
                cell.secondaryLabel.text=[allRows objectForKey:@"colorTable"];
            }
        }
        else if(indexPath.row==1)
        {
            cell.primaryLabel.text=@"Color scalar";
            if(![allRows objectForKey:@"colorScalar"])
            {
                cell.secondaryLabel.text=[allRows objectForKey:@"colorScalar"];
            }
        }
        else if(indexPath.row==2)
        {
            cell.primaryLabel.text=@"Opacity";
            if(![allRows objectForKey:@"opacity"])
            {
                cell.secondaryLabel.text=[allRows objectForKey:@"opacity"];
            }
        }
        
    }
    
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
    
    
}


- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath 
{
    
    
}

- (CGFloat) tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
        return 40;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    CGSize screenSize = [[UIScreen mainScreen] bounds].size;
    
    if (section==0) 
    {
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width,40)];
        UILabel *lbl = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, screenSize.width, 40)];
        lbl.text=@"Image Size";
        lbl.backgroundColor=[UIColor clearColor];
        [customView addSubview:lbl];
        [lbl release];
        return customView;
           
    }
    
    else  if (section==1){
        
        
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width,40)];
        UILabel *lbl = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, screenSize.width, 40)];
        lbl.text=@"Camera Position";
        lbl.backgroundColor=[UIColor clearColor];
        [customView addSubview:lbl];
        [lbl release];
        return customView;
        
    }
   // else  if (section==2){
        
        
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width,40)];
        UILabel *lbl = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, screenSize.width, 40)];
        lbl.text=@"Visualization option";
        lbl.backgroundColor=[UIColor clearColor];
        [customView addSubview:lbl];
        [lbl release];
        return customView;
        
   // }
        
}


#pragma mark -

//Metodo eseguito in caso di errore durante la connessione
-(void)parseError:(id)sender
{
    
	//Avviso l'utente che c'e' stato un errore durante la connessione al server
	UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle: NSLocalizedString(@"conn_error",@"") 
															 delegate:nil 
													cancelButtonTitle:@"OK" 
											   destructiveButtonTitle:nil 
													otherButtonTitles:nil]; 
	
	
	[actionSheet showInView:[[self view] window]];
	[actionSheet release];     
	
}


//Metodo eseguito se la connessione è terminata senza errori
-(void)parseData:(id)sender {
	
    DbHelper *tmpConnection = (DbHelper *)sender;
	
    [dataSource setDictionary:tmpConnection.receivedDictionary ];
    
    [myTableView reloadData];    
}


- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end
