//
//  FileViewController.h
//  VisIVOMobile
//
//  Created by Fabio Vitello on 02/03/12.
//  Copyright 2011 nothing. All rights reserved.
//

#import "FileViewController.h"
#import "DetailFileViewController.h"
//#import "CustomCell.h"
#import "CustomCellView.h"


@implementation FileViewController

-(id) initWithTitle:(NSString *)aTitle andIcon:(NSString *)anIcon andUserId:(NSString *)user andUserName:(NSString *)name 
{
	if(self = [super init])
    {
        
        dataSource = [[NSMutableDictionary alloc] init];
        

        CGRect frame= [[UIScreen mainScreen]bounds];
        
        myTableView = [[UITableView alloc] initWithFrame:CGRectMake(frame.origin.x, 
                                                                    frame.origin.y, 
                                                                    frame.size.width, 
                                                                    frame.size.height)];
        
        myTableView.delegate = self;
        myTableView.dataSource = self;
        
		UIImage *myIcon=[UIImage imageNamed:anIcon];
		
		UITabBarItem *myItem = [[UITabBarItem alloc] initWithTitle:aTitle image:myIcon tag:0];
		
		self.tabBarItem=myItem;
		[myItem release];
        
        userId= user;
        userName=name;
        
        NSString *par=[NSString stringWithFormat:@"user_id=%@&op=cnt_type",userId];
        
        dbHelper=[[DbHelper alloc]initWithReference:@"http://visivoportal.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
        //dbHelper=[[DbHelper alloc]initWithReference:@"http://visivo-server.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
        dbHelper.delegate = self;
        dbHelper.delegateMethod = @selector(parseData:);
        dbHelper.delegateErrorMethod=@selector(parseError:);
        
        [dbHelper setPostParameter:par];
        
        [self setView:myTableView];

        self.navigationItem.title=name;
        
        //Refresh button
		UIBarButtonItem *refreshButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemRefresh target:self action:@selector(refreshList)];
		self.navigationItem.rightBarButtonItem = refreshButton;
		[refreshButton release];
	}
	return self;
}


- (void)refreshList
{
    NSString *par=[NSString stringWithFormat:@"user_id=%@&op=cnt_type",userId];
    
    dbHelper=[[DbHelper alloc]initWithReference:@"http://visivoportal.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
  //  dbHelper=[[DbHelper alloc]initWithReference:@"http://visivo-server.oact.inaf.it/VisIVOSmart/db_query.php?db=vis"];
    dbHelper.delegate = self;
    dbHelper.delegateMethod = @selector(parseData:);
    dbHelper.delegateErrorMethod=@selector(parseError:);
    
    [dbHelper setPostParameter:par];

}

#pragma mark -
#pragma mark UITableView delegate and dataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
	return 1;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
//    CustomCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    CustomCellView *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
       // cell = [[[CustomCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
        cell = [[[CustomCellView alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier type:0] autorelease];
    }
    // Set up the cell…
    switch (indexPath.row) {
        case 0:
            cell.primaryLabel.text = @"Data";
            cell.secondaryLabel.text =[NSString stringWithFormat:@"%@ item in this folder",[dataSource objectForKey:@"data"]];
            cell.myImageView.image = [UIImage imageNamed:@"folder_tar.png"];
            cell.myImageViewEnd.image = [UIImage imageNamed:@"arrow.png"];
            
            break;
        case 1:
            cell.primaryLabel.text = @"Images";
            cell.secondaryLabel.text =[NSString stringWithFormat:@"%@ item in this folder",[dataSource objectForKey:@"img"]];
            cell.myImageView.image = [UIImage imageNamed:@"folder_image.png"];
            cell.myImageViewEnd.image = [UIImage imageNamed:@"arrow.png"];

            break;
        case 2:
            cell.primaryLabel.text = @"Movies";
            cell.secondaryLabel.text =[NSString stringWithFormat:@"%@ item in this folder",[dataSource objectForKey:@"movie"]];
            cell.myImageView.image = [UIImage imageNamed:@"folder_video.png"];
            cell.myImageViewEnd.image = [UIImage imageNamed:@"arrow.png"];

            break;
        
    }
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 90;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
    
    switch (indexPath.row) {
        case 0:
            category= @"Data";
            break;
        case 1:
            category = @"Images";
            break;
        case 2:
            category = @"Movies";
            break;
    }
    
	DetailFileViewController *detailVC = [[DetailFileViewController alloc] initWithRowId:indexPath.row andUserId:userId andCat:category];
    [self.navigationController pushViewController:detailVC animated:YES];
	[detailVC release];
    
}

-(void)parseError:(id)sender
{
    
	UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle: NSLocalizedString(@"conn_error",@"") 
															 delegate:nil 
													cancelButtonTitle:@"OK" 
											   destructiveButtonTitle:nil 
													otherButtonTitles:nil]; 
	
	
	[actionSheet showInView:[[self view] window]];
	[actionSheet release];     
	
}


- (void)parseData:(id)sender
{
	
	DbHelper *tmpConnection = (DbHelper *)sender;
	
    [ dataSource setDictionary:tmpConnection.receivedDictionary ];
    [ myTableView reloadData ];
    
}


- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end
