//
//  CustomCellTextEdit.m
//  VisIVOMobile
//
//  Created by Fabio Roberto Vitello on 28/03/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "CustomCellTextEdit.h"

@implementation CustomCellTextEdit

@synthesize primaryLabel,textField;

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        // Initialization code
        primaryLabel = [[UILabel alloc]init];
        primaryLabel.textAlignment = UITextAlignmentLeft;
        primaryLabel.font = [UIFont boldSystemFontOfSize:16];
        
        primaryLabel.backgroundColor=[UIColor clearColor];
        

        textField =[[UITextField alloc]init];
        textField.textAlignment=UITextAlignmentLeft;
        textField.clearButtonMode = UITextFieldViewModeWhileEditing;
        textField.returnKeyType=UIReturnKeyDone;
        textField.adjustsFontSizeToFitWidth=YES;
        textField.autocorrectionType=UITextAutocorrectionTypeNo;
        textField.autocapitalizationType= UITextAutocapitalizationTypeNone;
       

        textField.delegate=self;
        
        [self.contentView addSubview:primaryLabel];
        [self.contentView addSubview:textField];

             
    }
    return self;
}


-(BOOL)textFieldShouldReturn:(UITextField *)textField {
  
    [textField resignFirstResponder];
  return YES;
}


- (void)layoutSubviews {
    [super layoutSubviews];
    CGRect contentRect = self.contentView.bounds;
    CGFloat boundsX = contentRect.origin.x;
    CGRect frame;
    
    frame= CGRectMake(boundsX+5 ,0, 150, 45);
    primaryLabel.frame = frame;
    
    frame= CGRectMake(boundsX+100 ,10, 200, 35);
    textField.frame = frame;
    
   
    
   }

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    // Configure the view for the selected state
}




@end
