//
//  AsciiViewController.m
//  VisIVOMobile
//
//  Created by Fabio Roberto Vitello on 27/03/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "AsciiViewController.h"
#import "CustomCellView.h"
#import "CustomCellTextEdit.h"
@implementation AsciiViewController

- (id)init
{
    if(self = [super init])
    {
        
        CGSize screenSize = [[UIScreen mainScreen] bounds].size;


        dataSource = [[NSMutableDictionary alloc] init];
    
        CGRect frame= [[UIScreen mainScreen]bounds];
        myTableView = [[UITableView alloc] initWithFrame:CGRectMake(frame.origin.x, 
                                                                frame.origin.y, 
                                                                frame.size.width, 
                                                                frame.size.height) style:UITableViewStyleGrouped];
        myTableView.delegate = self;
        myTableView.dataSource = self;
        
    
        [self setView:myTableView];
    
        [self setTitle:@"Ascii Importer"];
        
        
        UIBarButtonItem *submitButton;
        submitButton = [[UIBarButtonItem alloc] initWithTitle:@"Submit" style:UIBarButtonItemStyleBordered target:self action:@selector(vostroMetodo)] ;
        
        self.navigationItem.rightBarButtonItem = submitButton;
		[submitButton release];

        index=0;
               

    
    }
    return self;
}


#pragma mark -
#pragma mark UITableView delegate and dataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	
    if (section == 0)
    {
        return 1;
    }
    else if(section ==1)
    {
        return 3;
    }
    else
    {
        return 3;
    }
}


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    if (segmentedControl.selectedSegmentIndex==0)
    {
        return 2;
    }
    else 
    {
        return 4;
    }
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *CellIdentifier = @"Cell";
    
  //  CustomCellView *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    CustomCellTextEdit *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
    //    cell = [[[CustomCellView alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier type:3] autorelease];
        cell = [[[CustomCellTextEdit alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];

    }
    
    if (indexPath.section == 0)
    {
        cell.primaryLabel.text=@"Description";
        cell.textField.placeholder=@"Enter URL of your data";

    }
    else if (indexPath.section == 1)
    {
        if(indexPath.row==0)
        {
            cell.primaryLabel.text=@"Url";
            cell.textField.placeholder=@"Enter URL of your data";
        }
        else if(indexPath.row==1)
        {
            cell.primaryLabel.text=@"Username";
            cell.textField.placeholder=@"Leave blank if no authentication is required ";
        }
        else if(indexPath.row==2)
        {
            cell.primaryLabel.text=@"Password";
            cell.textField.placeholder=@"Leave blank if no authentication is required ";
        }
        
    }

    else if (indexPath.section == 2)
    {
        if(indexPath.row==0)
        {
            cell.primaryLabel.text=@"X";
            cell.textField.placeholder=@"";

        }
        else if(indexPath.row==1)
        {
            cell.primaryLabel.text=@"Y";
            cell.textField.placeholder=@"";

        }
        else if(indexPath.row==2)
        {
            cell.primaryLabel.text=@"Z";
            cell.textField.placeholder=@"";

        }
        
    }

    else if (indexPath.section == 3)
    {
        if(indexPath.row==0)
        {
            cell.primaryLabel.text=@"X";
            cell.textField.placeholder=@"";

        }
        else if(indexPath.row==1)
        {
            cell.primaryLabel.text=@"Y";
            cell.textField.placeholder=@"";

        }
        else if(indexPath.row==2)
        {
            cell.primaryLabel.text=@"Z";
            cell.textField.placeholder=@"";

        }
        
    }

      
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}


//Metodo eseguito quando l'utente clicca su un elemento della tabella
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
    
    
    
}


//Metodo per la modifica della tabella, nel nostro caso l'unica opzione possibile è quella di eliminare un sms inviato
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath 
{
    
   
}

- (CGFloat) tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if (section == 0)
        return 50;
    else 
        return 40;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    CGSize screenSize = [[UIScreen mainScreen] bounds].size;

    if (section==0) {
        
    
        // create the parent view that will hold header Label
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width, 50)];
        
        NSArray *itemArray = [NSArray arrayWithObjects: @"Table", @"Volume", nil];
        segmentedControl = [[UISegmentedControl alloc] initWithItems:itemArray ];
        segmentedControl.frame = CGRectMake((screenSize.width-250)/2, 5, 250, 40);
        segmentedControl.segmentedControlStyle = UISegmentedControlStylePlain;
        segmentedControl.selectedSegmentIndex = index;
        
        [segmentedControl addTarget:self
                             action:@selector(changeSelect)
                   forControlEvents:UIControlEventValueChanged];

    
    [customView addSubview:segmentedControl];
    [segmentedControl release];
        
        return customView;

    }
        
    else  if (section==1){

             
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width,40)];
        UILabel *lbl = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, screenSize.width, 40)];
        lbl.text=@"Remote File";
        lbl.backgroundColor=[UIColor clearColor];
        [customView addSubview:lbl];
        [lbl release];
            return customView;

        }
    else  if (section==2){
        
        
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width,40)];
        UILabel *lbl = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, screenSize.width, 40)];
        lbl.text=@"Number of computational cell";
        lbl.backgroundColor=[UIColor clearColor];
        [customView addSubview:lbl];
        [lbl release];
        return customView;
        
    }
    else  if (section==3){
        
        
        UIView* customView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, screenSize.width,40)];
        UILabel *lbl = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, screenSize.width, 40)];
        lbl.text=@"Cell size";
        lbl.backgroundColor=[UIColor clearColor];
        [customView addSubview:lbl];
        [lbl release];
        return customView;
        
    }

}

-(void) changeSelect
{
    if ( segmentedControl.selectedSegmentIndex == 0) {
        NSLog(@"Table");
        index=0;
        [myTableView reloadData];

    }
    else {
        NSLog(@"Volume");
        index=1;
        [myTableView reloadData];

    }
}






- (void)viewWillAppear:(BOOL)animated
{	
    [[NSNotificationCenter defaultCenter]	
     addObserver: self
     selector: @selector(shiftViewUpForKeyboard:)
     name: UIKeyboardWillShowNotification
     object: nil];
    [[NSNotificationCenter defaultCenter]	
     addObserver: self
     selector: @selector(shiftViewDownAfterKeyboard)
     name: UIKeyboardWillHideNotification
     object: nil];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [[NSNotificationCenter defaultCenter]	removeObserver: self
                                                    name: UIKeyboardWillShowNotification
                                                  object: nil];
    [[NSNotificationCenter defaultCenter]	
     removeObserver: self
     name: UIKeyboardWillHideNotification
     object: nil];
}


- (void) shiftViewUpForKeyboard: (NSNotification*) theNotification;
{
    CGRect viewFrame;
    CGRect keyboadBounds;
    CGRect windowBounds = self.view.bounds;
    NSDictionary* userInfo = theNotification.userInfo;
    keyboardSlideDuration = [[userInfo objectForKey: UIKeyboardAnimationDurationUserInfoKey] floatValue];
    keyboadBounds = [[userInfo objectForKey: UIKeyboardBoundsUserInfoKey] CGRectValue];
    viewFrame = [self.view convertRect: self.view.frame toView: nil];

    viewShiftAmount = keyboadBounds.size.height-5-self.navigationController.navigationBar.frame.size.height;//viewFrame.origin.y+ viewFrame.size.height-  (windowBounds.size.height - keyboadBounds.size.height) + 5;
    if (viewShiftAmount < 0)
    {
        viewShiftAmount = 0;
        return;
    }
    else 
    {
        [UIView beginAnimations: @"ShiftUp" context: nil];
        [UIView setAnimationDuration: keyboardSlideDuration];
        self.view.center = CGPointMake(self.view.center.x, self.view.center.y - viewShiftAmount);
        [UIView commitAnimations];
        viewShiftedForKeyboard = TRUE;
        
    }
}

- (void) shiftViewDownAfterKeyboard;
{
        
    if (viewShiftedForKeyboard)
    {
        [UIView beginAnimations: @"ShiftUp" context: nil];
        [UIView setAnimationDuration: keyboardSlideDuration];
        self.view.center = CGPointMake( self.view.center.x, self.view.center.y + viewShiftAmount);
        [UIView commitAnimations];
        viewShiftedForKeyboard = FALSE;
    }
}



- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end
