# Generated by Django 2.2.1 on 2021-11-08 16:39

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

# Load database-dependent JSON field
if 'sqlite' in settings.DATABASES['default']['ENGINE']:
    from rosetta.core_app.fields import JSONField
else:
    from django.contrib.postgres.fields import JSONField

class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
        ('core_app', '0014_auto_20211108_1548'),
    ]

    operations = [
        migrations.RenameField(
            model_name='storage',
            old_name='config',
            new_name='conf',
        ),
        migrations.RemoveField(
            model_name='computing',
            name='user',
        ),
        migrations.RemoveField(
            model_name='storage',
            name='user',
        ),
        migrations.AddField(
            model_name='computing',
            name='conf',
            field=JSONField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='computing',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='computings', to='auth.Group'),
        ),
        migrations.AddField(
            model_name='container',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='containers', to='auth.Group'),
        ),
        migrations.AddField(
            model_name='storage',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storages', to='auth.Group'),
        ),
        migrations.AlterField(
            model_name='computinguserconf',
            name='computing',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_confs', to='core_app.Computing'),
        ),
        migrations.AlterField(
            model_name='computinguserconf',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='computing_confs', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='container',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='containers', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='keypair',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='key_pairs', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='task',
            name='computing',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasks', to='core_app.Computing'),
        ),
        migrations.AlterField(
            model_name='task',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasks', to=settings.AUTH_USER_MODEL),
        ),
        migrations.DeleteModel(
            name='ComputingConf',
        ),
    ]
