# Generated by Django 2.2.1 on 2021-11-03 22:56

from django.conf import settings
from django.db import migrations, models

# Load database-dependent JSON field
if 'sqlite' in settings.DATABASES['default']['ENGINE']:
    from rosetta.core_app.fields import JSONField
else:
    from django.contrib.postgres.fields import JSONField

class Migration(migrations.Migration):

    dependencies = [
        ('core_app', '0008_auto_20211103_1232'),
    ]

    operations = [
        migrations.AlterField(
            model_name='computing',
            name='access_mode',
            field=models.CharField(max_length=36, verbose_name='Access (control) mode'),
        ),
        migrations.AlterField(
            model_name='computing',
            name='auth_mode',
            field=models.CharField(max_length=36, verbose_name='Auth mode'),
        ),
        migrations.AlterField(
            model_name='computing',
            name='container_runtimes',
            field=models.CharField(max_length=256, verbose_name='Container runtimes'),
        ),
        migrations.AlterField(
            model_name='computing',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='computing',
            name='name',
            field=models.CharField(max_length=255, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='computing',
            name='type',
            field=models.CharField(max_length=255, verbose_name='Type'),
        ),
        migrations.AlterField(
            model_name='computing',
            name='wms',
            field=models.CharField(blank=True, max_length=36, null=True, verbose_name='Workload management system'),
        ),
        migrations.AlterField(
            model_name='container',
            name='arch',
            field=models.CharField(default='x86_64', max_length=36, verbose_name='Architecture'),
        ),
        migrations.AlterField(
            model_name='container',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='container',
            name='image',
            field=models.CharField(max_length=255, verbose_name='Image'),
        ),
        migrations.AlterField(
            model_name='container',
            name='interface_port',
            field=models.IntegerField(blank=True, null=True, verbose_name='Interface port'),
        ),
        migrations.AlterField(
            model_name='container',
            name='interface_protocol',
            field=models.CharField(blank=True, max_length=36, null=True, verbose_name='Interface protocol'),
        ),
        migrations.AlterField(
            model_name='container',
            name='interface_transport',
            field=models.CharField(blank=True, max_length=36, null=True, verbose_name='Interface transport'),
        ),
        migrations.AlterField(
            model_name='container',
            name='name',
            field=models.CharField(max_length=255, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='container',
            name='os',
            field=models.CharField(default='linux', max_length=36, verbose_name='Operating system'),
        ),
        migrations.AlterField(
            model_name='container',
            name='registry',
            field=models.CharField(max_length=255, verbose_name='Registry'),
        ),
        migrations.AlterField(
            model_name='container',
            name='supports_custom_interface_port',
            field=models.BooleanField(default=False, verbose_name='Supports custom interface port'),
        ),
        migrations.AlterField(
            model_name='container',
            name='supports_interface_auth',
            field=models.BooleanField(default=False, verbose_name='Supports interface auth'),
        ),
        migrations.AlterField(
            model_name='container',
            name='tag',
            field=models.CharField(default='latest', max_length=255, verbose_name='Tag'),
        ),
        migrations.AlterField(
            model_name='task',
            name='auth_token',
            field=models.CharField(blank=True, max_length=36, null=True, verbose_name='Auth token'),
        ),
        migrations.AlterField(
            model_name='task',
            name='computing_options',
            field=JSONField(blank=True, null=True, verbose_name='Computing options'),
        ),
        migrations.AlterField(
            model_name='task',
            name='extra_binds',
            field=models.CharField(blank=True, max_length=4096, null=True, verbose_name='Extra binds'),
        ),
        migrations.AlterField(
            model_name='task',
            name='id',
            field=models.CharField(blank=True, max_length=64, null=True, verbose_name='ID'),
        ),
        migrations.AlterField(
            model_name='task',
            name='interface_ip',
            field=models.CharField(blank=True, max_length=36, null=True, verbose_name='Interface IP address'),
        ),
        migrations.AlterField(
            model_name='task',
            name='interface_port',
            field=models.IntegerField(blank=True, null=True, verbose_name='Interface port'),
        ),
        migrations.AlterField(
            model_name='task',
            name='name',
            field=models.CharField(max_length=36, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='task',
            name='requires_proxy',
            field=models.BooleanField(verbose_name='Requires proxy'),
        ),
        migrations.AlterField(
            model_name='task',
            name='requires_proxy_auth',
            field=models.BooleanField(verbose_name='Requires proxy auth'),
        ),
        migrations.AlterField(
            model_name='task',
            name='requires_tcp_tunnel',
            field=models.BooleanField(verbose_name='Requires a TCP tunnel'),
        ),
        migrations.AlterField(
            model_name='task',
            name='status',
            field=models.CharField(blank=True, max_length=36, null=True, verbose_name='Status'),
        ),
        migrations.AlterField(
            model_name='task',
            name='tcp_tunnel_port',
            field=models.IntegerField(blank=True, null=True, verbose_name='TCP tunnel port'),
        ),
    ]
