# Generated by Django 2.2.1 on 2021-11-08 15:29

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid

# Load database-dependent JSON field
if 'sqlite' in settings.DATABASES['default']['ENGINE']:
    from rosetta.core_app.fields import JSONField
else:
    from django.contrib.postgres.fields import JSONField

class Migration(migrations.Migration):

    dependencies = [
        ('core_app', '0012_remove_task_extra_binds'),
    ]

    operations = [
        migrations.CreateModel(
            name='ComputingConf',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('data', JSONField(blank=True, null=True)),
            ],
        ),
        migrations.RemoveField(
            model_name='computing',
            name='requires_sys_conf',
        ),
        migrations.RemoveField(
            model_name='computing',
            name='requires_user_conf',
        ),
        migrations.RemoveField(
            model_name='computing',
            name='requires_user_keys',
        ),
        migrations.DeleteModel(
            name='ComputingSysConf',
        ),
        migrations.AddField(
            model_name='computingconf',
            name='computing',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='related_computing_conf', to='core_app.Computing'),
        ),
    ]
