#!/bin/bash

DATE=$(date)

echo ""
echo "==================================================="
echo "Starting API-gateway @ $DATE"
echo "==================================================="
echo ""

# Stay quiet on Python warnings
export PYTHONWARNINGS=ignore

# To Python3 unbuffered. P.s. "python3 -u" does not work..
export PYTHONUNBUFFERED=on

# To code folder
cd /opt/esap-api-gateway/esap/ &&

# Apply migrations if any
# Note: this will also indirectly wait for the DB to become up and reachable
echo "Applying migrations if any..."
python3 manage.py migrate accounts --database=accounts --settings=esap.settings.dev --no-input
python3 manage.py migrate rucio --database=rucio --settings=esap.settings.dev --no-input
python3 manage.py migrate ida --database=ida --settings=esap.settings.dev --no-input
python3 manage.py migrate --settings=esap.settings.dev --no-input

EXIT_CODE=$?
echo "Exit code: $EXIT_CODE"
if [[ "x$EXIT_CODE" != "x0" ]] ; then
    echo "This exit code is an error, sleeping 5s and exiting." 
    sleep 5
    exit $?
fi
echo ""

if [[ "x$DJANGO_DEV_SERVER" == "xTrue" ]] ; then
    
    # Run the development server
    echo "Now starting the development server"
    python3 manage.py runserver 0.0.0.0:8000  --settings=esap.settings.dev
    

else
    # Move to the code dir
    cd /opt/esap-api-gateway/esap/
    
    # Collect static
    echo "Collecting static files..."
    python3 manage.py collectstatic

    # Run uWSGI
    echo "Now starting the uWSGI server"

	uwsgi --module=esap.wsgi \
	      --env DJANGO_SETTINGS_MODULE=esap.settings.dev \
	      --master --pidfile=/tmp/project-master.pid \
	      --socket=127.0.0.1:49152 \
	      --static-map /static=/esap/static \
	      --http :8000 \
	      --disable-logging
fi



