# ESAP


This is a repository for quickly having an instance of ESAP up & running. Batteries included.


## Quickstart

Requirements:
    
    Bash and Docker.

Setup

    $ esap/setup


Build

    $ esap/build

Run

    $ esap/run
    
Popluate with demo data

    $ esap/populate

Play

    Head to https://localhost

Clean

    $ esap/clean

### Development mode

To get live code changes in the ESAP API gateway service, clone the source code repo in its folder (so that it will be located in `services/api-gateway/esap-api-gateway`), then uncomment the "volumes" section for the `api-gateway` service in the `docker-compose.yml` file and restart.

To get live code changes in the ESAP GUI service, clone the source code repo in its folder (so that it will be located in `services/gui/esap-gui`), then uncomment the "volumes" section for the `gui` service in the `docker-compose.yml` file and restart. NOTE: this procedure is still to be tested and still requires recompiling the fronted.

### Extras

List all running services

    # esap/ps

View logs

    $ esap/logs

Open a shell in a service

    # esap/shell service_name

Build a specific service

    # esap/build service_name

Run a specific service

    # esap/run service_name

View logs of a specific service

    # esap/logs service_name


### Building errors

It is common for the build process to fail with a "404 not found" error on an apt-get instrucions, as apt repositories often change their IP addresses. In such case, try:

    $ esap/build nocache


### Django Admin

Connect directly to the api-gateway service:

    http://localhost:8000/esap-api/admin/


### Django Shell

$ esap/shell api-gateway "cd /opt/esap-api-gateway/esap &&  python3 manage.py shell --settings=esap.settings.dev"


### Create Django Superuser

From the Django shell:

    >>> from django.contrib.auth.models import User
    >>> user = User.objects.create_user('admin', password='admin')
    >>> user.is_admin = True
    >>> user.is_superuser = True
    >>> user.is_staff = True
    >>> user.save()