#!/bin/bash

# Exit on any error.
set -e

echo ""
echo "[INFO] Executing entrypoint..."

#---------------------
#   Save env
#---------------------
echo "[INFO] Dumping env"

# Save env vars for later usage (e.g. docker exec)

env | \
while read env_var; do
  if [[ $env_var == HOME\=* ]]; then
      : # Skip HOME var
  elif [[ $env_var == PWD\=* ]]; then
      : # Skip PWD var
  else
      echo "export $env_var" >> /tmp/env.sh
  fi
done

#---------------------
#  Entrypoint command
#---------------------


if [[ "x$@" == "x" ]] ; then
    ENTRYPOINT_COMMAND="/run_api-gateway.sh"
else
    ENTRYPOINT_COMMAND=$@
fi

echo -n "[INFO] Executing Docker entrypoint command: "
echo $ENTRYPOINT_COMMAND
exec "$ENTRYPOINT_COMMAND"
