# DPI Library - Dynamical Plug-In for Mercury 6 (release 1.0)
## Author: Diego Turrini

DPI ([ascl:1504.012](http://ascl.net/1504.012)) is a FORTRAN77 library that supplies the symplectic mapping method for binary star systems (Chambers, Quintana, Duncan & Lissauer, 2002, AJ 123, 2884-2894) for the Mercury N-Body software package by John E. Chambers ([ascl:1201.008](https://ascl.net/1201.008)). The binary symplectic mapping is implemented as a hybrid symplectic method (Chambers, 1999, MNRAS 304, 793-799) that allows close encounters and collisions between massive bodies and is therefore suitable for planetary accretion simulations.

License: DPI is released under GPL 3 license.

Note on this release: release 1.0 supplies the symplectic mapping for S-type binary systems (also called wide binary systems in Chambers et al. 2002), where the planets orbit one of the stars and are perturbed by the stellar companion (which is the outermost body of the system).

Disclaimer: the DPI library is supplied with a modified version of Mercury 6 for the convenience of the users; however, only those files whose name begins with "dpi" are property of the author and are released under GPL 3 license.

## USING THE DPI LIBRARY WITH MERCURY 6

The use of DPI in conjunction with Mercury 6 should be straightforward for Mercury's users. Users not familiar with Mercury 6 are advised to first read Mercury's manual to get in touch with its working.

In order to use Mercury together with DPI the users need to compile together the following two files:

*  dpi1_0.for, containing the DPI library
* mercury6_2-dpi.for, containing a modified version of Mercury 6 adapted to call the subroutines provided by the DPI library

The two files can either be compiled together, e.g:

```bash
$>gfortran mercury6_2-dpi.for dpi-rc2.for -o executablename
```

or separately by using the option "-c" to create binary object files, e.g.:


```bash
$>gfortran -c mercury6_2-dpi.for
$>gfortran -c dpi1_0.for
$>gfortran mercury6_2-dpi.o dpi1_0.o -o executablename
```

Once compiled, to use the S-type symplectic mapping:

- create a file big.in with the bodies you want to integrate, taking care that the binary companion is the last body listed
- indicate "wb" (wide binary, since the binary star is the outermost body of the system) as the algorithm in the file param.in of Mercury

If the program is run using the test input files supplied with DPI, the energy error should oscillate around 1E-7 and the angular momentum error varying between 1E-13 and 1E-14 (the behaviour of the latter can vary depending on the hardware and the compiler due to the actual precision of the computations and the way rounding errors are handled).

## HOW TO CITE THE DPI LIBRARY

When using the DPI library please cite both the following references:

* Turrini, D. (2015). DPI: Symplectic mapping for binary star systems for the Mercury software package. Astrophysics Source Code Library. [ascl:1504.012](http://ascl.net/1504.012). ADS Bibcode: [2015ascl.soft04012T](https://ui.adsabs.harvard.edu/abs/2015ascl.soft04012T/abstract)
* Turrini, D., Barbieri, M., Marzari, F., Thebault, P., Tricarico, P. (2005). Planetary Formation and Orbital Stability in Binary Star Systems. Memorie della Società Astronomica Italiana Supplementi 6, 172. ADS Bibcode: [2005MSAIS...6..172T](https://ui.adsabs.harvard.edu/abs/2005MSAIS...6..172T/abstract)
