#pragma once

/* The following parameters must be set accordingly before compiling */

/************************ PARAMETERS ***********************************/
/* Data type */
typedef double MyData;

/* Number of floating-point operations                            */
/* if FLOP_ELEM == 0 then the kernel performs:                    */
/* - output[i] = input[i], for all elements using a pipeline II=1 */
/*                                                                */
/* ZedBoard: at most 88 in SP                                     */
/* Zcu102  : at most 974 in SP, and 358 in DP                     */
#define FLOP_ELEM    0

/* Threshold value for correcteness (10^-4 for SP) */
const MyData threshold = 1.0e-12;

/* Data type for output */
const char TYPE[] = "double";
/***********************************************************************/
