#pragma once

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "parameters.h"

#define TRUE  1
#define FALSE 0

#define REPEAT_KERNEL_CPU    10

#if defined(_ENERGY_)
#define REPEAT_KERNEL_FPGA 100
#else
#define REPEAT_KERNEL_FPGA REPEAT_KERNEL_CPU
#endif

#define MEMORY_ALIGNMENT 4096
#define DIM              (2*1024*1024)
#define SIZE             (DIM * sizeof(MyData))
const unsigned int BSIZE = DIM;

struct get_time
{
  double start, end;
};

struct get_time exe;

double wall_time()
{
  struct timespec ts;
  clock_gettime(CLOCK_MONOTONIC,&ts);
  const double ret = (double) (ts.tv_sec) + (double)ts.tv_nsec * 1.0e-9;
  return ret;
}

/* MACROS for Ops */
#define REP2(S)        S ;        S
#define REP4(S)   REP2(S);   REP2(S)
#define REP8(S)   REP4(S);   REP4(S)
#define REP16(S)  REP8(S);   REP8(S)
#define REP32(S)  REP16(S);  REP16(S)
#define REP64(S)  REP32(S);  REP32(S)
#define REP128(S) REP64(S);  REP64(S)
#define REP256(S) REP128(S); REP128(S)
#define REP512(S) REP256(S); REP256(S)

#define SUM(a,b,c)  ((a) = (b) + (c))
#define FMA(a,b,c)  ((a) = ((a) * (b)) + (c))
