from django.shortcuts import render

# Create your views here.
from django.utils import timezone
from datetime import date
from django.http import HttpResponse,JsonResponse,HttpResponseRedirect
from django.template import loader
#from home.form import HomeForm
from common.models import Aquisti,Articoli, Obiettivofunzione,SuddivisioneObiettivi

from django.views.generic import View,CreateView, UpdateView, DeleteView,ListView
from django.shortcuts import get_object_or_404
from django.core.mail import send_mail
from django.template.loader import render_to_string
from django.utils.html import strip_tags
# Create your views here.

class Index(CreateView):
    model = Aquisti
    #form_class = HomeForm
    template_name = 'utenti/plain.html'
    def post(self,request):
        template = loader.get_template('plain.html')
        ob_fun = Obiettivofunzione.objects.all()

        context = {'ob_fun': ob_fun,'pollo': 'pollo'}
        return HttpResponse(template.render(context,request))
    
    def get(self,request):
        template = loader.get_template('plain.html')
        
        #form = HomeForm(initial={'descrizione': 'POLLO'})
        ob_fun = Obiettivofunzione.objects.all()

        context = {'ob_fun': ob_fun,'pollo': 'pollo'}
        return HttpResponse(template.render(context,request))





class SaveRichiesta(View):
    def post(self,request):
        # Tabella Acquisti
        descrizione = request.POST.get('titolobreve')
        settore     = 0 #request.POST.get('settore')
        motivazioneuso = request.POST.get('motivazione')
        tipologia     = 0 #request.POST.get('tipoacquisto')
        convenzione     = request.POST.get('convenzione',None)
        motivazionenonconvenzione=None
        nomeconvenzione = None

        mepa = 0
        if convenzione == 'esisteconvenzioneattiva':
            convenzione = 1
            nomeconvenzione = request.POST.get('nomeconvenzione')

        if convenzione == 'nousareconvenzioneattiva':
            convenzione = 2
            motivazionenonconvenzione  = request.POST.get('motivonoconvenzione')
            mepa = 1
        if convenzione == 'nonesisteconvenzioneattiva':
            convenzione = 0
            mepa = 1
        #nomeconvenzione     = request.POST.get('nomeconvenzione')
        #motivazionenonconvenzione  = request.POST.get('motivonoconvenzione')
        #mepa = 'il contrario di convenzione'
        importototale = request.POST.get('totale')
        idrichiedente = request.user.id
        #datacreazione = date.today()
        #datainvio = 
        nuovoacquisto = Aquisti(descrizione=descrizione,
                        settore=settore,
                        motivazioneuso=motivazioneuso,
                        tipologia=tipologia,
                        convenzione=convenzione,
                        nomeconvenzione=nomeconvenzione,
                        motivazionenonconvenzione=motivazionenonconvenzione,
                        mepa = mepa,
                        importototale = importototale,
                        idrichiedente = idrichiedente
                        )
        nuovoacquisto.save()
        # Tabella Articoli
        itemarticoli = []
        quantita = request.POST.getlist('quantita')
        codiceproduttore = request.POST.getlist('codiceproduttore')
        descrizionearticolo = request.POST.getlist('descrizionearticolo')
        prezzoarticolo = request.POST.getlist('prezzoarticolo')
        i=0 
        for one in quantita:
            articolo = Articoli(quantita=one,
                    codice=codiceproduttore[i],
                    descrizione=descrizionearticolo[i],
                    prezzo = prezzoarticolo[i],
                    idacquisti=nuovoacquisto)
            articolo.save()
            #ss={'quantita': one ,'codiceproduttore':codiceproduttore[i],'descrizionearticolo':descrizionearticolo[i],'prezzoarticolo':prezzoarticolo[i]}
            #itemarticoli.append(ss)
            i+=1

        
        
        #obiettivofunzione = request.POST.getlist('obiettivofunzione')
        
        #capitolo = request.POST.getlist('capitolo')
        #responsabilefondiobfun = request.POST.getlist('responsabilefondiobfun')
        #recipients=[]

        # Tabella SuddivisioneObiettivi
        idobiettivofunzione = request.POST.getlist('idobiettivofunzione')
        prezzoobfun = request.POST.getlist('prezzoobfun')

        obfun = []
        i=0
        ar=[]
        for one in idobiettivofunzione:
            #recipients.append(responsabilefondiobfun)
            # get Obiettivo funzione info
            of = Obiettivofunzione.objects.get(pk=idobiettivofunzione[i])
            sof = SuddivisioneObiettivi(idobiettivofunzione=of,
                    idacquisto=nuovoacquisto,
                    prezzosuobiettivo=prezzoobfun[i])
            sof.save()

            #ss={'capitolo': of.obiettivofunzione, 'idobiettivofunzione':idobiettivofunzione[i],'prezzoobfun': prezzoobfun[i] }
            #obfun.append(ss)

            #ar.append(ss)
            
        #return render(request, 'subscribe/success.html', {'recepient': recepient})

            i+=1
        #for key in request.POST:
        #    #print(key)
        #    value = request.POST[key]
        #    ar.append({'key': key,'value': value})
        html_message = render_to_string('email_contabilita.html', {'obfun': obfun})
        plain_message = strip_tags(html_message)
        from_email = 'From proceduraAcquisti@inaf.it'
        to = 'ca.volpicelli@gmail.com'

        subject = 'Procedura Acquisti'
        #recepient = str(sub['Email'].value())
        send_mail(subject, plain_message, from_email, [to], html_message=html_message)

            
        return JsonResponse(ar,safe=False)

class AcquistiList(ListView):
    model = Aquisti
    #paginate_by = 100 
    template_name = 'lista.html'
    #queryset = Aquisti.objects.filter(idrichiedente=2)

    def get_queryset(self):
        #try:
        #self.acquisti = get_object_or_404(Aquisti, idrichiedente=self.kwargs['idrichiedente'])
        return Aquisti.objects.filter(idrichiedente=self.kwargs['idrichiedente']) #self.acquisti.idrichiedente)

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        context['now'] = timezone.now()
        return context