from django.shortcuts import render
from django.http import HttpResponse,JsonResponse,HttpResponseRedirect
from django.template import loader
from django.views.generic import DetailView
from django.views.generic.edit  import CreateView, UpdateView, DeleteView
from access.models import LdapUsers
from home.forms import GestoriAppForm
from django.conf import settings
from django.contrib.auth.models import User

# Create your views here.
class PrimaPagina(CreateView):
    template_name = 'home/primapagina.html'
    model = LdapUsers
    filter_form_class = GestoriAppForm 
    fields = '__all__'

    #fields = ['cognome','nome']
    #queryset = Pdor.objects.filter(generated=False)
    #paginate_by = 1

    def get_context_data(self, **kwargs):
        """Send study constants to view"""
        context = super(PrimaPagina, self).get_context_data(**kwargs)
        #context['mib_version'] = filter(None,MibVersion.objects.values_list('version',flat=True).distinct().order_by())

        email_direttore = settings.DIRETTORE
        email_resp_acqu = settings.RESPONSABILE_UFFICIO_ACQUISTI
        email_resp_cont = settings.RESPONSABILE_UFFICIO_CONTABILITA
        emails_addetti  = settings.UFFICIO_ACQUISTI

        # Direttore
        #direttore = LdapUsers.objects.get(email=email_direttore)
        #create_user(username, email=None, password=None, **extra_fields)
        #username = email_direttore.split('@')[0]
        direttore = User.objects.get(email=email_direttore)
        resp_cont = User.objects.get(email=email_resp_cont)
        resp_acqu = User.objects.get(email=email_resp_acqu)
        addetti =[]
        for email_addetto in emails_addetti:
            addetto = User.objects.get(email=email_addetto)
            addetti.append(addetto)
        
        context={'direttore': direttore,'resp_cont': resp_cont,'resp_acqu': resp_acqu,'addetti': addetti}
        return context



class HomeDetermine(CreateView):
    #model = Aquisti
    #form_class = HomeForm
    template_name = 'tmp.html'
    def post(self,request):
        template = loader.get_template('tmp1.html')
        #ob_fun = Obiettivofunzione.objects.all()

        context = {'ob_fun': 'Get arripollo','pollo': 'pollo'}
        return HttpResponse(template.render(context,request))

    def get(self,request):
        template = loader.get_template('tmp.html')

        #form = HomeForm(initial={'descrizione': 'POLLO'})
        #ob_fun = Obiettivofunzione.objects.all()
        if request.user.is_authenticated:
            
 

            context = {'ob_fun': 'arripollo','pollo': 'pollo'}
            return HttpResponse(template.render(context,request))
        else:
            return HttpResponseRedirect('/access/loginhome')
