
# Create your models here.

# This is an auto-generated Django model module.
# You'll have to do the following manually to clean this up:
#   * Rearrange models' order
#   * Make sure each model has one field with primary_key=True
#   * Make sure each ForeignKey and OneToOneField has `on_delete` set to the desired behavior
#   * Remove `managed = True` lines if you wish to allow Django to create, modify, and delete the table
# Feel free to rename the models, but don't rename db_table values or field names.
from django.db import models
#from django_fsm import FSMField, transition
from django_xworkflows import models as xwf_models

class AcquistiWorkflow(xwf_models.Workflow):
    states = (
        ('nuova', (u"Nuova")),
        ('sottomessa', (u"Sottomessa")),
        ('inviatoemailRF', (u"InviatoEmailRF")),
        ('inviatoemailRC', (u"Inviato Email RC")),
        ('approvatoRF', (u"ApprovatoRF")),
        ('approvatoRC', (u"ApprovatoRC")),
        ('nonapprovatoRF', (u"NonApprovatoRF")),
        ('nonapprovatoRC', (u"NonApprovatoRC")),
        ('emailnonapprovatoRC', (u"EmailNonApprovatoRC")),
        ('emailnonapprovatoRF', (u"EmailNonApprovatoRF")),
        ('presaincaricoUA', (u"PresaInCaricoUA")),
        ('emailpresaincaricoUA', (u"EmailPresaInCaricoUA")),
        ('emailrifiutoUA', (u"EmailRifiutoUA")),
        ('emailnonapprovatoRC', (u"new")),
        ('emailnonapprovatoRF', (u"new")),
        ('emailnonapprovatoRC', (u"Delete")),
        ('emailnonapprovatoRF', (u"Delete")),       
       
        
        
    )
        
    transitions = (
        ('sottomessa', 'nuova', 'sottomessa'),
        ('inviatoemailRF', 'sottomessa', 'inviatoemailRF'),
        ('approvatoRF', 'inviatoemailRF', 'approvatoRF'),
        ('inviatoemailRC', 'approvatoRF', 'inviatoemailRC'),
        #('get_sottomessa', 'new', 'sottomessa'),
        
        #('get_old', 'new', 'old'),
    )
    initial_state = 'nuova'

class Flusso(models.Model):
    idacquisti = models.ForeignKey('Aquisti', models.DO_NOTHING, db_column='idacquisti',blank=True, null=True)
    stato = models.IntegerField()
    idaffidamento = models.ForeignKey('Affidamento', models.DO_NOTHING, db_column='idaffidamento',blank=True, null=True)

    class Meta:
        managed = True
        db_table = 'Flusso'


class Flussolog(models.Model):
#    id = models.IntegerField(primary_key=True)
    data = models.DateTimeField()
    azione = models.CharField(max_length=1000,blank=True, null=True)
    statoprimaazione = models.IntegerField(db_column='statoPrimaAzione', blank=True, null=True)  # Field name made lowercase.
    idflusso = models.ForeignKey(Flusso, models.DO_NOTHING, db_column='idflusso',blank=True, null=True)

    class Meta:
        managed = True
        db_table = 'FlussoLog'


class Affidamento(models.Model):
#    id = models.IntegerField(primary_key=True)
    idflusso = models.IntegerField()
    stato = models.IntegerField()
    auth_r_f = models.IntegerField(db_column='auth_R_F', blank=True, null=True)  # Field name made lowercase.
    auth_r_a = models.IntegerField(db_column='auth_R_A', blank=True, null=True)  # Field name made lowercase.
    auth_direttore = models.IntegerField(db_column='auth_Direttore', blank=True, null=True)  # Field name made lowercase.

    class Meta:
        managed = True
        db_table = 'affidamento'

class Settore(models.IntegerChoices):
    ricerca_tecnologia = 0
    didattica = 1
    funzionamento =2
class Tipologia(models.IntegerChoices):
    informatici = 0
    largo_consumo = 1
    altro = 2

class Aquisti(models.Model):
    datacreazione= models.DateField(auto_now_add=True)
    datainvio= models.DateField(auto_now_add=True,blank=True, null=True)
    descrizione = models.CharField( max_length=1000,blank=True, null=True)
    motivazioneuso = models.CharField( max_length=1000,blank=True, null=True) 
    protocollo = models.CharField( max_length=1000,blank=True, null=True)
    idrichiedente = models.IntegerField(blank=True, null=True)
    idrup = models.IntegerField(blank=True, null=True)
    tipologia = models.IntegerField(choices=Tipologia.choices,default=0) 
    settore = models.IntegerField(choices=Settore.choices,default=0)
    importototale =  models.DecimalField(max_digits=10, decimal_places=2,db_column='importoTotale', blank=True, null=True) 
    convenzione = models.IntegerField(blank=True, null=True)
    nomeconvenzione = models.CharField(max_length=100, blank=True, null=True)
    motivazionenonconvenzione = models.CharField( max_length=1000,blank=True, null=True) 
    mepa = models.IntegerField(blank=True, null=True)
    """
    class StatoAcquisto(models.IntegerChoices):
         NEW = 0
         INSERITA= 1
         EMAIL_CONTABILITA = 2
         FONDI_DISPONIMBILI = 3
         FONDI_NON_DISPONIBILI = 4
         EMAIL_RESPONSABILE_FONDI = 5
         EMAIL_UTENTE_FONDI_NON_DISPONIBILE = 6
         RESPONSABILE_FONDI_APPROVA = 7
         EMAIL_UFFICIO_ACQUISTI_APPROVAZIONE = 8
         RESPONSABILE_FONDI_NON_APPROVA = 9
         EMAIL_UTENTE_CONTABILITA_NON_APPROVAZIONE = 10
         PRESA_IN_CARICO = 11
         RICHIESTA_RIFIUTATA_ACQUISTI = 12
         EMAIL_UTENTE_PRESA_IN_CARICO = 13
         EMAIL_UTENTE_MOTIVO_RIFIUTO = 14

    stato = models.IntegerField(choices=StatoAcquisto.choices,default=0)
    """

    class Meta:
        managed = True
        db_table = 'aquisti'

    @property
    def getObiettiviFunzione(self):
        suddiobfuns = SuddivisioneObiettivi.objects.filter(idacquisto=self.id)
        return obfuns

class Obiettivofunzione(models.Model):
    obiettivofunzione = models.CharField(max_length=100,blank=True, null=True)
    cup = models.CharField(max_length=100,db_column='CUP',blank=True, null=True)  # Field name made lowercase. This field type is a guess.
    descrizione = models.CharField(max_length=255,blank=True, null=True)
    scadenza = models.DateField(blank=True, null=True)
    tipologia = models.CharField(max_length=100,blank=True, null=True)
    idsede = models.ForeignKey('Sede', models.DO_NOTHING, db_column='idsede', blank=True, null=True)
    emailresponsabile = models.CharField(max_length=100,blank=True, null=True)
    nomeresponsabile = models.CharField(max_length=100,blank=True, null=True)

    class Meta:
        managed = True
        db_table = 'obiettivofunzione'


class Articoli(models.Model):
    quantita = models.IntegerField(blank=True, null=True)
    descrizione = models.CharField(max_length=1000, blank=True, null=True)
    codice = models.CharField(max_length=1000, blank=True, null=True)
    prezzo = models.DecimalField(max_digits=10, decimal_places=2, blank=True, null=True)
    idacquisti = models.ForeignKey(Aquisti, models.DO_NOTHING, db_column='idacquisti',blank=True, null=True)

    class Meta:
        managed = True
        db_table = 'articoli'

class SuddivisioneObiettivi(models.Model):
        idacquisto = models.ForeignKey(Aquisti, models.DO_NOTHING, db_column='idacquisto')
        idobiettivofunzione = models.ForeignKey(Obiettivofunzione, models.DO_NOTHING, db_column='idobiettivofunzione')
        prezzosuobiettivo = models.DecimalField(max_digits=10, decimal_places=2, blank=True, null=True)

        class Meta:
            managed = True
            db_table = 'suddivisioneobiettivi'



class Responsabilefondi(models.Model):
    email = models.CharField(max_length=1000, blank=True, null=True)
    cognome = models.CharField( max_length=1000,blank=True, null=True)
    nome = models.CharField(max_length=1000, blank=True, null=True)
    idobiettivofunzione = models.ForeignKey('Obiettivofunzione', models.DO_NOTHING, db_column='idobiettivofunzione', blank=True, null=True)

    class Meta:
        managed = True
        db_table = 'responsabilefondi'


class Sede(models.Model):
    idsede = models.IntegerField(primary_key=True)
    emaildirettore = models.TextField(db_column='emailDirettore')  # Field name made lowercase. This field type is a guess.
    emailresponsabileamministrazione = models.TextField(db_column='emailResponsabileAmministrazione')  # Field name made lowercase. This field type is a guess.
    partitaiva = models.TextField(db_column='partitaIVA', blank=True, null=True)  # Field name made lowercase. This field type is a guess.
    nome = models.CharField(max_length=1000,blank=True, null=True)

    class Meta:
        managed = True
        db_table = 'sede'

FLUSSOACQUISTO= ( 
         'NUOVA', 
         'CREATA',
         'INOLTRATA',
         'EMAIL_CONTABILITA',
         'CONTABILITA_FONDI_DISPONIMBILI',
         'CONTABILITA_FONDI_NON_DISPONIBILI',
         'EMAIL_RESPONSABILE_FONDI',
         #'CONTABILITA_EMAIL_RICHIEDENTE_FONDI_NON_DISPONIBILE',
         'CONTABILITA_REVISIONE',
         'RESPONSABILE_FONDI_APPROVA',
         'NOTIFICATO_UA',
         'RESPONSABILE_FONDI_NON_APPROVA',
         #'EMAIL_RICHIEDENTE_CONTABILITA_NON_APPROVAZIONE',
         'REVISIONE_NON_APPROVAZIONE_RESPONSABILE',
         'UA_PRESA_IN_CARICO',
         'UA_RICHIESTA_NON_CONGRUA',
         'UA_EMAIL_RICHIEDENTE_PRESA_IN_CARICO'
         )
FLUSSOACQUISTO = list(zip(FLUSSOACQUISTO, FLUSSOACQUISTO))
class Statoaquisto(xwf_models.WorkflowEnabled,models.Model):
    aquisti = models.OneToOneField(
        Aquisti,
        on_delete=models.CASCADE,
        primary_key=True,
    )
    data = models.DateTimeField(blank=True, null=True)
    #stato = FSMField(default=STATOACQUISTO[0], choices=STATOACQUISTO)
    state = xwf_models.StateField(AcquistiWorkflow)


    class Meta:
        managed = True
        db_table = 'statoaquisto'
    

