# Generated by Django 3.1.5 on 2021-01-25 13:08

from django.db import migrations, models
import django.db.models.deletion
import django_xworkflows.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Affidamento',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idflusso', models.IntegerField()),
                ('stato', models.IntegerField()),
                ('auth_r_f', models.IntegerField(blank=True, db_column='auth_R_F', null=True)),
                ('auth_r_a', models.IntegerField(blank=True, db_column='auth_R_A', null=True)),
                ('auth_direttore', models.IntegerField(blank=True, db_column='auth_Direttore', null=True)),
            ],
            options={
                'db_table': 'affidamento',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Aquisti',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('datarichiesta', models.DateField(auto_now_add=True)),
                ('descrizione', models.CharField(blank=True, max_length=1000, null=True)),
                ('motivazioneuso', models.CharField(blank=True, max_length=1000, null=True)),
                ('protocollo', models.CharField(blank=True, max_length=1000, null=True)),
                ('idrichiedente', models.IntegerField(blank=True, null=True)),
                ('idrup', models.IntegerField(blank=True, null=True)),
                ('tipologia', models.CharField(blank=True, max_length=1000, null=True)),
                ('importototale', models.DecimalField(blank=True, db_column='importoTotale', decimal_places=2, max_digits=10, null=True)),
                ('convenzione', models.IntegerField(blank=True, null=True)),
                ('nomeconvenzione', models.CharField(blank=True, max_length=100, null=True)),
                ('mepa', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'aquisti',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Flusso',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stato', models.IntegerField()),
                ('idacquisti', models.ForeignKey(blank=True, db_column='idacquisti', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.aquisti')),
                ('idaffidamento', models.ForeignKey(blank=True, db_column='idaffidamento', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.affidamento')),
            ],
            options={
                'db_table': 'Flusso',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Obiettivofunzione',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('obiettivofunzione', models.CharField(blank=True, max_length=100, null=True)),
                ('cup', models.CharField(blank=True, db_column='CUP', max_length=100, null=True)),
                ('descrizione', models.CharField(blank=True, max_length=255, null=True)),
                ('scadenza', models.DateField(blank=True, null=True)),
                ('tipologia', models.CharField(blank=True, max_length=100, null=True)),
                ('emailresponsabile', models.CharField(blank=True, max_length=100, null=True)),
                ('nomeresponsabile', models.CharField(blank=True, max_length=100, null=True)),
            ],
            options={
                'db_table': 'obiettivofunzione',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Sede',
            fields=[
                ('idsede', models.IntegerField(primary_key=True, serialize=False)),
                ('emaildirettore', models.TextField(db_column='emailDirettore')),
                ('emailresponsabileamministrazione', models.TextField(db_column='emailResponsabileAmministrazione')),
                ('partitaiva', models.TextField(blank=True, db_column='partitaIVA', null=True)),
                ('nome', models.CharField(blank=True, max_length=1000, null=True)),
            ],
            options={
                'db_table': 'sede',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Statoaquisto',
            fields=[
                ('aquisti', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='common.aquisti')),
                ('data', models.DateTimeField(blank=True, null=True)),
                ('state', django_xworkflows.models.StateField(max_length=20, workflow=django_xworkflows.models._SerializedWorkflow(initial_state='new', name='AcquistiWorkflow', states=['new', 'sottomessa', 'inviatoemailRF', 'inviatoemailRC', 'approvatoRF', 'approvatoRC', 'nonapprovatoRF', 'nonapprovatoRC', 'emailnonapprovatoRC', 'emailnonapprovatoRF', 'presaincaricoUA', 'emailpresaincaricoUA', 'emailrifiutoUA']))),
            ],
            options={
                'db_table': 'statoaquisto',
                'managed': True,
            },
            bases=(django_xworkflows.models.BaseWorkflowEnabled, models.Model),
        ),
        migrations.CreateModel(
            name='SuddivisioneObiettivi',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prezzosuobiettivo', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('idacquisto', models.ForeignKey(db_column='idacquisto', on_delete=django.db.models.deletion.DO_NOTHING, to='common.aquisti')),
                ('idobiettivofunzione', models.ForeignKey(db_column='idobiettivofunzione', on_delete=django.db.models.deletion.DO_NOTHING, to='common.obiettivofunzione')),
            ],
            options={
                'db_table': 'suddivisioneobiettivi',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Responsabilefondi',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.CharField(blank=True, max_length=1000, null=True)),
                ('cognome', models.CharField(blank=True, max_length=1000, null=True)),
                ('nome', models.CharField(blank=True, max_length=1000, null=True)),
                ('idobiettivofunzione', models.ForeignKey(blank=True, db_column='idobiettivofunzione', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.obiettivofunzione')),
            ],
            options={
                'db_table': 'responsabilefondi',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='obiettivofunzione',
            name='idsede',
            field=models.ForeignKey(blank=True, db_column='idsede', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.sede'),
        ),
        migrations.CreateModel(
            name='Flussolog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data', models.DateTimeField()),
                ('azione', models.CharField(blank=True, max_length=1000, null=True)),
                ('statoprimaazione', models.IntegerField(blank=True, db_column='statoPrimaAzione', null=True)),
                ('idflusso', models.ForeignKey(blank=True, db_column='idflusso', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.flusso')),
            ],
            options={
                'db_table': 'FlussoLog',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Articoli',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantita', models.IntegerField(blank=True, null=True)),
                ('descrizione', models.CharField(blank=True, max_length=1000, null=True)),
                ('codice', models.CharField(blank=True, max_length=1000, null=True)),
                ('prezzo', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('idacquisti', models.ForeignKey(blank=True, db_column='idacquisti', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.aquisti')),
            ],
            options={
                'db_table': 'articoli',
                'managed': True,
            },
        ),
    ]
