from datetime import timedelta

from django.conf import settings
from django.core.management.base import BaseCommand
from access.models import LdapUsers
from django.contrib.auth.models import User
from django.core.exceptions import ObjectDoesNotExist

#from openpyxl import load_workbook




class Command(BaseCommand):

    def __init__(self):
        super(Command, self).__init__()
        #self.events_sheet = None
        #self.resource_sheet = None
    

    def handle(self, *args, **options):
        """Inserisci gli utenti """
        email_direttore = settings.DIRETTORE
        email_resp_cont = settings.RESPONSABILE_UFFICIO_CONTABILITA
        email_resp_acqu = settings.RESPONSABILE_UFFICIO_ACQUISTI
        emails_adetti   = settings.UFFICIO_ACQUISTI
        # Direttore
        direttore = LdapUsers.objects.get(email=email_direttore)
        #create_user(username, email=None, password=None, **extra_fields)
        username = email_direttore.split('@')[0]
        user = User.objects.create_user(username,email=email_direttore,password="Cambiami")
        user.save()
        user.is_staff = True
        user.first_name = direttore.nome
        user.last_name = direttore.cognome
        user.save()

        # Responsabile Contabilita'
        contabilita = LdapUsers.objects.get(email=email_resp_cont)
        #create_user(username, email=None, password=None, **extra_fields)
        username = email_resp_cont.split('@')[0]
        user = User.objects.create_user(username,email=email_resp_cont,password="Cambiami")
        user.save()
        user.is_staff = True
        user.first_name = contabilita.nome
        user.last_name = contabilita.cognome
        user.save()

        # Responsabile Acquisti'
        acquisti = LdapUsers.objects.get(email=email_resp_acqu)
        #create_user(username, email=None, password=None, **extra_fields)
        username = email_resp_acqu.split('@')[0]
        user = User.objects.create_user(username,email=email_resp_acqu,password="Cambiami")
        user.save()
        user.is_staff = True
        user.first_name = acquisti.nome
        user.last_name = acquisti.cognome
        user.save()

        # Adetti agli acquisti
        
        for email_adetto in emails_adetti:
            adetto = LdapUsers.objects.get(email=email_adetto)
            #create_user(username, email=None, password=None, **extra_fields)
            username = email_adetto.split('@')[0]
            try:
                user = User.objects.get(email=email_adetto)
            except User.DoesNotExist:    
                user = User.objects.create_user(username,email=email_adetto,password="Cambiami")
                user.save()
                user.is_staff = True
                user.first_name = adetto.nome
                user.last_name = adetto.cognome
                user.save()
    
