from django.shortcuts import render
from django.http import HttpResponse,JsonResponse,HttpResponseRedirect
from django.template import loader
from django.views  import View
from django.contrib import auth
from django.contrib.auth.models import User, Group
from django.contrib.auth import authenticate,login
from django.contrib.auth import logout
from django_auth_ldap.backend import LDAPBackend
from django_auth_ldap.config import LDAPSearch
from django_auth_ldap.backend import LDAPBackend, _LDAPUser, LDAPSearch
from django.core.exceptions import ObjectDoesNotExist

#from django_auth_ldap.backend import search
import ldap3
from pprint import pprint
#from access.models import Dipendenti
from access.models import LdapUsers


# Create your views here.
class TestLdap(View):
    def get(self,request):
        server_uri = 'ldap://ldap.ced.inaf.it'
        search_base = 'ou=People,dc=inaf,dc=it'
        search_filter = '(uid=cosimo.volpicelli)' #,password=caV@290957)'
        attrs = ['*']

        # Using ldap3
        server = ldap3.Server(server_uri)
        with ldap3.Connection(server, auto_bind=True) as conn:
            conn.search(search_base, search_filter, attributes=attrs)
        oo=pprint(conn.entries)
        return JsonResponse(oo,safe=False)


class Search(View):
    def get(self,request):
        search_base = 'ou=People,dc=inaf,dc=it'
        search_filter = "(ou=O.A. Torino)"#'(ou=O.A. Torino)' #'(objectClass=inetOrgPerson)' #'(uid=cosimo.volpicelli)' #,password=caV@290957)'
        search_scope='LEVEL' #
        attrs = ['*']
        """
        user = _LDAPUser(LDAPBackend(), "any")  # just for getting root connection to LDAP
        search = LDAPSearch(
            search_base,
            search_scope,
            search_filter#,attrs  # criteria, I guess
        )
        result = search.execute(user.connection) 
# list of users is expected, or at least us
        #username = request.GET.get('username') #.upper()
        #password = request.GET.get('password')
        """
        server_uri = 'ldap://ldap.ced.inaf.it'

        server = ldap3.Server(server_uri)
        with ldap3.Connection(server, auto_bind=True) as conn:
            conn.search(search_base, search_filter,search_scope, attributes=attrs)
    #pprint(conn.entries)
        i=1
        result=[]
        for entry in conn.entries:
            if entry.employeeType != 'ASSOCIATO':
                    result.append( { 'tipo': str(entry.employeeType), 'email': str(entry.eduPersonPrincipalName),'Nome': str(entry.givenName),
                    'Cognome': str(entry.sn)})
                    try:
                        ldapuser = LdapUsers.objects.get(email=str(entry.eduPersonPrincipalName))
                        ldapuser.profilo = str(entry.employeeType)
                        ldapuser.save()
                    except ObjectDoesNotExist:

                        ldapuser = LdapUsers(nome=str(entry.givenName),
                                cognome=str(entry.sn),
                                email=str(entry.eduPersonPrincipalName),
                                profilo = str(entry.employeeType)
                        )
                        ldapuser.save()
                    #print(i,entry.employeeType,entry.schacPersonalPosition,entry.mail,entry.ou,entry.eduPersonPrincipalName,entry.eduPersonOrgUnitDN)
                    i=i+1
        return JsonResponse(result,safe=False)
        #if users is None:
        #    raise Exception("No user named cosimo")
        #return HttpResponse(users)
class Login(View):
    def get(self,request):
        template = loader.get_template('access/login.html')
        context = {'combi': 'pollo'}
        return HttpResponse(template.render(context,request))

class Logout(View):
    def get(self,request):
        logout(request)
        return HttpResponseRedirect('/access/login')
class Authenticate(View):
    def post(self,request):
        username = request.POST.get('username') #.upper()
        password = request.POST.get('password')
       

        user = authenticate(request,username=username, password=password)
        if user is not None:
            if user.is_active:
                login(request, user)
                request.session['login'] = user.username
                try:
                    utente = LdapUsers.objects.get(email=user.email) #:user.username)
                    #utente.user = user
                    #utente.save()
                except ObjectDoesNotExist:
                    return HttpResponseRedirect('/work/nonabilitatoadetermine/')
                #return JsonResponse({'user':user.username,'mail':user.email,'last': user.last_login},safe=False)
                return HttpResponseRedirect('/home/primapagina')
        else:
            return HttpResponseRedirect('/app/nessunutente')

class UtenteNonEsistente(View):
    template_name = 'access/utentenonesistente.html'
    model = LdapUsers
    #filter_form_class = GestoriAppForm 
    #fields = '__all__'

    #fields = ['cognome','nome']
    #queryset = Pdor.objects.filter(generated=False)
    #paginate_by = 1

    def get_context_data(self, **kwargs):
        """Send study constants to view"""
        context = super(UtenteNonEsistente, self).get_context_data(**kwargs)
        #context['mib_version'] = filter(None,MibVersion.objects.values_list('version',flat=True).distinct().order_by())

        
        
        context={'direttore': direttore,'resp_cont': resp_cont,'resp_acqu': resp_acqu,'addetti': addetti}
        return context
