from django.db import models

# Create your models here.
from django.contrib.auth.models import User
from django.utils.timezone import now

class LdapUsers(models.Model):
    profilo = models.CharField(max_length=30,blank=True, null=True)
    nome = models.CharField(max_length=30,blank=True, null=True)
    cognome = models.CharField(max_length=30,blank=True, null=True)
    email = models.CharField(max_length=60,blank=True, null=True)
    telufficio = models.CharField(max_length=60,blank=True, null=True)
    #statoprimaazione = models.IntegerField(db_column='statoPrimaAzione', blank=True, null=True)  # Field name made lowercase.
    class Meta:
        managed = True
        db_table = 'ldapusers'
GROUPS = {
        ('0', 'Personale'),
        ('1', 'Acquisti'),
        ('2', 'Responsabile Fondi'),
        ('3', 'Responsabile Contabilita')
    }
class Dipendenti2(models.Model):
    user = models.OneToOneField(User,on_delete=models.CASCADE,null=True)
    #id =  models.IntegerField(primary_key=True)
    email = models.CharField(max_length=48)
    #password = models.CharField(max_length=16)
    cognome = models.CharField(max_length=48)
    ufficio = models.CharField(max_length=48, blank=True, null=True)
    nome = models.CharField(max_length=48)
    data = models.DateField(default=now)
    email = models.CharField(max_length=100, blank=True, null=True)
    gruppo = models.CharField(max_length=20, help_text='The state the PDOR is currently in',
                                 choices=GROUPS, default='0')
    class Meta:
        managed = True
        db_table = 'dipendenti2'