"""
Django settings for Acquisti project.

Generated by 'django-admin startproject' using Django 3.1.5.

For more information on this file, see
https://docs.djangoproject.com/en/3.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.1/ref/settings/
"""

from pathlib import Path
import os,ldap
from django_auth_ldap.config import LDAPSearch,GroupOfNamesType

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '&-lfm3k^86%0y4qius3gdjikn8*^ieo46mi8&wl()fyjku2(n7'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'common',
    'access',
    'utenti',
    'home',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'Acquisti.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'Acquisti.wsgi.application'
#LDAP
NOME_ISTITUTO = "Osservatorio Astrofisico di Torino"
AUTHENTICATION_BACKENDS = ("django_auth_ldap.backend.LDAPBackend","django.contrib.auth.backends.ModelBackend",) #'login.cavbackend.CavBackend',)

AUTH_LDAP_SERVER_URI = "ldap://ldap.ced.inaf.it:389"
AUTH_LDAP_CONNECTION_OPTIONS = {ldap.OPT_REFERRALS: 0}

AUTH_LDAP_BIND_DN = ""
AUTH_LDAP_BIND_PASSWORD = ""
#AUTH_LDAP_USER_SEARCH = LDAPSearch("ou=people,dc=inaf,dc=it", ldap.SCOPE_SUBTREE, "(uid=%(user)s)")
AUTH_LDAP_USER_DN_TEMPLATE = "uid=%(user)s,ou=people,dc=inaf,dc=it"

# Set up the basic group parameters.
AUTH_LDAP_GROUP_SEARCH = LDAPSearch(
    'ou=O.A. Torino,ou=groups,dc=inaf,dc=it',
    ldap.SCOPE_SUBTREE,
    '(objectClass=groupOfNames)',
)
AUTH_LDAP_GROUP_TYPE = GroupOfNamesType(name_attr='ou')

AUTH_LDAP_START_TLS = False
# Populate the Django user from the LDAP directory.
AUTH_LDAP_USER_ATTR_MAP = {
    #"username": "uid",
    "first_name": "givenName",
    "last_name": "sn",
    "email": "mail",
}
# This is the default, but I like to be explicit.
AUTH_LDAP_ALWAYS_UPDATE_USER = True

# Database
# https://docs.djangoproject.com/en/3.1/ref/settings/#databases

DATABASES = {
'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'NAME': 'Acquisti',
        'USER': 'postgres',
        'HOST': 'localhost',
        'PORT': '5432',
        # Do not put password here, instead write it in the .pgpass file of the user running django
        'PASSWORD': 'postgres',
        # Create a DB transaction for each view call
        'ATOMIC_REQUESTS': True,
        },
    'sqllite': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

# Password validation
# https://docs.djangoproject.com/en/3.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.1/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.1/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, "static")

AUTH_LDAP_SERVER_URI = "ldap://ldap.ced.inaf.it:389"
AUTH_LDAP_CONNECTION_OPTIONS = {ldap.OPT_REFERRALS: 0}
UFFICI = ['Personale','Tecnico','Ragioneria','Acquisti','Protocollo','Segr. Direzione']

DIRETTORE = 'silvano.fineschi@inaf.it'
RESPONSABILE_UFFICIO_CONTABILITA = 'tiziana.gamba@inaf.it'
RESPONSABILE_UFFICIO_ACQUISTI = 'luigi.genesi@inaf.it'
UFFICIO_ACQUISTI = ['luigi.genesi@inaf.it','laura.roma@inaf.it','giuseppina.antico@inaf.it']

EMAIL_HOST = 'smtp.gmail.com'
EMAIL_HOST_USER = 'ca.volpicelli@gmail.com'
EMAIL_HOST_PASSWORD = 'caV#290957#Vac'
EMAIL_PORT = 587
EMAIL_USE_TLS =True
EMAIL_USE_SSL = False

REPOSITORY_ALLEGATI = '/srv/Acquisti/allegati/' 