/* file to store global variables*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef USE_MPI
#include <mpi.h>
#ifdef USE_FFTW
#ifndef CUFFTMP
#include <fftw3-mpi.h>
#endif
#endif
#endif
#ifdef ACCOMP
#include "w-stacking_omp.h"
#else
#include "w-stacking.h"
#endif
#ifdef NVIDIA
#include <cuda_runtime.h>
#endif
#define PI 3.14159265359
#define NUM_OF_SECTORS -1
#define MIN(X, Y) (((X) < (Y)) ? (X) : (Y))
#define MAX(X, Y) (((X) > (Y)) ? (X) : (Y))
#define NOVERBOSE
#define NFILES 100
#include <omp.h>
#include <math.h>
#include <time.h>
#include <unistd.h>

extern struct io
{
	FILE * pFile;
        FILE * pFile1;
        FILE * pFilereal;
        FILE * pFileimg;
} file;

extern struct ip
{
	char ufile[30];
  	char vfile[30];
  	char wfile[30];
  	char weightsfile[30];
  	char visrealfile[30];
  	char visimgfile[30];
  	char metafile[30];
        char paramfile[30];
} in;

extern struct op
{
	char outfile[30];
        char outfile1[30];
        char outfile2[30];
        char outfile3[30];
        char fftfile[30];
        char fftfile2[30];
        char fftfile3[30];
        char logfile[30];
        char extension[30];
        char timingfile[30];

} out, outparam;

extern struct meta
{

	long Nmeasures;
        long Nvis;
        long Nweights;
        long freq_per_chan;
        long polarisations;
        long Ntimes;
        double dt;
        double thours;
        long baselines;
        double uvmin;
        double uvmax;
        double wmin;
        double wmax;

} metaData;


extern struct time
{
   	double setup_time, process_time, mpi_time, fftw_time, tot_time, kernel_time, reduce_time, compose_time, phase_time;
	double setup_time1, process_time1, mpi_time1, fftw_time1, tot_time1, kernel_time1, reduce_time1, compose_time1, phase_time1;
	double writetime, writetime1;

} timing;

extern struct parameter
{
        int num_threads;
        int ndatasets;
        char datapath_multi[NFILES][900];
        int grid_size_x;
        int grid_size_y;
        int num_w_planes;
        int w_support;
} param;

extern struct fileData
{
        double * uu;
        double * vv;
        double * ww;
        float * weights;
        float * visreal;
        float * visimg;
}data;


extern char filename[1000], buf[30], num_buf[30];
extern char datapath[900];
extern int xaxis, yaxis;
extern int rank;
extern int size;
extern long nsectors;
extern long startrow;
extern double resolution, dx, dw, w_supporth;

extern clock_t start, end, start0, startk, endk;
extern struct timespec begin, finish, begin0, begink, finishk;
extern long * histo_send, size_of_grid;
extern double * grid, *gridss, *gridss_real, *gridss_img, *gridss_w;

#ifdef USE_MPI
    extern  MPI_Win slabwin;
#endif

extern long **sectorarray;
