import numpy as np
import h5py
import tensorflow as tf
from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import Dense
from tensorflow.keras.optimizers import Adam
from tensorflow.keras import metrics
from tensorflow.keras.layers import Dropout
from tensorflow.keras.layers import BatchNormalization
from data_loader import *

n_in = 5
n_out = 1

infilename = "/m100_work/IscrC_CD-DLS/simulations/"
rho, T, vx, vy, vz, Bx, By, Bz, B2 = load_data(infilename, [500, 500, 500], [1000, 1000, 501])

n_cells = rho.size
n_train = n_cells

Xtrain = np.zeros((n_train, n_in),dtype=np.float64)
Ytrain = np.zeros((n_train, n_out),dtype=np.float64)

xxx = rho.flatten()
Xtrain[0:n_train,0] = xxx[0:n_train]
xxx = T.flatten()
Xtrain[0:n_train,1] = xxx[0:n_train]
xxx = vx.flatten()
Xtrain[0:n_train,2] = xxx[0:n_train]
xxx = vy.flatten()
Xtrain[0:n_train,3] = xxx[0:n_train]
xxx = vz.flatten()
Xtrain[0:n_train,4] = xxx[0:n_train]

Bxx = Bx.flatten()
Bxy = By.flatten()
Bxz = Bz.flatten()
Bx2 = B2.flatten()

# save the trained network
ckptfile = 'models/trained_networ.ckpt'
model = tf.keras.models.load_model(ckptfile)
model.summary()

Ytrain = model.predict(Xtrain)
print(Ytrain.shape)

Bx2.tofile('B.bin')
Xtrain[:,0].tofile('rho.bin')
Xtrain[:,1].tofile('T.bin')
#B2 = Ytrain[:,0]
#B2.tofile('eval.bin')
Ytrain[:,0].tofile('eval.bin')


