function getCoordinates() {

    // Previous results cleanup
    document.getElementById('loading').classList.remove('hide');
    document.getElementById('result').classList.add('hide');
    document.getElementById('result-list').innerHTML = '';
    document.getElementById('error').classList.add('hide');

    // Retrieve object name
    let objectName = document.getElementById('object_name').value;

    // Call the server
    fetch('coords?object=' + objectName)
            .then(response => response.json())
            .then(data => {
                if (typeof data['error'] === 'undefined') {
                    // Build results list
                    let resultsHTML = '';
                    for (let key in data) {
                        resultsHTML += '<li><strong>' + key + '</strong>: ' + data[key] + '</li>';
                    }
                    document.getElementById('result-list').innerHTML = resultsHTML;
                    document.getElementById('result').classList.remove('hide');
                } else {
                    // Show error
                    let errorElement = document.getElementById('error');
                    errorElement.classList.remove('hide');
                    errorElement.innerText = data['error'];
                }
            })
            .finally(() => {
                document.getElementById('loading').classList.add('hide');
            });
}

// Event handlers
document.getElementById('get_coordinates').onclick = getCoordinates;

document.getElementById('object_name').onkeydown = function(event) {
    // Enter key event
    if(event.keyCode === 13) {
        getCoordinates();
    }
};
