from astropy.coordinates import AltAz, EarthLocation, SkyCoord
from astropy.time import Time


def get_location_name(location_id):
    return EarthLocation.of_site(location_id).info.name


def get_coords(object_name, location_id):
    object_coord = SkyCoord.from_name(object_name)
    location = EarthLocation.of_site(location_id)
    alt_az = AltAz(location=location, obstime=Time.now())
    object_coord = object_coord.transform_to(alt_az)
    return {'Alt': format_angle(object_coord.alt), 'Az': format_angle(object_coord.az)}


def format_angle(angle):
    return angle.to_string().replace('d', 'd ').replace('m', 'm ')
