# Coords Library

Toy Python module for demonstrating GitLab CI features.

## Example usage

```python
import coords

# -- Returns complete name from Astropy observatory identifier --
print(coords.get_location_name('ekar'))
# 'Mt. Ekar 182 cm. Telescope'
print(coords.get_location_name('lbt'))
# 'Large Binocular Telescope'

# -- Returns object coordinates for a given observatory at current time --
print(coords.get_coords('m31', 'lbt'))
# {'Alt': '47d 13m 43.8866s', 'Az': '62d 25m 55.5019s'}
print(coords.get_coords('m31', 'ekar'))
# {'Alt': '41d 59m 31.3084s', 'Az': '290d 28m 01.2741s'}
```
