/**_____________________________________________________________________________
 *
 *                                 OATS - INAF
 *  Osservatorio Astronomico di Tireste - Istituto Nazionale di Astrofisica
 *  Astronomical Observatory of Trieste - National Institute for Astrophysics
 * ____________________________________________________________________________
 *
 * Copyright (C) 20016  Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * _____________________________________________________________________________
 **/
package test;

import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.vos.Protocol;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.HttpRequestProperty;

import it.inaf.oats.vospacebackend.implementation.TransferGeneratorImpl;
import java.net.URL;
import java.util.List;
import java.util.ArrayList;
import java.io.File;
import java.io.IOException;

/**
 *
 * @author bertocco
 */
public class ServiceTester {

    public static void main(String[] args) {

        TransferGeneratorImpl transGen = new TransferGeneratorImpl();
        
        String vosuriStr = "vos://ia2.inaf.it!vospace/filepath/clean_build.tar.gz";
        try {
            VOSURI target = new VOSURI(vosuriStr);
            String URL1 = "http://example.com/someplace/123";
            Protocol protocol = new Protocol(VOS.PROTOCOL_HTTP_GET, URL1, null) ;
            View view = null;
            Job job = new Job();
            List<Parameter> additionalParams = null;
        
            List<URL> urlList = transGen.getURLs(target, protocol, view, job, additionalParams);
            
            
            String fileToManage;
            String urlStr = "";
            for (URL temp : urlList) {
                urlStr = temp.toString();                
                System.out.println(urlStr);
                
                //{security_token}/{unique_file_id_string}/{fileToManage}

                fileToManage = urlStr.substring(urlStr.lastIndexOf("/")+1);
            }
            
            URL url = new URL(urlStr);
            File localFile = new File ("/root/clean_build.tar.gz");
            List<HttpRequestProperty> httpRequestProperties = new ArrayList<HttpRequestProperty>();
            int maxRetries =3;
            HttpUpload upload;
            upload = new HttpUpload(localFile, url);
        
            System.out.println("calling HttpUpload.setRequestProperties with " + httpRequestProperties.size() + " props");
            upload.setRequestProperties(httpRequestProperties);
            upload.setMaxRetries(maxRetries);
        
            upload.run();
        
            if (upload.getThrowable() != null) {
                // allow illegal arugment exceptions through
                if (upload.getThrowable() instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException) upload.getThrowable();
                } else {
                    try {
                        throw new IOException("failed to upload file", upload.getThrowable());
                    } catch (NoSuchMethodError e) {
                        // Java5 does not have the above constructor.
                        throw new IOException("failed to upload file: " + upload.getThrowable().getMessage());
                    }
                }
            }

        } catch (Exception e) {
            System.out.println("Exception :" + e.getMessage());
        } // end of externals try/catch
        
    } // end of method
    
}
