/**_____________________________________________________________________________
 *
 *                                 OATS - INAF
 *  Osservatorio Astronomico di Tireste - Istituto Nazionale di Astrofisica
 *  Astronomical Observatory of Trieste - National Institute for Astrophysics
 * ____________________________________________________________________________
 *
 * Copyright (C) 20016  Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * _____________________________________________________________________________
 **/

/*
This file contains the complete database needed to run a VOSpace:
the VOSpace front-end tables to manage stored files metadata
the VOSpace back-end tables to manage stored files 
the UWS tables to manage Job metadata
*/

/*
    DataBase creation and grant assignment
*/

CREATE DATABASE cadctest;

use cadctest;

grant all on cadctest.* to 'oatsops' identified by 'Peper0ne';

/*
    VOSpace back-end
*/
CREATE TABLE StoredFiles
(
    fileID int NOT NULL AUTO_INCREMENT, 
    stored_file_name varchar(36) NOT NULL,
    md5_checksum varchar(36) NOT NULL,
    relative_path varchar(8),
    PRIMARY KEY (fileID)
) ENGINE=InnoDB; 


CREATE TABLE StoredFileAndNode
(    
    storedFileID      varchar(255)         NOT NULL,
    nodeID            BIGINT(20)           NOT NULL, 
    PRIMARY KEY (storedFileID)
) ENGINE=InnoDB; 



/*
    VOSpace front-end
*/

CREATE TABLE Node
(
 nodeID           BIGINT(20) NOT NULL AUTO_INCREMENT,
 parentID         BIGINT(20)    default NULL, 
 name             VARCHAR(256)  NOT NULL,
 type             CHAR(1)       NOT NULL,
 busyState        CHAR(1)       NOT NULL,
 ownerID          INT(40)       NOT NULL, 
 creatorID        INT(40)       NOT NULL,                
 groupRead        VARCHAR(256)  default NULL,                
 groupWrite       VARCHAR(256)  default NULL,               
 isPublic         BIT(1)        NOT NULL,
 isLocked         BIT(1)        NOT NULL,
 delta            BIGINT(20)    default NULL,              
 contentType      VARCHAR(100)  default NULL,                 
 contentEncoding  VARCHAR(50)   default NULL,                 
 contentLength    BIGINT(20)    default NULL,               
 contentMD5       BINARY(16)    default NULL,                
 createdOn        DATETIME      default CURRENT_TIMESTAMP,                
 lastModified     DATETIME      NOT NULL,             
 link             TEXT          default NULL,   
  PRIMARY KEY (nodeID)            
) ENGINE=InnoDB;


CREATE TABLE NodeProperty
(
   nodeID            BIGINT(20)        NOT NULL,
   propertyURI       VARCHAR(256)      NOT NULL,
   propertyValue     VARCHAR(512)      default NULL,
   lastModified      DATETIME          default CURRENT_TIMESTAMP,
-- support replication with a fake primary key
   _rep_support      bigint(20) NOT NULL PRIMARY KEY,
   foreign key (nodeID) references Node (nodeID)
) ENGINE=InnoDB;


CREATE TABLE DeletedNode
(
    nodeID        bigint(20)    NOT NULL 
    name          varchar(276)  NOT NULL,
    ownerID       varchar(256)  NOT NULL,
    lastModified  DATETIME      NOT NULL,
    PRIMARY KEY (nodeID)
) ENGINE=InnoDB;


/*
    UWS
*/

create table Job
(
    jobID                   varchar(16)     NOT NULL,
    runID                   varchar(128),

-- suitable column when using the X500IdentityManager
    ownerID                 varchar(128),

    executionPhase          varchar(16)     not null,
    executionDuration       bigint (20)     not null,
    destructionTime         DATETIME,
    quote                   DATETIME,
    startTime               DATETIME,
    endTime                 DATETIME,
    error_summaryMessage    varchar(1024),
    error_type              varchar(16),
    error_documentURL       varchar(128), 
    requestPath             varchar(128),
    remoteIP                varchar(20),
    jobInfo_content         varchar(1000)
    jobInfo_contentType     varchar(128),
    jobInfo_valid           smallint(6),
    deletedByUser           smallint(6)     default 0,
    lastModified            DATETIME       not null,
    primary key (jobID)
) ENGINE=InnoDB;


create table JobDetail
(
    jobID                   varchar(16)     not null,
    type                    char(1)         not null,
    name                    varchar(128)    not null,
    value                   varchar(128),

    foreign key (jobID) references Job (jobID)
) ENGINE=InnoDB;

create index uws_param_i1 on JobDetail(jobID);

/*
   Initialize root node for vospace
*/

insert into Node (name, parentID, type, busyState, ownerID, creatorID, groupRead, groupWrite, isPublic, isLocked,lastModified) values ('vospaceRootNode', NULL, 'C', 'N', '123456789', '123456789', 'inaf-ops', 'inaf-ops', 1, 0, '2016-04-15 11:51:09');


/* Should be:

select * from Node where name='MyVoNode';
+--------+----------+----------+------+-----------+-----------+-----------+-----------+------------+----------+----------+-------+-------------+-----------------+---------------+------------+---------------------+---------------------+------+
| nodeID | parentID | name     | type | busyState | ownerID   | creatorID | groupRead | groupWrite | isPublic | isLocked | delta | contentType | contentEncoding | contentLength | contentMD5 | createdOn           | lastModified        | link |
+--------+----------+----------+------+-----------+-----------+-----------+-----------+------------+----------+----------+-------+-------------+-----------------+---------------+------------+---------------------+---------------------+------+
|      1 |     NULL | myVONode | C    | N         | 123456789 | 123456789 | inaf-ops  | inaf-ops   |         |          |  NULL | NULL        | NULL            |          NULL | NULL       | 2016-07-01 13:19:07 | 2016-06-30 11:51:09 | NULL |
+--------+----------+----------+------+-----------+-----------+-----------+-----------+------------+----------+---------

where 123456789 is the numeric ID of the owner (admin) in the ldap server and inaf-ops is a group in ldap belongind to ldap admin groups. 123456789 must belong to the group inaf-ops
*/