/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.xml;

import ca.nrc.cadc.xml.ContentConverter;
import ca.nrc.cadc.xml.MaxIterations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableContent<E extends Content, T>
extends Element {
    private static Logger log = Logger.getLogger(IterableContent.class);
    private static final long serialVersionUID = -3057526491224781782L;
    private Iterator<T> iterator;
    private ContentConverter<E, T> contentConverter;
    private MaxIterations maxIterations;

    public IterableContent(String name, Namespace ns, Iterator<T> iterator, ContentConverter<E, T> contentConverter) {
        super(name, ns);
        log.debug((Object)"IterableContent contructed.");
        this.iterator = iterator;
        this.contentConverter = contentConverter;
    }

    public IterableContent(String name, Namespace ns, Iterator<T> iterator, ContentConverter<E, T> contentConverter, MaxIterations maxIterations) {
        super(name, ns);
        log.debug((Object)"IterableContent contructed.");
        this.iterator = iterator;
        this.contentConverter = contentConverter;
        this.maxIterations = maxIterations;
    }

    public List<Content> getContent() {
        log.debug((Object)"Get content called.");
        IterableList<T, T> iterableList = new IterableList<T, T>(this.iterator, this.contentConverter, this.maxIterations);
        return iterableList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentConversionIterator<A extends Content, B>
    implements Iterator<A> {
        private ContentConverter<A, B> contentConverter;
        private MaxIterations maxIterations;
        private Iterator<B> iterator;
        private B next;
        private long rowCount = 0L;
        private boolean maxIterationsReached = false;
        private boolean maxIterationsReachedCalled = false;

        ContentConversionIterator(ContentConverter<A, B> contentConverter, Iterator<B> iterator, MaxIterations maxIterations) {
            log.debug((Object)"ContentConversionIterator contructed.");
            this.contentConverter = contentConverter;
            this.iterator = iterator;
            this.maxIterations = maxIterations;
            this.advance();
        }

        private void advance() {
            this.next = null;
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
            }
            if (this.maxIterations != null && this.rowCount >= this.maxIterations.getMaxIterations()) {
                this.maxIterationsReached = true;
                this.next = null;
            }
            ++this.rowCount;
        }

        boolean isEmpty() {
            return this.next == null;
        }

        @Override
        public boolean hasNext() {
            if (this.maxIterationsReached && !this.maxIterationsReachedCalled) {
                this.maxIterations.maxIterationsReached();
                this.maxIterationsReachedCalled = true;
            }
            return this.next != null;
        }

        @Override
        public A next() {
            log.debug((Object)"ContentConversionIterator.next");
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            A nextContent = this.contentConverter.convert(this.next);
            this.advance();
            return nextContent;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterableList<C extends Content, D>
    extends ArrayList<C> {
        private static final long serialVersionUID = 1932716563665349508L;
        private ContentConversionIterator<C, D> iterator;

        public IterableList(Iterator<C> iterator, ContentConverter<C, D> contentConverter, MaxIterations maxIterations) {
            log.debug((Object)"IterableList contructed.");
            this.iterator = new ContentConversionIterator<C, D>(contentConverter, iterator, maxIterations);
        }

        @Override
        public boolean isEmpty() {
            log.debug((Object)"IterableList.isEmpty() called.");
            return this.iterator.isEmpty();
        }

        @Override
        public Iterator<C> iterator() {
            log.debug((Object)"IterableList.iterator() called.");
            return this.iterator;
        }

        @Override
        public boolean add(C c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i, C c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends C> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i, Collection<? extends C> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public C get(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<C> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public C remove(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public C set(int i, C c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<C> subList(int i, int j) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }
    }
}

