/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.util.MultiValuedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesReader {
    private static final Logger log = Logger.getLogger(PropertiesReader.class);
    private static final String DEFAULT_CONFIG_DIR = System.getProperty("user.home") + "/config/";
    private static final String CONFIG_DIR_SYSTEM_PROPERTY = PropertiesReader.class.getName() + ".dir";
    private File propertiesFile;
    private String filepath;
    private static Map<String, MultiValuedProperties> cachedProperties = new ConcurrentHashMap<String, MultiValuedProperties>();

    public PropertiesReader(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        String configDir = DEFAULT_CONFIG_DIR;
        if (System.getProperty(CONFIG_DIR_SYSTEM_PROPERTY) != null) {
            configDir = System.getProperty(CONFIG_DIR_SYSTEM_PROPERTY);
        }
        if (!configDir.endsWith("/")) {
            configDir = configDir + "/";
        }
        this.filepath = configDir + filename;
        this.propertiesFile = new File(this.filepath);
        if (!this.propertiesFile.exists() || !this.propertiesFile.isFile()) {
            log.warn((Object)("File at " + this.filepath + " does not exist."));
            this.propertiesFile = null;
        }
    }

    public MultiValuedProperties getAllProperties() {
        MultiValuedProperties properties = null;
        if (this.propertiesFile != null) {
            try {
                FileInputStream in = new FileInputStream(this.propertiesFile);
                properties = new MultiValuedProperties();
                properties.load(in);
            }
            catch (IOException e) {
                properties = null;
            }
        }
        if (properties == null) {
            log.warn((Object)("No file resource available at " + this.filepath));
            MultiValuedProperties cachedVersion = cachedProperties.get(this.filepath);
            if (cachedVersion == null) {
                log.warn((Object)("No cached resource available at " + this.filepath));
                return null;
            }
            log.warn((Object)("Properties missing at " + this.filepath + " Using earlier version."));
            properties = cachedVersion;
        } else {
            cachedProperties.put(this.filepath, properties);
        }
        return properties;
    }

    public List<String> getPropertyValues(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Provided key is null.");
        }
        MultiValuedProperties properties = this.getAllProperties();
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    public String getFirstPropertyValue(String key) {
        List<String> values = this.getPropertyValues(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

