/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class NetrcFile
extends File {
    private static final long serialVersionUID = 201205161150L;
    private static final Logger log = Logger.getLogger(NetrcFile.class);
    private boolean debug = false;
    private static String DEFAULT_MACHINE = "*";
    private List<Cred> cache;
    private long timestamp;
    private boolean secureMode;

    public NetrcFile(boolean secureMode) {
        super(System.getProperty("user.home"), ".netrc");
        this.secureMode = secureMode;
    }

    NetrcFile(String netrcFile) {
        super(netrcFile);
    }

    public NetrcFile() {
        this(true);
    }

    public PasswordAuthentication getCredentials(String host, boolean strict) {
        return this.readFromCache(host, strict);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char[] readEntireFile() throws IOException {
        FileReader fr = null;
        char[] c = new char[(int)this.length()];
        try {
            try {
                fr = new FileReader(this);
                int n = fr.read(c, 0, c.length);
                int n2 = 1;
                while (n2 > 0) {
                    n2 = fr.read(c, n, c.length - n);
                    if (n2 < 0) continue;
                    n += n2;
                }
                Object var6_6 = null;
                if (fr == null) return c;
            }
            catch (IOException ex) {
                if (c == null) throw ex;
                Arrays.fill(c, '0');
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fr == null) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fr.close();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PasswordAuthentication readFromCache(String host, boolean strict) {
        block4: {
            PasswordAuthentication passwordAuthentication;
            try {
                this.initCache();
                if (this.cache == null) break block4;
                log.debug((Object)("looking for '" + host + "'"));
                Cred defaultCred = null;
                for (int i = 0; i < this.cache.size(); ++i) {
                    Cred cred = this.cache.get(i);
                    log.debug((Object)("checking '" + cred + "'"));
                    if (cred.machine.equals(host)) {
                        PasswordAuthentication passwordAuthentication2 = new PasswordAuthentication(cred.login, cred.pword);
                        Object var8_8 = null;
                        this.clearCache();
                        return passwordAuthentication2;
                    }
                    if (!DEFAULT_MACHINE.equals(cred.machine)) continue;
                    defaultCred = cred;
                }
                if (strict || defaultCred == null) break block4;
                passwordAuthentication = new PasswordAuthentication(defaultCred.login, defaultCred.pword);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.clearCache();
                throw throwable;
            }
            Object var8_9 = null;
            this.clearCache();
            return passwordAuthentication;
        }
        Object var8_10 = null;
        this.clearCache();
        return null;
    }

    private void clearCache() {
        if (this.cache == null) {
            return;
        }
        if (this.secureMode) {
            for (int i = 0; i < this.cache.size(); ++i) {
                Cred cred = this.cache.get(i);
                Arrays.fill(cred.pword, '0');
            }
            this.cache.clear();
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initCache() {
        if (this.cache != null && this.timestamp == this.lastModified()) {
            log.debug((Object)"cache is up to date");
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<Cred>();
        } else {
            this.cache.clear();
        }
        this.timestamp = this.lastModified();
        char[] c = null;
        try {
            try {
                log.debug((Object)"reading entire file...");
                c = this.readEntireFile();
                log.debug((Object)("looking through char[" + c.length + "] for tokens"));
                int start = 0;
                int i = 0;
                boolean inToken = false;
                char lineSep = System.getProperty("line.separator").charAt(0);
                while (i < c.length) {
                    if (inToken) {
                        int e;
                        while (i < c.length && c[i] != lineSep) {
                            ++i;
                        }
                        if (i <= start) continue;
                        for (e = i; e > start && Character.isWhitespace(c[e - 1]); --e) {
                        }
                        Cred cred = new Cred(c, start, e - start);
                        log.debug((Object)("found: " + cred));
                        if (cred.valid) {
                            this.cache.add(cred);
                        }
                        inToken = false;
                        continue;
                    }
                    while (i < c.length && Character.isWhitespace(c[i])) {
                        ++i;
                    }
                    if (i >= c.length) continue;
                    inToken = true;
                    start = i;
                }
                Object var9_9 = null;
                if (c == null) return;
            }
            catch (IOException ex) {
                log.warn((Object)("failed to read " + this.getAbsolutePath() + ": " + ex));
                this.clearCache();
                Object var9_10 = null;
                if (c == null) return;
                Arrays.fill(c, '0');
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (c == null) throw throwable;
            Arrays.fill(c, '0');
            throw throwable;
        }
        Arrays.fill(c, '0');
    }

    private class Cred {
        boolean valid = false;
        String machine;
        String login;
        char[] pword;

        Cred(char[] cbuf, int offset, int count) {
            int start = offset;
            int end = offset + count;
            int i = offset;
            boolean inToken = true;
            while (i < end) {
                if (inToken) {
                    while (i < end && !Character.isWhitespace(cbuf[i])) {
                        ++i;
                    }
                    int len = i - start;
                    String s = new String(cbuf, start, len);
                    if ("machine".equals(s)) {
                        start = this.nextToken(cbuf, i, end);
                        if ((i = this.nextWhitespace(cbuf, start, end)) > start) {
                            this.machine = new String(cbuf, start, i - start);
                        }
                    } else if ("login".equals(s)) {
                        start = this.nextToken(cbuf, i, end);
                        if ((i = this.nextWhitespace(cbuf, start, end)) > start) {
                            this.login = new String(cbuf, start, i - start);
                        }
                    } else if ("password".equals(s)) {
                        start = this.nextToken(cbuf, i, end);
                        if ((i = this.nextWhitespace(cbuf, start, end)) > start) {
                            this.pword = new char[i - start];
                            System.arraycopy(cbuf, start, this.pword, 0, i - start);
                        }
                    } else if ("default".equals(s)) {
                        this.machine = "*";
                    }
                    inToken = false;
                    continue;
                }
                if ((i = this.nextToken(cbuf, i, end)) >= end) continue;
                inToken = true;
                start = i;
            }
            this.valid = this.machine != null && this.login != null && this.pword != null;
        }

        private int nextWhitespace(char[] cbuf, int i, int end) {
            while (i < end && !Character.isWhitespace(cbuf[i])) {
                ++i;
            }
            return i;
        }

        private int nextToken(char[] cbuf, int i, int end) {
            while (i < end && Character.isWhitespace(cbuf[i])) {
                ++i;
            }
            return i;
        }

        public String toString() {
            return "Cred[" + this.machine + "," + this.login + ",********]";
        }
    }
}

