/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.net.SchemeHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSchemeHandler
implements SchemeHandler {
    private static final Logger log = Logger.getLogger(MultiSchemeHandler.class);
    private static final String CACHE_FILENAME = MultiSchemeHandler.class.getSimpleName() + ".properties";
    private final Map<String, SchemeHandler> handlers = new HashMap<String, SchemeHandler>();

    public MultiSchemeHandler() {
        this(MultiSchemeHandler.class.getClassLoader().getResource(CACHE_FILENAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiSchemeHandler(URL url) {
        if (url == null) {
            log.debug((Object)"config URL is null: no custom scheme support");
            return;
        }
        try {
            try {
                Properties props = new Properties();
                props.load(url.openStream());
                for (String scheme : props.stringPropertyNames()) {
                    String cname = props.getProperty(scheme);
                    try {
                        log.debug((Object)("loading: " + cname));
                        Class<?> c = Class.forName(cname);
                        log.debug((Object)("instantiating: " + c));
                        SchemeHandler handler = (SchemeHandler)c.newInstance();
                        log.debug((Object)("adding: " + scheme + "," + handler));
                        this.handlers.put(scheme, handler);
                        log.debug((Object)("success: " + scheme + " is supported"));
                    }
                    catch (Exception fail) {
                        log.warn((Object)("failed to load " + cname + ", reason: " + fail));
                    }
                }
                Object var9_10 = null;
            }
            catch (Exception ex) {
                log.error((Object)("failed to read config from " + url), (Throwable)ex);
                Object var9_11 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            throw throwable;
        }
    }

    @Override
    public List<URL> toURL(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            return null;
        }
        SchemeHandler sh = this.handlers.get(uri.getScheme());
        if (sh != null) {
            return sh.toURL(uri);
        }
        try {
            URL url = uri.toURL();
            String frag = uri.getFragment();
            if (frag != null) {
                String s = uri.toString().replace('#', '?');
                url = new URL(s);
            }
            ArrayList<URL> ret = new ArrayList<URL>();
            ret.add(url);
            return ret;
        }
        catch (MalformedURLException mex) {
            throw new IllegalArgumentException("unknown URI scheme: " + uri.getScheme(), mex);
        }
    }

    public void addSchemeHandler(String scheme, SchemeHandler handler) {
        this.handlers.put(scheme, handler);
    }
}

