/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.exec;

import ca.nrc.cadc.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderOutputGrabber {
    private static Logger log = Logger.getLogger(BuilderOutputGrabber.class);
    private final StringBuilder stdout = new StringBuilder();
    private final StringBuilder stderr = new StringBuilder();
    private int exit_value;

    public void captureOutput(String cmd) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            log.debug((Object)("exec: " + cmd));
            Process p = processBuilder.start();
            this.grabOutput(p);
        }
        catch (IOException ioex) {
            this.getStderr().append("IOException: ").append(ioex);
            this.exit_value = -1;
        }
        catch (InterruptedException irex) {
            this.getStderr().append("InterruptedException: ").append(irex);
            this.exit_value = -1;
        }
        catch (Exception ex) {
            this.getStderr().append("Exception: ").append(ex);
            this.exit_value = -1;
        }
    }

    public void captureOutput(String[] cmd) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            log.debug((Object)("exec: " + this.concat(cmd)));
            Process p = processBuilder.start();
            this.grabOutput(p);
        }
        catch (IOException ioex) {
            this.getStderr().append("IOException: ").append(ioex);
            this.exit_value = -1;
        }
        catch (InterruptedException irex) {
            this.getStderr().append("InterruptedException: ").append(irex);
            this.exit_value = -1;
        }
        catch (Exception ex) {
            this.getStderr().append("Exception: ").append(ex);
            this.exit_value = -1;
        }
    }

    public void captureOutput(String[] cmd, Map<String, String> env) {
        try {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.addAll(Arrays.asList(cmd));
            ProcessBuilder processBuilder = new ProcessBuilder(parameters);
            if (env != null) {
                Map<String, String> environment = processBuilder.environment();
                environment.clear();
                environment.putAll(env);
            }
            log.debug((Object)("exec: " + this.concat(cmd) + "\nenv: " + this.concat(env)));
            Process p = processBuilder.start();
            this.grabOutput(p);
        }
        catch (IOException ioex) {
            this.getStderr().append("IOException: ").append(ioex);
            this.exit_value = -1;
        }
        catch (InterruptedException irex) {
            this.getStderr().append("InterruptedException: ").append(irex);
            this.exit_value = -1;
        }
        catch (Exception ex) {
            this.getStderr().append("Exception: ").append(ex);
            this.exit_value = -1;
        }
    }

    public void captureOutput(String[] cmd, Map<String, String> env, File dir) {
        try {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.addAll(Arrays.asList(cmd));
            ProcessBuilder processBuilder = new ProcessBuilder(parameters);
            if (env != null) {
                Map<String, String> environment = processBuilder.environment();
                environment.clear();
                environment.putAll(env);
            }
            log.debug((Object)("exec: " + this.concat(cmd) + "\nenv: " + this.concat(env) + "\ndir: " + dir));
            processBuilder.directory(dir);
            Process p = processBuilder.start();
            this.grabOutput(p);
        }
        catch (IOException ioex) {
            this.getStderr().append("IOException: ").append(ioex);
            this.exit_value = -1;
        }
        catch (InterruptedException irex) {
            this.getStderr().append("InterruptedException: ").append(irex);
            this.exit_value = -1;
        }
        catch (Exception ex) {
            this.getStderr().append("Exception: ").append(ex);
            this.exit_value = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grabOutput(Process p) throws IOException, InterruptedException {
        InputStream pi = null;
        InputStream pe = null;
        OutputStream po = null;
        try {
            pi = p.getInputStream();
            pe = p.getErrorStream();
            po = p.getOutputStream();
            ReaderThread out = new ReaderThread(pi, this.getStdout());
            out.start();
            ReaderThread err = new ReaderThread(pe, this.getStderr());
            err.start();
            out.join();
            err.join();
            this.exit_value = p.waitFor();
            if (out.ex != null) {
                this.getStderr().append("exception while reading command output:\n").append(out.ex.toString());
            }
            if (err.ex != null) {
                this.getStderr().append("exception while reading command error output:\n").append(err.ex.toString());
            }
        }
        finally {
            if (pi != null) {
                try {
                    pi.close();
                }
                catch (IOException iOException) {}
            }
            if (pe != null) {
                try {
                    pe.close();
                }
                catch (IOException iOException) {}
            }
            if (po != null) {
                try {
                    po.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getOutput(boolean doTrim) {
        if (doTrim) {
            return this.getStdout().toString().trim();
        }
        return this.getStdout().toString();
    }

    public String getErrorOutput(boolean doTrim) {
        if (doTrim) {
            return this.getStderr().toString().trim();
        }
        return this.getStderr().toString();
    }

    public String getOutput() {
        return this.getOutput(true);
    }

    public String getErrorOutput() {
        return this.getErrorOutput(true);
    }

    public StringBuilder getStdout() {
        return this.stdout;
    }

    public StringBuilder getStderr() {
        return this.stderr;
    }

    public int getExitValue() {
        return this.exit_value;
    }

    private String concat(String[] s) {
        if (ArrayUtil.isEmpty(s)) {
            return null;
        }
        if (s.length == 1) {
            return s[0];
        }
        StringBuilder sb = new StringBuilder();
        for (String value : s) {
            sb.append(value).append(" ");
        }
        return sb.toString();
    }

    private String concat(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : map.keySet()) {
            sb.append(key);
            sb.append(' ');
            sb.append(map.get(key));
            sb.append(' ');
        }
        return sb.toString();
    }

    private class ReaderThread
    extends Thread {
        public Exception ex;
        private StringBuilder sb;
        private LineNumberReader reader;

        public ReaderThread(InputStream istream, StringBuilder sb) {
            this.reader = new LineNumberReader(new InputStreamReader(istream));
            this.sb = sb;
        }

        public void run() {
            try {
                String s;
                while ((s = this.reader.readLine()) != null) {
                    this.sb.append(s).append("\n");
                }
            }
            catch (Exception iex) {
                this.ex = iex;
            }
        }
    }
}

