/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.util.Base64;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertificateChain {
    public static final String CERT_BEGIN = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_END = "-----END CERTIFICATE-----";
    public static final String PRIVATE_KEY_BEGIN = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PRIVATE_KEY_END = "-----END RSA PRIVATE KEY-----";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static Logger log = Logger.getLogger(X509CertificateChain.class);
    private X500Principal principal;
    private X509Certificate endEntity;
    private X509Certificate[] chain;
    private PrivateKey key;
    private boolean isProxy;
    private Date expiryDate;
    private String csrString;
    private String hashKey;

    public X509CertificateChain(X500Principal principal, PrivateKey privateKey, String csrString) {
        this.principal = principal;
        this.csrString = csrString;
        this.key = privateKey;
        this.hashKey = X509CertificateChain.genHashKey(principal);
        this.chain = null;
        this.endEntity = null;
    }

    public X509CertificateChain(Collection<X509Certificate> certs) {
        if (certs == null || certs.isEmpty()) {
            throw new IllegalArgumentException("cannot create X509CertificateChain with no certficates");
        }
        this.chain = certs.toArray(new X509Certificate[certs.size()]);
        this.genExpiryDate();
        this.initPrincipal();
        this.hashKey = X509CertificateChain.genHashKey(this.principal);
    }

    public X509CertificateChain(X509Certificate[] chain, PrivateKey key) {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("cannot create X509CertificateChain with no certficates");
        }
        this.chain = chain;
        this.genExpiryDate();
        this.key = key;
        this.initPrincipal();
        this.hashKey = X509CertificateChain.genHashKey(this.principal);
    }

    private void initPrincipal() {
        X509Certificate[] x509CertificateArray = this.chain;
        int n = x509CertificateArray.length;
        for (int i = 0; i < n; ++i) {
            X509Certificate c;
            this.endEntity = c = x509CertificateArray[i];
            X500Principal sp = c.getSubjectX500Principal();
            String sdn = sp.getName("RFC1779");
            X500Principal ip = c.getIssuerX500Principal();
            String idn = ip.getName("RFC1779");
            log.debug((Object)("found: subject=" + sdn + ", issuer=" + idn));
            if (sdn.endsWith(idn)) {
                this.principal = ip;
                this.isProxy = true;
                continue;
            }
            this.principal = sp;
        }
        String canonizedDn = AuthenticationUtil.canonizeDistinguishedName(this.principal.getName());
        if (canonizedDn.lastIndexOf("cn=") > -1) {
            canonizedDn = canonizedDn.substring(canonizedDn.lastIndexOf("cn="));
        }
        this.principal = new X500Principal(canonizedDn);
        log.debug((Object)("principal: " + this.principal.getName("RFC1779")));
    }

    public static X509CertificateChain findPrivateKeyChain(Set<Object> publicCredentials) {
        for (Object credential : publicCredentials) {
            X509CertificateChain chain;
            if (!(credential instanceof X509CertificateChain) || (chain = (X509CertificateChain)credential).getPrivateKey() == null) continue;
            return chain;
        }
        return null;
    }

    public String certificateString() {
        if (this.chain == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (X509Certificate cert : this.chain) {
            try {
                sb.append(CERT_BEGIN);
                sb.append(NEW_LINE);
                byte[] bytes = cert.getEncoded();
                sb.append(Base64.encodeLines64(bytes));
                sb.append(CERT_END);
                sb.append(NEW_LINE);
            }
            catch (CertificateEncodingException e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot encode X509Certificate to byte[].", e);
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String genHashKey(X500Principal dn) {
        String dn1 = AuthenticationUtil.canonizeDistinguishedName(dn.getName());
        return Integer.toString(dn1.hashCode());
    }

    private void genExpiryDate() {
        Date expiryDate = null;
        for (X509Certificate cert : this.chain) {
            Date notAfter = cert.getNotAfter();
            if (notAfter == null || expiryDate != null && !notAfter.before(expiryDate)) continue;
            expiryDate = notAfter;
        }
        this.expiryDate = expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setCsrString(String csrString) {
        this.csrString = csrString;
    }

    public String getCsrString() {
        return this.csrString;
    }

    public X500Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(X500Principal principal) {
        this.principal = principal;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public void setKey(PrivateKey key) {
        this.key = key;
    }

    public void setChain(X509Certificate[] chain) {
        this.chain = chain;
        this.genExpiryDate();
    }

    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public X500Principal getX500Principal() {
        return this.principal;
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public X509Certificate getEndEntity() {
        return this.endEntity;
    }
}

