/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.InvalidDelegationTokenException;
import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.RsaSignatureGenerator;
import ca.nrc.cadc.util.RsaSignatureVerifier;
import ca.nrc.cadc.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DelegationToken
implements Serializable {
    private static final Logger log = Logger.getLogger(DelegationToken.class);
    private static final long serialVersionUID = 20141025143750L;
    private HttpPrincipal user;
    private Date expiryTime;
    private URI scope;
    public static final String FIELD_DELIM = "&";
    public static final String VALUE_DELIM = "=";

    public DelegationToken(HttpPrincipal user, URI scope, Date expiryTime) {
        if (user == null) {
            throw new IllegalArgumentException("User identity required");
        }
        this.user = user;
        if (expiryTime == null) {
            throw new IllegalArgumentException("No expiry time");
        }
        this.expiryTime = expiryTime;
        this.scope = scope;
    }

    public static String format(DelegationToken token) throws InvalidKeyException, IOException {
        StringBuilder sb = DelegationToken.getContent(token);
        String toSign = sb.toString();
        sb.append(FIELD_DELIM);
        sb.append("signature");
        sb.append(VALUE_DELIM);
        RsaSignatureGenerator su = new RsaSignatureGenerator();
        byte[] sig = su.sign(new ByteArrayInputStream(toSign.getBytes()));
        sb.append(new String(Base64.encode(sig)));
        return sb.toString();
    }

    private static StringBuilder getContent(DelegationToken token) {
        StringBuilder sb = new StringBuilder();
        sb.append("userid");
        sb.append(VALUE_DELIM);
        sb.append(token.getUser().getName());
        if (StringUtil.hasText(token.getUser().getProxyUser())) {
            sb.append(FIELD_DELIM);
            sb.append("proxyuser");
            sb.append(VALUE_DELIM);
            sb.append(token.getUser().getProxyUser());
        }
        sb.append(FIELD_DELIM);
        sb.append("expirytime");
        sb.append(VALUE_DELIM);
        sb.append(token.getExpiryTime().getTime());
        if (token.getScope() != null) {
            sb.append(FIELD_DELIM);
            sb.append("scope");
            sb.append(VALUE_DELIM);
            sb.append(token.getScope());
        }
        return sb;
    }

    public static DelegationToken parse(String text, String requestURI) throws InvalidDelegationTokenException {
        return DelegationToken.parse(text, requestURI, null);
    }

    public static DelegationToken parse(String text, String requestURI, ScopeValidator sv) throws InvalidDelegationTokenException {
        String[] fields = text.split(FIELD_DELIM);
        String userid = null;
        String proxyUser = null;
        Date expirytime = null;
        URI scope = null;
        String signature = null;
        try {
            for (String field : fields) {
                String key = field.substring(0, field.indexOf(VALUE_DELIM));
                String value = field.substring(field.indexOf(VALUE_DELIM) + 1);
                if (key.equalsIgnoreCase("userid")) {
                    userid = value;
                }
                if (key.equalsIgnoreCase("proxyuser")) {
                    proxyUser = value;
                }
                if (key.equalsIgnoreCase("expirytime")) {
                    expirytime = new Date(Long.valueOf(value));
                }
                if (key.equalsIgnoreCase("scope")) {
                    scope = new URI(value);
                }
                if (!key.equalsIgnoreCase("signature")) continue;
                signature = value;
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidDelegationTokenException("invalid numeric field", ex);
        }
        catch (URISyntaxException ex) {
            throw new InvalidDelegationTokenException("invalid scope URI", ex);
        }
        if (signature == null) {
            throw new InvalidDelegationTokenException("Missing signature");
        }
        if (expirytime == null) {
            throw new InvalidDelegationTokenException("missing expirytime");
        }
        Date now = new Date();
        if (now.getTime() > expirytime.getTime()) {
            throw new InvalidDelegationTokenException("expired");
        }
        if (scope != null) {
            if (sv == null) {
                sv = DelegationToken.getScopeValidator();
            }
            sv.verifyScope(scope, requestURI);
        }
        DelegationToken result = new DelegationToken(new HttpPrincipal(userid, proxyUser), scope, expirytime);
        try {
            RsaSignatureVerifier su = new RsaSignatureVerifier();
            String str = DelegationToken.getContent(result).toString();
            boolean valid = su.verify(new ByteArrayInputStream(str.getBytes()), Base64.decode(signature));
            if (valid) {
                return result;
            }
            log.debug((Object)("invalid token: " + str));
        }
        catch (Exception ex) {
            log.debug((Object)"failed to verify DelegationToken signature", (Throwable)ex);
        }
        throw new InvalidDelegationTokenException("Cannot verify signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScopeValidator getScopeValidator() {
        try {
            String fname = DelegationToken.class.getSimpleName() + ".properties";
            String pname = DelegationToken.class.getName() + ".scopeValidator";
            Properties props = new Properties();
            props.load(DelegationToken.class.getClassLoader().getResource(fname).openStream());
            String cname = props.getProperty(pname);
            log.debug((Object)(fname + ": " + pname + " = " + cname));
            Class<?> c = Class.forName(cname);
            ScopeValidator ret = (ScopeValidator)c.newInstance();
            log.debug((Object)("created: " + ret.getClass().getName()));
            ScopeValidator scopeValidator = ret;
            return scopeValidator;
        }
        catch (Exception ignore) {
            log.debug((Object)"failed to load custom ScopeValidator", (Throwable)ignore);
        }
        return new ScopeValidator();
    }

    public HttpPrincipal getUser() {
        return this.user;
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public URI getScope() {
        return this.scope;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DelegationToken(user=");
        if (StringUtil.hasText(this.getUser().getProxyUser())) {
            sb.append(",proxyUser=");
            sb.append(this.getUser().getProxyUser());
        }
        sb.append(this.getUser());
        sb.append(",scope=");
        sb.append(this.getScope());
        sb.append(",startTime=");
        sb.append(this.getExpiryTime());
        sb.append(")");
        return sb.toString();
    }

    public static class ScopeValidator {
        public void verifyScope(URI scope, String requestURI) throws InvalidDelegationTokenException {
            throw new InvalidDelegationTokenException("default: invalid scope");
        }
    }
}

