/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TransactionAwarePersistenceManagerFactoryProxy
implements FactoryBean {
    private PersistenceManagerFactory target;
    private boolean allowCreate = true;
    private PersistenceManagerFactory proxy;

    public void setTargetPersistenceManagerFactory(PersistenceManagerFactory target) {
        Assert.notNull(target, "Target PersistenceManagerFactory must not be null");
        this.target = target;
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(target.getClass(), this.getClass().getClassLoader());
        this.proxy = (PersistenceManagerFactory)Proxy.newProxyInstance(target.getClass().getClassLoader(), ifcs, (InvocationHandler)new TransactionAwareFactoryInvocationHandler());
    }

    public PersistenceManagerFactory getTargetPersistenceManagerFactory() {
        return this.target;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    protected boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        return PersistenceManagerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private class TransactionAwareFactoryInvocationHandler
    implements InvocationHandler {
        private TransactionAwareFactoryInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("getPersistenceManager")) {
                PersistenceManagerFactory target = TransactionAwarePersistenceManagerFactoryProxy.this.getTargetPersistenceManagerFactory();
                PersistenceManager pm = PersistenceManagerFactoryUtils.doGetPersistenceManager(target, TransactionAwarePersistenceManagerFactoryProxy.this.isAllowCreate());
                Class[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), this.getClass().getClassLoader());
                return (PersistenceManager)Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new TransactionAwareInvocationHandler(pm, target));
            }
            try {
                return method.invoke((Object)TransactionAwarePersistenceManagerFactoryProxy.this.getTargetPersistenceManagerFactory(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final PersistenceManager target;
        private final PersistenceManagerFactory persistenceManagerFactory;

        public TransactionAwareInvocationHandler(PersistenceManager target, PersistenceManagerFactory pmf) {
            this.target = target;
            this.persistenceManagerFactory = pmf;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                if (this.persistenceManagerFactory != null) {
                    PersistenceManagerFactoryUtils.doReleasePersistenceManager(this.target, this.persistenceManagerFactory);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

