/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonInputter {
    private final Map<String, String> listElementMap = new TreeMap<String, String>();

    public Map<String, String> getListElementMap() {
        return this.listElementMap;
    }

    public Document input(String json) throws JSONException {
        JSONObject rootJson = new JSONObject(json);
        List<String> keys = Arrays.asList(JSONObject.getNames(rootJson));
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        Namespace namespace = this.getNamespace(namespaces, rootJson, keys);
        String rootKey = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (String string : keys) {
            if (string.startsWith("@xmlns")) continue;
            if (string.startsWith("@")) {
                String value = rootJson.isNull(string) ? "" : this.getStringValue(rootJson.get(string));
                attributes.add(new Attribute(string.substring(1), value));
                continue;
            }
            if (rootKey != null) {
                throw new IllegalStateException("Found multiple root entries");
            }
            rootKey = string;
        }
        Element rootElement = new Element(rootKey, namespace);
        for (Attribute attribute : attributes) {
            rootElement.setAttribute(attribute);
        }
        Object object = rootJson.get(rootKey);
        this.processObject(rootKey, object, rootElement, namespace, namespaces);
        Document document = new Document();
        document.setRootElement(rootElement);
        return document;
    }

    private void processObject(String key, Object value, Element element, Namespace namespace, List<Namespace> namespaces) throws JSONException {
        if (value == null) {
            return;
        }
        if (this.listElementMap.containsKey(key)) {
            Object childObject = ((JSONObject)value).get("$");
            if (childObject instanceof JSONArray) {
                this.processJSONArray(key, (JSONArray)childObject, element, namespace, namespaces);
            } else if (childObject instanceof JSONObject) {
                this.processJSONObject((JSONObject)childObject, element, namespaces);
            }
        } else if (value instanceof JSONObject) {
            this.processJSONObject((JSONObject)value, element, namespaces);
        } else {
            element.setText(this.getStringValue(value));
        }
    }

    private void processJSONObject(JSONObject jsonObject, Element element, List<Namespace> namespaces) throws JSONException {
        List<String> keys = Arrays.asList(JSONObject.getNames(jsonObject));
        Namespace namespace = this.getNamespace(namespaces, jsonObject, keys);
        if (namespace == null) {
            namespace = element.getNamespace();
        }
        for (String key : keys) {
            Object value;
            if (jsonObject.isNull(key)) continue;
            if (key.startsWith("@")) {
                value = jsonObject.get(key);
                element.setAttribute(new Attribute(key.substring(1), this.getStringValue(value)));
                continue;
            }
            value = jsonObject.get(key);
            if (key.equals("$")) {
                element.setText(this.getStringValue(value));
                continue;
            }
            Element child = new Element(key, namespace);
            if (this.listElementMap.containsKey(key)) {
                String childKey = this.listElementMap.get(key);
                Object childObject = ((JSONObject)value).get("$");
                Element grandChild = new Element(childKey, namespace);
                if (childObject instanceof JSONArray) {
                    this.processJSONArray(key, (JSONArray)childObject, child, namespace, namespaces);
                } else if (childObject instanceof JSONObject) {
                    this.processJSONObject((JSONObject)childObject, grandChild, namespaces);
                    child.addContent(grandChild);
                }
            } else if (value instanceof JSONObject) {
                this.processJSONObject((JSONObject)value, child, namespaces);
            }
            element.addContent(child);
        }
    }

    private void processJSONArray(String key, JSONArray jsonArray, Element arrayElement, Namespace namespace, List<Namespace> namespaces) throws JSONException {
        String childTypeName = this.getListElementMap().get(key);
        for (int i = 0; i < jsonArray.length(); ++i) {
            Element child;
            if (jsonArray.isNull(i)) continue;
            if (childTypeName == null) {
                child = arrayElement;
            } else {
                child = new Element(childTypeName, namespace);
                arrayElement.addContent(child);
            }
            Object value = jsonArray.get(i);
            this.processObject(childTypeName, value, child, namespace, namespaces);
        }
    }

    private Namespace getNamespace(List<Namespace> namespaces, JSONObject jsonObject, List<String> keys) throws JSONException {
        for (String key : keys) {
            if (!key.equals("@xmlns")) continue;
            if (jsonObject.isNull(key)) break;
            String uri = jsonObject.getString(key);
            Namespace namespace = Namespace.getNamespace(uri);
            if (!namespaces.contains(namespace)) {
                namespaces.add(namespace);
            }
            return namespace;
        }
        return null;
    }

    private String getStringValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer || value instanceof Double || value instanceof Long) {
            return ((Number)value).toString();
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        String error = "Unknown value " + value.getClass().getSimpleName();
        throw new IllegalArgumentException(error);
    }
}

