/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.auth;

import ca.nrc.cadc.ac.Role;
import ca.nrc.cadc.ac.UserNotFoundException;
import ca.nrc.cadc.ac.client.GMSClient;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.Authorizer;
import ca.nrc.cadc.auth.DelegationToken;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.cred.client.CredClient;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.profiler.Profiler;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeLockedException;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.NodeID;
import ca.nrc.cadc.vos.server.NodePersistence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class VOSpaceAuthorizer
implements Authorizer {
    protected static final Logger LOG = Logger.getLogger(VOSpaceAuthorizer.class);
    private static final String CRED_SERVICE_ID = "ivo://cadc.nrc.ca/cred";
    private static final String CANFAR_GMS_SERVICE_ID = "ivo://cadc.nrc.ca/canfargms";
    public static final String MODE_KEY = VOSpaceAuthorizer.class.getName() + ".state";
    public static final String OFFLINE = "Offline";
    public static final String OFFLINE_MSG = "System is offline for maintainence";
    public static final String READ_ONLY = "ReadOnly";
    public static final String READ_ONLY_MSG = "System is in read-only mode for maintainence";
    public static final String READ_WRITE = "ReadWrite";
    private boolean readable = true;
    private boolean writable = true;
    private boolean allowPartialPaths = false;
    private boolean disregardLocks = false;
    private NodePersistence nodePersistence;
    private GMSClient canfarGMS;
    private final Profiler profiler = new Profiler(VOSpaceAuthorizer.class);

    public VOSpaceAuthorizer() {
        this(false);
    }

    public VOSpaceAuthorizer(boolean allowPartialPaths) {
        this.initState();
        this.allowPartialPaths = allowPartialPaths;
        try {
            this.canfarGMS = new GMSClient(URI.create(CANFAR_GMS_SERVICE_ID));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("BUG: Error creating GMS Client", e);
        }
    }

    private void initState() {
        String key = MODE_KEY;
        String val = System.getProperty(key);
        if (OFFLINE.equals(val)) {
            this.readable = false;
            this.writable = false;
        } else if (READ_ONLY.equals(val)) {
            this.writable = false;
        }
    }

    public Object getReadPermission(URI uri) throws AccessControlException, FileNotFoundException, TransientException {
        this.initState();
        if (!this.readable) {
            if (!this.writable) {
                throw new IllegalStateException(OFFLINE_MSG);
            }
            throw new IllegalStateException(READ_ONLY_MSG);
        }
        try {
            VOSURI vos = new VOSURI(uri);
            Node node = this.nodePersistence.get(vos, this.allowPartialPaths);
            this.profiler.checkpoint("nodePersistence.get");
            return this.getReadPermission(node);
        }
        catch (NodeNotFoundException ex) {
            throw new FileNotFoundException("not found: " + uri);
        }
    }

    public Object getReadPermission(Node node) throws AccessControlException {
        this.initState();
        if (!this.readable) {
            if (!this.writable) {
                throw new IllegalStateException(OFFLINE_MSG);
            }
            throw new IllegalStateException(READ_ONLY_MSG);
        }
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        this.checkDelegation(node, subject);
        LinkedList<Node> nodes = Node.getNodeList(node);
        Node rootNode = nodes.getLast();
        if (this.isOwner(rootNode, subject)) {
            LOG.debug("Read permission granted to root user.");
            return node;
        }
        Iterator<Node> iter = nodes.descendingIterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            if (this.hasSingleNodeReadPermission(n, subject)) continue;
            throw new AccessControlException("Read permission denied on " + n.getUri().toString());
        }
        return node;
    }

    public Object getWritePermission(URI uri) throws AccessControlException, FileNotFoundException, TransientException, NodeLockedException {
        this.initState();
        if (!this.writable) {
            if (this.readable) {
                throw new IllegalStateException(READ_ONLY_MSG);
            }
            throw new IllegalStateException(OFFLINE_MSG);
        }
        try {
            VOSURI vos = new VOSURI(uri);
            Node node = this.nodePersistence.get(vos, this.allowPartialPaths);
            this.profiler.checkpoint("nodePersistence.get");
            return this.getWritePermission(node);
        }
        catch (NodeNotFoundException ex) {
            throw new FileNotFoundException("not found: " + uri);
        }
    }

    public Object getWritePermission(Node node) throws AccessControlException, NodeLockedException {
        this.initState();
        if (!this.writable) {
            if (this.readable) {
                throw new IllegalStateException(READ_ONLY_MSG);
            }
            throw new IllegalStateException(OFFLINE_MSG);
        }
        AccessControlContext acContext = AccessController.getContext();
        Subject subject = Subject.getSubject(acContext);
        this.checkDelegation(node, subject);
        if (!this.disregardLocks && node.isLocked()) {
            throw new NodeLockedException(node.getUri().toString());
        }
        LinkedList<Node> nodes = Node.getNodeList(node);
        Node rootNode = nodes.getLast();
        if (this.isOwner(rootNode, subject)) {
            LOG.debug("Write permission granted to root user.");
            return node;
        }
        Iterator<Node> iter = nodes.descendingIterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            if (n != node) continue;
            if (!this.hasSingleNodeWritePermission(n, subject)) {
                throw new AccessControlException("Write permission denied on " + n.getUri().toString());
            }
            if (this.hasSingleNodeReadPermission(n, subject)) continue;
            throw new AccessControlException("Read permission denied on " + n.getUri().toString());
        }
        return node;
    }

    public void getDeletePermission(Node node) throws AccessControlException, NodeLockedException, TransientException {
        this.initState();
        if (!this.writable) {
            if (this.readable) {
                throw new IllegalStateException(READ_ONLY_MSG);
            }
            throw new IllegalStateException(OFFLINE_MSG);
        }
        ContainerNode parent = node.getParent();
        this.getWritePermission(parent);
        if (!this.disregardLocks && node.isLocked()) {
            throw new NodeLockedException(node.getUri().toString());
        }
        if (node instanceof ContainerNode) {
            ContainerNode container = (ContainerNode)node;
            this.getWritePermission(container);
            Integer batchSize = new Integer(1000);
            VOSURI startURI = null;
            this.nodePersistence.getChildren(container, startURI, batchSize);
            while (!container.getNodes().isEmpty()) {
                Node n;
                for (Node child : container.getNodes()) {
                    this.getDeletePermission(child);
                    startURI = child.getUri();
                }
                container.getNodes().clear();
                this.nodePersistence.getChildren(container, startURI, batchSize);
                if (container.getNodes().isEmpty() || !(n = container.getNodes().get(0)).getUri().equals(startURI)) continue;
                container.getNodes().remove(0);
            }
        }
    }

    private boolean hasMembership(NodeProperty groupProp, Subject subject) {
        if (subject.getPrincipals().isEmpty()) {
            return false;
        }
        List<String> groupURIs = groupProp.extractPropertyValueList();
        if (groupURIs == null || groupURIs.isEmpty()) {
            return false;
        }
        Exception firstFail = null;
        RuntimeException wrapException = null;
        this.checkCredentials(subject);
        for (String groupURI : groupURIs) {
            try {
                LOG.debug("Checking GMS on groupURI: " + groupURI);
                URI guri = new URI(groupURI);
                if (guri.getFragment() != null) {
                    boolean isMember = this.canfarGMS.isMember(guri.getFragment(), Role.MEMBER);
                    this.profiler.checkpoint("canfarGMS.ismember");
                    if (!isMember) continue;
                    return true;
                }
                LOG.warn("skipping invalid group URI (missing fragment): " + groupURI);
            }
            catch (URISyntaxException e) {
                LOG.warn("skipping invalid group URI: " + groupURI);
            }
            catch (UserNotFoundException ex) {
                LOG.debug("failed to call canfar gms service", ex);
                if (firstFail != null) continue;
                firstFail = ex;
                wrapException = new AccessControlException("failed to check membership with group service: " + ex);
            }
            catch (IOException ex) {
                LOG.debug("failed to call canfar gms service", ex);
                if (firstFail != null) continue;
                firstFail = ex;
                wrapException = new RuntimeException("failed to check membership with group service", ex);
            }
        }
        if (wrapException != null) {
            throw wrapException;
        }
        return false;
    }

    private Subject createOpsSubject() {
        File pemFile = new File(System.getProperty("user.home") + "/.pub/proxy.pem");
        return SSLUtil.createSubject(pemFile);
    }

    private void checkCredentials(final Subject subject) {
        block6: {
            try {
                X509CertificateChain privateKeyChain = X509CertificateChain.findPrivateKeyChain(subject.getPublicCredentials());
                if (privateKeyChain != null) break block6;
                final CredClient cred = new CredClient(URI.create(CRED_SERVICE_ID));
                Subject opsSubject = this.createOpsSubject();
                try {
                    privateKeyChain = Subject.doAs(opsSubject, new PrivilegedExceptionAction<X509CertificateChain>(){

                        @Override
                        public X509CertificateChain run() throws Exception {
                            return cred.getProxyCertificate(subject, 0.2);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw new RuntimeException("CredClient.getProxyCertficate failed", ex.getException());
                }
                this.profiler.checkpoint("CredClient.getProxyCertificate");
                if (privateKeyChain == null) {
                    throw new AccessControlException("credential service did not return a delegated certificate");
                }
                privateKeyChain.getChain()[0].checkValidity();
                subject.getPublicCredentials().add(privateKeyChain);
            }
            catch (AccessControlException e) {
                throw new RuntimeException("CredClient.getProxyCertficate failed", e);
            }
            catch (CertificateException e) {
                throw new AccessControlException("credential service returned an invalid certificate");
            }
        }
    }

    private boolean isOwner(Node node, Subject subject) {
        NodeID nodeID = (NodeID)node.appData;
        if (nodeID == null) {
            throw new IllegalStateException("BUG: no owner found for node: " + node);
        }
        if (nodeID.getID() == null) {
            return false;
        }
        Subject owner = nodeID.getOwner();
        if (owner == null) {
            throw new IllegalStateException("BUG: no owner found for node: " + node);
        }
        Set<Principal> ownerPrincipals = owner.getPrincipals();
        Set<Principal> callerPrincipals = subject.getPrincipals();
        for (Principal oPrin : ownerPrincipals) {
            for (Principal cPrin : callerPrincipals) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Checking owner of node \"%s\" (owner=\"%s\") where user=\"%s\"", node.getName(), oPrin, cPrin));
                }
                if (!AuthenticationUtil.equals(oPrin, cPrin)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSingleNodeReadPermission(Node node, Subject subject) {
        LOG.debug("checkSingleNodeReadPermission: " + node.getUri());
        if (node.isPublic()) {
            return true;
        }
        if (subject != null) {
            if (this.isOwner(node, subject)) {
                LOG.debug("Node owner granted read permission.");
                return true;
            }
            NodeProperty groupRead = node.findProperty("ivo://ivoa.net/vospace/core#groupread");
            if (LOG.isDebugEnabled()) {
                String groupReadString = groupRead == null ? "null" : groupRead.getPropertyValue();
                LOG.debug(String.format("Checking group read permission on node \"%s\" (groupRead=\"%s\")", node.getName(), groupReadString));
            }
            if (groupRead != null && groupRead.getPropertyValue() != null && this.hasMembership(groupRead, subject)) {
                return true;
            }
            NodeProperty groupWrite = node.findProperty("ivo://ivoa.net/vospace/core#groupwrite");
            if (LOG.isDebugEnabled()) {
                String groupReadString = groupWrite == null ? "null" : groupWrite.getPropertyValue();
                LOG.debug(String.format("Checking group write permission on node \"%s\" (groupWrite=\"%s\")", node.getName(), groupReadString));
            }
            if (groupWrite != null && groupWrite.getPropertyValue() != null && this.hasMembership(groupWrite, subject)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasSingleNodeWritePermission(Node node, Subject subject) {
        if (node.getUri().isRoot()) {
            return false;
        }
        if (subject != null) {
            if (this.isOwner(node, subject)) {
                LOG.debug("Node owner granted write permission.");
                return true;
            }
            NodeProperty groupWrite = node.findProperty("ivo://ivoa.net/vospace/core#groupwrite");
            if (LOG.isDebugEnabled()) {
                String groupReadString = groupWrite == null ? "null" : groupWrite.getPropertyValue();
                LOG.debug(String.format("Checking group write permission on node \"%s\" (groupWrite=\"%s\")", node.getName(), groupReadString));
            }
            if (groupWrite != null && groupWrite.getPropertyValue() != null && this.hasMembership(groupWrite, subject)) {
                return true;
            }
        }
        return false;
    }

    public void setDisregardLocks(boolean disregardLocks) {
        this.disregardLocks = disregardLocks;
    }

    public NodePersistence getNodePersistence() {
        return this.nodePersistence;
    }

    public void setNodePersistence(NodePersistence nodePersistence) {
        this.nodePersistence = nodePersistence;
    }

    private void checkDelegation(Node node, Subject subject) throws AccessControlException {
        Set<DelegationToken> tokens = subject.getPublicCredentials(DelegationToken.class);
        Iterator<DelegationToken> iterator = tokens.iterator();
        if (iterator.hasNext()) {
            DelegationToken token = iterator.next();
            VOSURI scope = new VOSURI(token.getScope());
            for (VOSURI tmp = node.getUri(); tmp != null; tmp = tmp.getParentURI()) {
                if (!scope.equals(tmp)) continue;
                return;
            }
            String msg = "Scoped search (" + scope + ") on node (" + node.getUri() + ")- accessed denied";
            LOG.debug(msg);
            throw new AccessControlException(msg);
        }
    }
}

