/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.LinkNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.NodeID;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowMapper;

public class NodeMapper
implements RowMapper {
    private static Logger log = Logger.getLogger(NodeMapper.class);
    private DateFormat dateFormat;
    private Calendar cal;
    private String authority;
    private String basePath;

    public NodeMapper(String authority, String basePath) {
        this.authority = authority;
        this.basePath = basePath;
        this.dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
        this.cal = Calendar.getInstance(DateUtil.UTC);
    }

    public Object mapRow(ResultSet rs, int row) throws SQLException {
        Node node;
        VOSURI vos;
        long nodeID = rs.getLong("nodeID");
        String name = rs.getString("name");
        String type = rs.getString("type");
        String busyString = rs.getString("busyState");
        String groupRead = rs.getString("groupRead");
        String groupWrite = rs.getString("groupWrite");
        boolean isPublic = rs.getBoolean("isPublic");
        boolean isLocked = rs.getBoolean("isLocked");
        Object ownerObject = rs.getObject("ownerID");
        String contentType = rs.getString("contentType");
        String contentEncoding = rs.getString("contentEncoding");
        String link = null;
        Long contentLength = null;
        Object o = rs.getObject("contentLength");
        if (o != null) {
            Number n = (Number)o;
            contentLength = new Long(n.longValue());
        }
        log.debug("readNode: contentLength = " + contentLength);
        Object contentMD5 = rs.getObject("contentMD5");
        Timestamp lastModified = rs.getTimestamp("lastModified", this.cal);
        String path = this.basePath + "/" + name;
        try {
            vos = new VOSURI(new URI("vos", this.authority, path, null, null));
        }
        catch (URISyntaxException bug) {
            throw new RuntimeException("BUG - failed to create vos URI", bug);
        }
        if ("C".equals(type)) {
            node = new ContainerNode(vos);
        } else if ("D".equals(type)) {
            node = new DataNode(vos);
            ((DataNode)node).setBusy(VOS.NodeBusyState.getStateFromValue(busyString));
        } else if ("L".equals(type)) {
            link = rs.getString("link");
            try {
                node = new LinkNode(vos, new URI(link));
            }
            catch (URISyntaxException bug) {
                throw new RuntimeException("BUG - failed to create link URI", bug);
            }
        } else {
            throw new IllegalStateException("Unknown node database type: " + type);
        }
        NodeID nid = new NodeID();
        nid.id = nodeID;
        nid.ownerObject = ownerObject;
        node.appData = nid;
        if (contentType != null && contentType.trim().length() > 0) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#type", contentType));
        }
        if (contentEncoding != null && contentEncoding.trim().length() > 0) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#encoding", contentEncoding));
        }
        if (contentLength != null) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#length", contentLength.toString()));
        } else {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#length", "0"));
        }
        if (contentMD5 != null && contentMD5 instanceof byte[]) {
            byte[] md5 = (byte[])contentMD5;
            if (md5.length < 16) {
                byte[] tmp = md5;
                md5 = new byte[16];
                System.arraycopy(tmp, 0, md5, 0, tmp.length);
            }
            String contentMD5String = HexUtil.toHex(md5);
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#MD5", contentMD5String));
        }
        if (lastModified != null) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#date", this.dateFormat.format(lastModified)));
        }
        if (groupRead != null && groupRead.trim().length() > 0) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#groupread", groupRead));
        }
        if (groupWrite != null && groupWrite.trim().length() > 0) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#groupwrite", groupWrite));
        }
        node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#ispublic", isPublic ? "true" : "false"));
        if (isLocked) {
            node.getProperties().add(new NodeProperty("ivo://cadc.nrc.ca/vospace/core#islocked", isLocked ? "true" : "false"));
        }
        for (String propertyURI : VOS.READ_ONLY_PROPERTIES) {
            int propertyIndex = node.getProperties().indexOf(new NodeProperty(propertyURI, ""));
            if (propertyIndex == -1) continue;
            node.getProperties().get(propertyIndex).setReadOnly(true);
        }
        log.debug("read: " + node.getUri() + "," + node.appData);
        return node;
    }
}

