/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.X500IdentityManager;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.FileMetadata;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeNotSupportedException;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.NodeDAO;
import ca.nrc.cadc.vos.server.NodeID;
import ca.nrc.cadc.vos.server.NodePersistence;
import ca.nrc.cadc.vos.server.NodeSizePropagation;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseNodePersistence
implements NodePersistence {
    private static Logger log = Logger.getLogger(DatabaseNodePersistence.class);
    private static final String ROOT_NAME = "";
    private static List<String> permissionPropertyURIs = Arrays.asList("ivo://ivoa.net/vospace/core#ispublic", "ivo://ivoa.net/vospace/core#groupread", "ivo://ivoa.net/vospace/core#groupwrite");
    protected NodeDAO.NodeSchema nodeSchema;
    protected String deletedNodePath;
    protected Integer maxChildLimit = new Integer(1000);

    protected DatabaseNodePersistence(NodeDAO.NodeSchema nodeSchema, String deletedNodePath) {
        this.nodeSchema = nodeSchema;
        this.deletedNodePath = deletedNodePath;
    }

    protected abstract DataSource getDataSource();

    protected IdentityManager getIdentityManager() {
        return new X500IdentityManager();
    }

    protected NodeDAO getDAO(String authority) {
        return new NodeDAO(this.getDataSource(), this.nodeSchema, authority, this.getIdentityManager(), this.deletedNodePath);
    }

    @Override
    public Node get(VOSURI vos) throws NodeNotFoundException, TransientException {
        return this.get(vos, false);
    }

    @Override
    public Node get(VOSURI vos, boolean allowPartialPath) throws NodeNotFoundException, TransientException {
        log.debug("get: " + vos + " -- " + vos.getName());
        if (vos.isRoot()) {
            return this.createRoot(vos.getAuthority());
        }
        NodeDAO dao = this.getDAO(vos.getAuthority());
        Node ret = dao.getPath(vos.getPath(), allowPartialPath);
        if (ret == null) {
            throw new NodeNotFoundException("not found: " + vos.getURI().toASCIIString());
        }
        return ret;
    }

    private ContainerNode createRoot(String authority) {
        try {
            ContainerNode root = new ContainerNode(new VOSURI(new URI("vos", authority, ROOT_NAME, null, null)));
            root.appData = new NodeID();
            root.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#ispublic", "true"));
            log.debug("created root: " + root);
            return root;
        }
        catch (URISyntaxException bug) {
            throw new RuntimeException("BUG: failed to create VOSURI for root", bug);
        }
    }

    @Override
    public void getProperties(Node node) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        dao.getProperties(node);
    }

    @Override
    public void getChildren(ContainerNode node) throws TransientException {
        this.getChildren(node, null, null);
    }

    @Override
    public void getChildren(ContainerNode parent, VOSURI start, Integer limit) throws TransientException {
        NodeDAO dao = this.getDAO(parent.getUri().getAuthority());
        Integer actualLimit = limit;
        if (limit == null || limit > this.maxChildLimit) {
            actualLimit = this.maxChildLimit;
        }
        dao.getChildren(parent, start, actualLimit);
    }

    @Override
    public void getChild(ContainerNode node, String name) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        dao.getChild(node, name);
    }

    @Override
    public Node put(Node node) throws NodeNotSupportedException, TransientException {
        if (node.isStructured()) {
            throw new NodeNotSupportedException("StructuredDataNode is not supported.");
        }
        AccessControlContext acContext = AccessController.getContext();
        Subject caller = Subject.getSubject(acContext);
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        if (node.appData == null || ((NodeID)node.appData).getID() == null) {
            this.inheritParentPermissions(node);
        }
        return dao.put(node, caller);
    }

    @Override
    public Node updateProperties(Node node, List<NodeProperty> properties) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        return dao.updateProperties(node, properties);
    }

    @Override
    public void delete(Node node) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        dao.delete(node);
    }

    @Override
    public void move(Node src, ContainerNode dest) throws TransientException {
        log.debug("move: " + src.getUri() + " to " + dest.getUri() + " as " + src.getName());
        URI srcAuthority = src.getUri().getServiceURI();
        URI destAuthority = dest.getUri().getServiceURI();
        if (!srcAuthority.equals(destAuthority)) {
            throw new RuntimeException("Cannot move nodes between authorities.");
        }
        NodeDAO dao = this.getDAO(src.getUri().getAuthority());
        dao.move(src, dest);
    }

    @Override
    public void copy(Node src, ContainerNode destination) throws TransientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBusyState(DataNode node, VOS.NodeBusyState curState, VOS.NodeBusyState newState) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        dao.setBusyState(node, curState, newState);
    }

    @Override
    public void setFileMetadata(DataNode node, FileMetadata meta, boolean strict) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        dao.updateNodeMetadata(node, meta, strict);
    }

    protected long getContentLength(Node node) {
        String str = node.getPropertyValue("ivo://ivoa.net/vospace/core#length");
        if (str != null) {
            return Long.parseLong(str);
        }
        return 0L;
    }

    protected void inheritParentPermissions(Node node) {
        ContainerNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        for (String propertyURI : permissionPropertyURIs) {
            NodeProperty parentProperty = node.getParent().findProperty(propertyURI);
            NodeProperty childProperty = null;
            if (parentProperty == null) continue;
            childProperty = node.findProperty(propertyURI);
            boolean inherit = true;
            if (childProperty != null) {
                if (this.propertyExplicitlySet(childProperty)) {
                    log.debug("Keeping permission property: " + childProperty);
                    inherit = false;
                } else {
                    node.getProperties().remove(childProperty);
                }
            }
            if (!inherit) continue;
            log.debug("Inheriting permission property: " + parentProperty);
            node.getProperties().add(parentProperty);
        }
    }

    private boolean propertyExplicitlySet(NodeProperty property) {
        return StringUtil.hasText(property.getPropertyValue()) || property.isMarkedForDeletion();
    }

    public void chown(Node node, boolean recursive, int batchSize, boolean dryrun) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        AccessControlContext acContext = AccessController.getContext();
        Subject caller = Subject.getSubject(acContext);
        dao.chown(node, caller, recursive, batchSize, dryrun);
    }

    public void delete(Node node, int batchSize, boolean dryrun) throws TransientException {
        NodeDAO dao = this.getDAO(node.getUri().getAuthority());
        dao.delete(node, batchSize, dryrun);
    }

    public List<NodeSizePropagation> getOutstandingPropagations(int limit) throws TransientException {
        NodeDAO dao = this.getDAO(null);
        return dao.getOutstandingPropagations(limit);
    }

    public void applyPropagation(NodeSizePropagation propagation) throws TransientException {
        NodeDAO dao = this.getDAO(null);
        dao.applyPropagation(propagation);
    }
}

