/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.CertCmdArgUtil;
import ca.nrc.cadc.auth.RunnableAction;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.util.ArgumentMap;
import ca.nrc.cadc.util.Log4jInit;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.Direction;
import ca.nrc.cadc.vos.LinkNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeLockedException;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.Protocol;
import ca.nrc.cadc.vos.StructuredDataNode;
import ca.nrc.cadc.vos.Transfer;
import ca.nrc.cadc.vos.UnstructuredDataNode;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.client.ClientAbortThread;
import ca.nrc.cadc.vos.client.ClientRecursiveSetNode;
import ca.nrc.cadc.vos.client.ClientTransfer;
import ca.nrc.cadc.vos.client.FileSizeType;
import ca.nrc.cadc.vos.client.VOSClientUtil;
import ca.nrc.cadc.vos.client.VOSpaceClient;
import ca.nrc.cadc.vos.client.VOSpaceTransferListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
implements Runnable {
    public static final String ARG_HELP = "help";
    public static final String ARG_VERBOSE = "verbose";
    public static final String ARG_DEBUG = "debug";
    public static final String ARG_H = "h";
    public static final String ARG_V = "v";
    public static final String ARG_D = "d";
    public static final String ARG_XSV = "xsv";
    public static final String ARG_NO_RETRY = "noretry";
    public static final String ARG_VIEW = "view";
    public static final String ARG_CREATE = "create";
    public static final String ARG_DELETE = "delete";
    public static final String ARG_SET = "set";
    public static final String ARG_COPY = "copy";
    public static final String ARG_MOVE = "move";
    public static final String ARG_TARGET = "target";
    public static final String ARG_PUBLIC = "public";
    public static final String ARG_GROUP_READ = "group-read";
    public static final String ARG_GROUP_WRITE = "group-write";
    public static final String ARG_PROP = "prop";
    public static final String ARG_SRC = "src";
    public static final String ARG_LINK = "link";
    public static final String ARG_DEST = "dest";
    public static final String ARG_CONTENT_TYPE = "content-type";
    public static final String ARG_CONTENT_ENCODING = "content-encoding";
    public static final String ARG_CONTENT_MD5 = "content-md5";
    public static final String ARG_RECURSIVE = "recursive";
    public static final String ARG_LOCK = "lock";
    public static final String ARG_QUICK = "quick";
    public static final String VOS_PREFIX = "vos://";
    private static Logger log = Logger.getLogger(Main.class);
    private static final int INIT_STATUS = 1;
    private static final int NET_STATUS = 2;
    private static final int MAX_CHILD_SIZE = 1000;
    private NodeType nodeType;
    private Operation operation;
    private VOSURI target;
    private List<NodeProperty> properties;
    private String contentType;
    private String contentEncoding;
    private URI source;
    private URI destination;
    private Direction transferDirection = null;
    private String baseUrl = null;
    private VOSpaceClient client = null;
    private Subject subject;
    private boolean retryEnabled = false;
    private boolean quickTransfer = false;
    private boolean recursiveMode = false;
    private URI link;
    private static String ZERO_LENGTH = "";

    public static void main(String[] args) {
        ArgumentMap argMap = new ArgumentMap(args);
        Main command = new Main();
        if (argMap.isSet(ARG_HELP) || argMap.isSet(ARG_H)) {
            Main.usage();
            System.exit(0);
        }
        if (argMap.isSet(ARG_DEBUG) || argMap.isSet(ARG_D)) {
            Log4jInit.setLevel("ca.nrc.cadc.vos", Level.DEBUG);
            Log4jInit.setLevel("ca.nrc.cadc.net", Level.DEBUG);
        } else if (argMap.isSet(ARG_VERBOSE) || argMap.isSet(ARG_V)) {
            Log4jInit.setLevel("ca.nrc.cadc.vos.client", Level.INFO);
        } else {
            Log4jInit.setLevel("ca", Level.WARN);
        }
        try {
            command.validateCommand(argMap);
            command.validateCommandArguments(argMap);
        }
        catch (IllegalArgumentException ex) {
            Main.msg("illegal argument(s): " + ex.getMessage());
            Main.msg("");
            Main.usage();
            System.exit(1);
        }
        try {
            command.init(argMap);
            if (command.subject != null) {
                Subject.doAs(command.subject, new RunnableAction(command));
            } else {
                command.run();
            }
        }
        catch (IllegalArgumentException ex) {
            Main.msg("illegal arguments(s): " + ex.getMessage());
            Main.msg("");
            System.exit(1);
        }
        catch (Throwable t) {
            log.error("unexpected failure", t);
            System.exit(2);
        }
        System.exit(0);
    }

    private static void msg(String s) {
        System.out.println(s);
    }

    @Override
    public void run() {
        log.debug("run - START");
        if (this.operation.equals((Object)Operation.CREATE)) {
            this.doCreate();
        } else if (this.operation.equals((Object)Operation.DELETE)) {
            this.doDelete();
        } else if (this.operation.equals((Object)Operation.VIEW)) {
            this.doView();
        } else if (this.operation.equals((Object)Operation.COPY)) {
            this.doCopy();
        } else if (this.operation.equals((Object)Operation.MOVE)) {
            this.doMove();
        } else if (this.operation.equals((Object)Operation.SET)) {
            if (this.recursiveMode) {
                this.doRecursiveSet();
            } else {
                this.doSet();
            }
        }
        log.debug("run - DONE");
    }

    private void doSet() {
        log.debug("doSet");
        try {
            log.debug("target.getPath()" + this.target.getPath());
            Node n = this.client.getNode(this.target.getPath(), "limit=0");
            Node up = null;
            if (n instanceof ContainerNode) {
                up = new ContainerNode(this.target, this.properties);
            } else if (n instanceof DataNode) {
                up = new DataNode(this.target, this.properties);
            } else if (n instanceof LinkNode) {
                URI link = ((LinkNode)n).getTarget();
                up = new LinkNode(this.target, this.properties, link);
            } else {
                throw new UnsupportedOperationException("unexpected node type: " + n.getClass().getName());
            }
            this.client.setNode(up);
            log.info("updated properties: " + this.target);
        }
        catch (NodeNotFoundException ex) {
            Main.msg("not found: " + this.target);
            System.exit(2);
        }
        catch (Throwable t) {
            Main.msg("failed to set properties on node: " + this.target);
            if (t.getMessage() != null) {
                Main.msg("          reason: " + t.getMessage());
            } else {
                Main.msg("          reason: " + t);
            }
            if (t.getCause() != null) {
                Main.msg("          reason: " + t.getCause());
            }
            System.exit(2);
        }
    }

    private void doDelete() {
        log.debug("doDelete");
        try {
            log.debug("target.getPath()" + this.target.getPath());
            this.client.deleteNode(this.target.getPath());
            log.info("deleted: " + this.target);
        }
        catch (NodeLockedException nlex) {
            Main.msg("node locked: " + this.target);
            System.exit(2);
        }
        catch (Throwable t) {
            Main.msg("failed to delete: " + this.target);
            if (t.getMessage() != null) {
                Main.msg("          reason: " + t.getMessage());
            } else {
                Main.msg("          reason: " + t);
            }
            if (t.getCause() != null) {
                Main.msg("          reason: " + t.getCause());
            }
            System.exit(2);
        }
    }

    private void doCopy() {
        log.debug("doCopy");
        try {
            if (this.transferDirection.equals(Direction.pushToVoSpace)) {
                this.copyToVOSpace();
            } else if (this.transferDirection.equals(Direction.pullFromVoSpace)) {
                this.copyFromVOSpace();
            }
        }
        catch (NullPointerException ex) {
            log.error("BUG", ex);
            System.exit(2);
        }
        catch (Throwable t) {
            log.debug(t);
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            Main.msg("failed to copy: " + this.source + " -> " + this.destination);
            if (t.getCause() != null) {
                if (t.getCause().getMessage() != null) {
                    Main.msg("          reason: " + t.getCause().getMessage());
                } else {
                    Main.msg("          reason: " + t.getCause());
                }
            } else if (t.getMessage() != null) {
                Main.msg("          reason: " + t.getMessage());
            } else {
                Main.msg("          reason: " + t);
            }
            System.exit(2);
        }
    }

    private void doMove() {
        log.debug("doMove");
        try {
            if (Direction.pushToVoSpace.equals(this.transferDirection)) {
                this.moveToVOSpace();
            } else if (Direction.pullFromVoSpace.equals(this.transferDirection)) {
                this.moveFromVOSpace();
            } else {
                this.moveWithinVOSpace();
            }
        }
        catch (NullPointerException ex) {
            log.error("BUG", ex);
            System.exit(2);
        }
        catch (Throwable t) {
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (this.destination == null) {
                Main.msg("failed to move: " + this.source + " -> " + this.transferDirection.getValue());
            } else {
                Main.msg("failed to move: " + this.source + " -> " + this.destination);
            }
            if (t.getCause() != null) {
                if (t.getCause().getMessage() != null) {
                    Main.msg("          reason: " + t.getCause().getMessage());
                } else {
                    Main.msg("          reason: " + t.getCause());
                }
            } else if (t.getMessage() != null) {
                Main.msg("          reason: " + t.getMessage());
            } else {
                Main.msg("          reason: " + t);
            }
            System.exit(2);
        }
    }

    private void doCreate() {
        try {
            Node node;
            switch (this.nodeType) {
                case CONTAINER_NODE: {
                    node = new ContainerNode(this.target, this.properties);
                    break;
                }
                case LINK_NODE: {
                    node = new LinkNode(this.target, this.properties, this.link);
                    break;
                }
                case STRUCTURED_DATA_NODE: {
                    node = new StructuredDataNode(this.target, this.properties);
                    break;
                }
                case UNSTRUCTURED_DATA_NODE: {
                    node = new UnstructuredDataNode(this.target, this.properties);
                    break;
                }
                default: {
                    throw new RuntimeException("BUG. Unsupported node type " + (Object)((Object)this.nodeType));
                }
            }
            Node nodeRtn = this.client.createNode(node);
            log.info("created: " + nodeRtn.getUri());
        }
        catch (Throwable t) {
            Main.msg("failed to create: " + this.target);
            if (t.getMessage() != null) {
                Main.msg("          reason: " + t.getMessage());
            } else {
                Main.msg("          reason: " + t);
            }
            if (t.getCause() != null) {
                Main.msg("          reason: " + t.getCause());
            }
            System.exit(2);
        }
    }

    private void doView() {
        boolean explicitPaging = false;
        String queryString = this.target.getQuery();
        if (StringUtil.hasText(queryString)) {
            String[] queries;
            for (String query : queries = queryString.split("&")) {
                if (!query.startsWith("limit=") && !query.startsWith("uri=")) continue;
                explicitPaging = true;
            }
            if (!explicitPaging) {
                queryString = queryString + "&limit=1000";
            }
        } else {
            queryString = "limit=1000";
        }
        log.debug("explicit paging control: " + explicitPaging);
        log.debug("view query string: " + queryString);
        try {
            Node n = this.client.getNode(this.target.getPath(), queryString);
            Main.msg(this.getType(n) + ": " + n.getUri());
            Main.msg("creator: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#creator"));
            Main.msg("is locked: " + this.safePropertyRef(n, "ivo://cadc.nrc.ca/vospace/core#islocked"));
            Main.msg("last modified: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#date"));
            Main.msg("readable by anyone: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#ispublic"));
            Main.msg("readable by: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#groupread"));
            Main.msg("readable and writable by: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#groupwrite"));
            Main.msg("size: " + this.getContentLength(n, true));
            if (n instanceof ContainerNode) {
                ContainerNode cn;
                String quotaSize = this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#quota");
                if (StringUtil.hasText(quotaSize)) {
                    Main.msg("quota size: " + FileSizeType.getHumanReadableSize(Long.parseLong(quotaSize)) + " (" + quotaSize + " bytes)");
                }
                if ((cn = (ContainerNode)n).getNodes().size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.pad("child nodes: ", 32));
                    sb.append(this.pad("size", 12));
                    sb.append(this.pad(ARG_PUBLIC, 8));
                    sb.append(this.pad("last modified", 26));
                    sb.append("URI");
                    Main.msg(sb.toString());
                }
                log.debug("get container node returned : " + cn.getNodes().size() + " children.");
                this.printChildList(n, cn.getNodes());
                if (!explicitPaging) {
                    VOSURI uriQueryObj = null;
                    String uriQueryParam = null;
                    while (cn.getNodes().size() > 0) {
                        log.debug("Getting next set of children.");
                        uriQueryObj = cn.getNodes().get(cn.getNodes().size() - 1).getUri();
                        uriQueryParam = "uri=" + NetUtil.encode(uriQueryObj.toString());
                        cn = null;
                        n = StringUtil.hasText(queryString) ? this.client.getNode(this.target.getPath(), queryString + "&" + uriQueryParam) : this.client.getNode(this.target.getPath(), uriQueryParam);
                        if (!(n instanceof ContainerNode)) {
                            throw new IllegalStateException("inconsistent node state.");
                        }
                        cn = (ContainerNode)n;
                        log.debug("next set has : " + cn.getNodes().size() + " children.");
                        if (cn.getNodes().size() > 0 && cn.getNodes().get(0).getUri().equals(uriQueryObj)) {
                            cn.getNodes().remove(0);
                        }
                        this.printChildList(n, cn.getNodes());
                    }
                }
            } else if (n instanceof DataNode) {
                Main.msg("type: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#type"));
                Main.msg("encoding: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#encoding"));
                Main.msg("md5sum: " + this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#MD5"));
            } else if (n instanceof LinkNode) {
                Main.msg("link uri: " + ((LinkNode)n).getTarget());
            } else {
                log.debug("class of returned node: " + n.getClass().getName());
            }
        }
        catch (AccessControlException ex) {
            Main.msg("permission denied: " + this.target);
            System.exit(2);
        }
        catch (NodeNotFoundException ex) {
            Main.msg("not found: " + this.target);
            System.exit(2);
        }
    }

    private void printChildList(Node n, List<Node> children) {
        StringBuilder sb = null;
        for (Node child : children) {
            sb = new StringBuilder();
            String name = child.getName();
            if (child instanceof ContainerNode) {
                name = name + "/";
            }
            sb.append(this.pad(name, 32));
            sb.append(this.pad(this.getContentLength(child, true), 12));
            sb.append(this.pad(this.safePropertyRef(child, "ivo://ivoa.net/vospace/core#ispublic"), 8));
            sb.append(this.pad(this.safePropertyRef(child, "ivo://ivoa.net/vospace/core#date"), 26));
            sb.append(child.getUri().toString());
            Main.msg(sb.toString());
        }
    }

    private String pad(String s, int len) {
        if (s.length() >= len) {
            len = s.length() + 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        for (int i = s.length(); i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private String getContentLength(Node n, boolean simple) {
        String contentLength = this.safePropertyRef(n, "ivo://ivoa.net/vospace/core#length");
        if (!StringUtil.hasText(contentLength)) {
            return "0";
        }
        if (simple) {
            return contentLength;
        }
        return FileSizeType.getHumanReadableSize(Long.parseLong(contentLength)) + " (" + contentLength + " bytes)";
    }

    private void copyToVOSpace() throws Throwable {
        boolean checkProps;
        URI originalDestination = null;
        if (StringUtil.hasText(this.destination.getQuery())) {
            originalDestination = new URI(this.destination.toString());
            this.destination = new URI(this.destination.toString().replace("?" + this.destination.getQuery(), ""));
        }
        View view = null;
        if (originalDestination != null) {
            view = this.createAcceptsView(new VOSURI(originalDestination), null);
        }
        if (view == null) {
            view = new View(new URI("ivo://ivoa.net/vospace/core#defaultview"));
        }
        Protocol proto = null;
        if (this.subject != null) {
            proto = new Protocol("ivo://ivoa.net/vospace/core#httpsput");
            proto.setSecurityMethod(AuthMethod.CERT.getSecurityMethod());
        } else {
            proto = new Protocol("ivo://ivoa.net/vospace/core#httpput");
        }
        log.debug("copyToVOSpace: " + proto);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(proto);
        log.debug("this.source: " + this.source);
        File fileToUpload = new File(this.source);
        Transfer transfer = new Transfer(this.destination, Direction.pushToVoSpace, view, protocols);
        transfer.setQuickTransfer(this.quickTransfer);
        transfer.version = 21;
        transfer.setContentLength(fileToUpload.length());
        ClientTransfer clientTransfer = this.client.createTransfer(transfer);
        if (this.contentType != null) {
            log.debug("copyToVOSpaceFast: setting content-type = " + this.contentType);
            clientTransfer.setRequestProperty("Content-Type", this.contentType);
        }
        if (this.contentEncoding != null) {
            log.debug("copyToVOSpaceFast: setting content-encoding = " + this.contentEncoding);
            clientTransfer.setRequestProperty("Content-Encoding", this.contentEncoding);
        }
        if (this.retryEnabled) {
            clientTransfer.setMaxRetries(Integer.MAX_VALUE);
        }
        clientTransfer.setTransferListener(new VOSpaceTransferListener(false));
        clientTransfer.setSSLSocketFactory(this.client.getSslSocketFactory());
        clientTransfer.setFile(fileToUpload);
        clientTransfer.runTransfer();
        if (!this.quickTransfer) {
            this.checkPhase(clientTransfer);
        }
        Node node = this.client.getNode(this.destination.getPath());
        boolean bl = checkProps = this.contentType != null || this.contentEncoding != null || this.properties.size() > 0;
        if (checkProps || log.isDebugEnabled()) {
            log.debug("clientTransfer getTarget: " + node);
            Node cur = this.client.getNode(node.getUri().getPath());
            log.debug("Node returned from getNode, after doUpload: " + VOSClientUtil.xmlString(cur));
            if (checkProps) {
                log.debug("checking properties after put: " + cur.getUri());
                boolean updateProps = false;
                for (NodeProperty np : this.properties) {
                    updateProps = updateProps || this.updateProperty(cur, np.getPropertyURI(), np.getPropertyValue());
                }
                if (updateProps) {
                    log.debug("updating properties after put: " + cur.getUri());
                    this.client.setNode(cur);
                }
            }
        }
    }

    private boolean updateProperty(Node n, String propURI, String propValue) {
        log.debug("checking property: " + propURI + " vs " + propValue);
        boolean ret = false;
        if (propValue != null) {
            NodeProperty cur = n.findProperty(propURI);
            if (cur == null) {
                log.debug("adding property: " + propURI + " = " + propValue);
                n.getProperties().add(new NodeProperty(propURI, propValue));
                ret = true;
            } else if (!propValue.equals(cur.getPropertyValue())) {
                log.debug("setting property: " + propURI + " = '" + propValue + "', was '" + cur.getPropertyValue() + "'");
                cur.setValue(propValue);
                ret = true;
            }
        }
        return ret;
    }

    private void copyFromVOSpace() throws Throwable {
        View view = null;
        if (StringUtil.hasText(this.source.getQuery())) {
            view = this.createProvidesView(new VOSURI(this.source), null);
            this.source = new URI(this.source.toString().replace("?" + this.source.getQuery(), ""));
        }
        if (view == null) {
            view = new View(new URI("ivo://ivoa.net/vospace/core#defaultview"));
        }
        Protocol proto = null;
        if (this.subject != null) {
            proto = new Protocol("ivo://ivoa.net/vospace/core#httpsget");
            proto.setSecurityMethod(AuthMethod.CERT.getSecurityMethod());
        } else {
            proto = new Protocol("ivo://ivoa.net/vospace/core#httpget");
        }
        log.debug("copyFromVOSpace: " + proto);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(proto);
        Transfer transfer = new Transfer(this.source, Direction.pullFromVoSpace, view, protocols);
        transfer.setQuickTransfer(this.quickTransfer);
        transfer.version = 21;
        ClientTransfer clientTransfer = this.client.createTransfer(transfer);
        log.debug("this.source: " + this.source);
        File fileToSave = new File(this.destination);
        if (fileToSave.exists()) {
            log.info("overwriting existing file: " + this.destination);
        }
        if (this.retryEnabled) {
            clientTransfer.setMaxRetries(Integer.MAX_VALUE);
        }
        clientTransfer.setTransferListener(new VOSpaceTransferListener(true));
        clientTransfer.setSSLSocketFactory(this.client.getSslSocketFactory());
        clientTransfer.setFile(fileToSave);
        clientTransfer.runTransfer();
        if (!this.quickTransfer) {
            this.checkPhase(clientTransfer);
        }
    }

    private void moveToVOSpace() throws Throwable {
        File sourceFile = new File(this.source);
        if (!sourceFile.isFile()) {
            Main.msg("Cannot move local directories to VOSpace.");
            System.exit(-1);
        }
        this.copyToVOSpace();
        log.debug("copied local file " + this.source + " to " + this.destination.getPath());
        Node uploadedNode = this.client.getNode(this.destination.getPath(), "limit=0");
        if (uploadedNode == null) {
            Main.msg("Failed to upload, keeping local file.");
            System.exit(-1);
        }
        NodeProperty uploadedSizeProp = uploadedNode.findProperty("ivo://ivoa.net/vospace/core#length");
        long uploadedSize = Long.parseLong(uploadedSizeProp.getPropertyValue());
        log.debug("uploaded size: " + uploadedSize);
        log.debug("original size: " + sourceFile.length());
        if (uploadedSize != sourceFile.length()) {
            Main.msg("Uploaded file size does not match that of local file, keeping local file.");
            System.exit(-1);
        }
        sourceFile.delete();
        log.debug("deleted local file: " + this.source);
    }

    private void moveFromVOSpace() throws Throwable {
        Node sourceNode = this.client.getNode(this.source.getPath(), "limit=0");
        if (sourceNode instanceof ContainerNode) {
            Main.msg("Cannot move containers from VOSpace to local file system.");
            System.exit(-1);
        }
        this.copyFromVOSpace();
        log.debug("copied " + this.destination.getPath() + " to local file " + this.source);
        NodeProperty downloadedSizeProp = sourceNode.findProperty("ivo://ivoa.net/vospace/core#length");
        File destFile = new File(this.destination);
        long downloadedSize = Long.parseLong(downloadedSizeProp.getPropertyValue());
        log.debug("downloaded size: " + downloadedSize);
        log.debug("original size: " + destFile.length());
        if (downloadedSize != destFile.length()) {
            Main.msg("Downloaded file size does not match that of local file, keeping remote file.");
            System.exit(-1);
        }
        this.client.deleteNode(this.source.getPath());
        log.debug("deleted vos file: " + this.source);
    }

    private void doRecursiveSet() {
        try {
            log.debug("target.getPath()" + this.target.getPath());
            Node n = this.client.getNode(this.target.getPath(), "limit=0");
            Node up = null;
            if (n instanceof ContainerNode) {
                up = new ContainerNode(this.target, this.properties);
            } else if (n instanceof DataNode) {
                up = new DataNode(this.target, this.properties);
            } else if (n instanceof LinkNode) {
                URI link = ((LinkNode)n).getTarget();
                up = new LinkNode(this.target, this.properties, link);
            } else {
                throw new UnsupportedOperationException("unexpected node type: " + n.getClass().getName());
            }
            ClientRecursiveSetNode recSetNode = this.client.setNodeRecursive(up);
            ClientAbortThread abortThread = new ClientAbortThread(recSetNode.getJobURL());
            Runtime.getRuntime().addShutdownHook(abortThread);
            recSetNode.setMonitor(true);
            recSetNode.run();
            Runtime.getRuntime().removeShutdownHook(abortThread);
            this.checkPhase(recSetNode);
            log.info("updated properties recursively: " + this.target);
        }
        catch (NodeNotFoundException ex) {
            Main.msg("not found: " + this.target);
            System.exit(2);
        }
        catch (Throwable t) {
            Main.msg("failed to set properties recursively on node: " + this.target);
            if (t.getMessage() != null) {
                Main.msg("          reason: " + t.getMessage());
            } else {
                Main.msg("          reason: " + t);
            }
            if (t.getCause() != null) {
                Main.msg("          reason: " + t.getCause());
            }
            System.exit(2);
        }
    }

    private void moveWithinVOSpace() throws Throwable {
        VOSURI dest = new VOSURI(this.destination);
        Transfer transfer = new Transfer(this.source, dest.getURI(), false);
        ClientTransfer trans = this.client.createTransfer(transfer);
        ClientAbortThread abortThread = new ClientAbortThread(trans.getJobURL());
        Runtime.getRuntime().addShutdownHook(abortThread);
        trans.setMonitor(true);
        trans.runTransfer();
        Runtime.getRuntime().removeShutdownHook(abortThread);
        this.checkPhase(trans);
    }

    private void checkPhase(ClientTransfer trans) throws IOException, RuntimeException {
        ExecutionPhase ep = trans.getPhase();
        if (ExecutionPhase.ERROR.equals((Object)ep)) {
            ErrorSummary es = trans.getServerError();
            throw new RuntimeException(es.getSummaryMessage());
        }
        if (ExecutionPhase.ABORTED.equals((Object)ep)) {
            throw new RuntimeException("transfer aborted by service");
        }
        if (!ExecutionPhase.COMPLETED.equals((Object)ep)) {
            throw new RuntimeException("unexpected job state: " + ep.name());
        }
    }

    private void checkPhase(ClientRecursiveSetNode recSetNode) throws IOException, RuntimeException {
        ExecutionPhase ep = recSetNode.getPhase();
        if (ExecutionPhase.ERROR.equals((Object)ep)) {
            ErrorSummary es = recSetNode.getServerError();
            throw new RuntimeException(es.getSummaryMessage());
        }
        if (ExecutionPhase.ABORTED.equals((Object)ep)) {
            throw new RuntimeException("recursive set node aborted by service");
        }
        if (!ExecutionPhase.COMPLETED.equals((Object)ep)) {
            throw new RuntimeException("unexpected job state: " + ep.name());
        }
    }

    private View createAcceptsView(VOSURI vosuri, Node node) throws URISyntaxException {
        AcceptsProvidesAbstraction nodeViewWrapper = new AcceptsProvidesAbstraction(){

            @Override
            public List<URI> getViews(Node node) {
                return node.accepts();
            }
        };
        return this.createView(vosuri, nodeViewWrapper, node);
    }

    private View createProvidesView(VOSURI vosuri, Node node) throws URISyntaxException {
        AcceptsProvidesAbstraction nodeViewWrapper = new AcceptsProvidesAbstraction(){

            @Override
            public List<URI> getViews(Node node) {
                return node.provides();
            }
        };
        return this.createView(vosuri, nodeViewWrapper, node);
    }

    private View createView(VOSURI vosuri, AcceptsProvidesAbstraction acceptsOrProvides, Node node) throws URISyntaxException {
        String queryString = vosuri.getQuery();
        String viewKey = "view=";
        String[] queries = queryString.split("&");
        String viewRef = null;
        ArrayList<String> params = new ArrayList<String>();
        for (String query : queries) {
            if (query.startsWith("view=")) {
                if (viewRef != null) {
                    throw new IllegalArgumentException("Too many view references.");
                }
                viewRef = query.substring("view=".length());
                continue;
            }
            params.add(query);
        }
        if (viewRef == null) {
            log.debug("View not found in query string, using default view");
            return null;
        }
        if (node == null) {
            try {
                node = this.client.getNode(vosuri.getPath(), "limit=0");
            }
            catch (NodeNotFoundException e) {
                throw new IllegalArgumentException("Node " + vosuri.getPath() + " not found.");
            }
        }
        URI viewURI = null;
        for (URI uri : acceptsOrProvides.getViews(node)) {
            if (!viewRef.equals(uri.getFragment())) continue;
            viewURI = uri;
        }
        if (viewURI == null) {
            throw new IllegalArgumentException("View '" + viewRef + "' not supported by node " + node.getUri().toString());
        }
        View view = new View(viewURI);
        if (params.size() > 0) {
            String viewURIFragment = viewURI.getFragment();
            String paramURIBase = viewURI.toString().replace("#" + viewURIFragment, "");
            for (String param : params) {
                int eqIndex = param.indexOf(61);
                if (eqIndex <= 0) continue;
                String key = param.substring(0, eqIndex);
                URI paramURI = new URI(paramURIBase + "#" + key);
                View.Parameter viewParam = new View.Parameter(paramURI, param.substring(eqIndex + 1));
                view.getParameters().add(viewParam);
            }
        }
        return view;
    }

    private String safePropertyRef(Node n, String key) {
        if (n == null || key == null) {
            return ZERO_LENGTH;
        }
        NodeProperty p = n.findProperty(key);
        if (p == null) {
            return ZERO_LENGTH;
        }
        String ret = p.getPropertyValue();
        if (ret == null) {
            return ZERO_LENGTH;
        }
        return ret;
    }

    private String getType(Node n) {
        if (n instanceof ContainerNode) {
            return "container";
        }
        if (n instanceof DataNode) {
            return "data";
        }
        if (n instanceof LinkNode) {
            return ARG_LINK;
        }
        return ZERO_LENGTH;
    }

    private void init(ArgumentMap argMap) {
        URI serverUri;
        block47: {
            serverUri = null;
            try {
                log.debug("SB: Trying to get subject from cert");
                this.subject = CertCmdArgUtil.initSubject(argMap, true);
            }
            catch (Exception ex) {
                log.error("failed in reading certificate subject: " + ex.getMessage());
                System.exit(1);
            }
            try {
                if (this.subject != null) {
                    Set<X509CertificateChain> certs = this.subject.getPublicCredentials(X509CertificateChain.class);
                    if (certs.size() == 0) {
                        throw new RuntimeException("BUG: failed to load certficate");
                    }
                    DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd HH:mm:ss.SSS", DateUtil.LOCAL);
                    X509CertificateChain chain = certs.iterator().next();
                    Date start = null;
                    Date end = null;
                    for (X509Certificate c : chain.getChain()) {
                        try {
                            start = c.getNotBefore();
                            end = c.getNotAfter();
                            c.checkValidity();
                        }
                        catch (CertificateNotYetValidException exp) {
                            log.error("certificate is not valid yet (valid from " + df.format(start) + " to " + df.format(end) + ")");
                            System.exit(1);
                        }
                        catch (CertificateExpiredException exp) {
                            log.error("certificate has expired (valid from " + df.format(start) + " to " + df.format(end) + ")");
                            System.exit(1);
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error("failed to load certificates: " + ex.getMessage());
                System.exit(1);
            }
            try {
                if (this.operation.equals((Object)Operation.COPY) || this.operation.equals((Object)Operation.MOVE)) {
                    File f;
                    if (this.operation.equals((Object)Operation.COPY) && argMap.isSet(ARG_QUICK)) {
                        this.quickTransfer = true;
                    }
                    String strSrc = argMap.getValue(ARG_SRC);
                    String strDest = argMap.getValue(ARG_DEST);
                    if (!strSrc.startsWith(VOS_PREFIX) && strDest.startsWith(VOS_PREFIX)) {
                        this.transferDirection = Direction.pushToVoSpace;
                        try {
                            this.destination = new URI(strDest);
                            serverUri = new VOSURI(strDest).getServiceURI();
                            log.debug("SB: serverUri in inizializzazione = " + serverUri.toString());
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("Invalid VOS URI: " + strDest);
                        }
                        f = new File(strSrc);
                        if (!f.exists() || !f.canRead()) {
                            throw new IllegalArgumentException("Source file " + strSrc + " does not exist or cannot be read.");
                        }
                        try {
                            this.source = new URI("file", f.getAbsolutePath(), null);
                            break block47;
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("Invalid file path: " + strSrc);
                        }
                    }
                    if (strSrc.startsWith(VOS_PREFIX) && !strDest.startsWith(VOS_PREFIX)) {
                        this.transferDirection = Direction.pullFromVoSpace;
                        try {
                            serverUri = new VOSURI(strSrc).getServiceURI();
                            log.debug("SB: serverUri in inizializzazione 2 = " + serverUri.toString());
                            this.source = new URI(strSrc);
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("Invalid VOS URI: " + strSrc);
                        }
                        f = new File(strDest);
                        if (f.exists()) {
                            if (!f.canWrite()) {
                                throw new IllegalArgumentException("Destination file " + strDest + " is not writable.");
                            }
                        } else {
                            File parent = f.getParentFile();
                            if (parent == null) {
                                String cwd = System.getProperty("user.dir");
                                parent = new File(cwd);
                            }
                            if (parent.isDirectory()) {
                                if (!parent.canWrite()) {
                                    throw new IllegalArgumentException("The parent directory of destination file " + strDest + " is not writable.");
                                }
                            } else {
                                throw new IllegalArgumentException("Destination file " + strDest + " is not within a directory.");
                            }
                        }
                        this.destination = f.toURI();
                        break block47;
                    }
                    if (!strSrc.startsWith(VOS_PREFIX) && !strDest.startsWith(VOS_PREFIX)) {
                        throw new IllegalArgumentException("Local copy and move operations not yet supported.");
                    }
                    if (this.operation.equals((Object)Operation.COPY)) {
                        throw new IllegalArgumentException("Copy within vospace is not yet supported.");
                    }
                    URI destServerUri = null;
                    try {
                        this.source = new URI(strSrc);
                        serverUri = new VOSURI(this.source).getServiceURI();
                        log.debug("SB: serverUri in inizializzazione 3 = " + serverUri.toString());
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException("Invalid VOS URI: " + strSrc);
                    }
                    try {
                        this.destination = new URI(strDest);
                        destServerUri = new VOSURI(this.destination).getServiceURI();
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException("Invalid VOS URI: " + strDest);
                    }
                    if (!serverUri.equals(destServerUri)) {
                        throw new IllegalArgumentException("Move between two vospace services is not yet supported.");
                    }
                    break block47;
                }
                String strTarget = argMap.getValue(ARG_TARGET);
                try {
                    this.target = new VOSURI(strTarget);
                    serverUri = this.target.getServiceURI();
                    log.debug("SB: serverUri in inizializzazione 4 = " + serverUri.toString());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid VOS URI: " + strTarget);
                }
            }
            catch (NullPointerException nex) {
                log.error("BUG", nex);
                System.exit(-1);
            }
            catch (Exception ex) {
                log.error(ex.toString());
                System.exit(1);
            }
        }
        RegistryClient reg = null;
        try {
            reg = new RegistryClient();
        }
        catch (Exception e) {
            log.debug("SB: XXX Exception: " + e.getMessage());
            System.exit(1);
        }
        log.debug("SB: RegistryClient created");
        try {
            String protocol = "https";
            if (this.subject == null) {
                protocol = "http";
            }
            log.debug("SB: protocol = " + protocol);
            log.debug("SB: serverUri = " + serverUri.toString());
            URL baseURL = reg.getServiceURL(serverUri, protocol);
            if (baseURL == null) {
                log.debug("SB: baseURL == null");
                log.error("failed to find service URL for " + serverUri);
                System.exit(1);
            }
            this.baseUrl = baseURL.toString();
        }
        catch (MalformedURLException e) {
            log.debug("SB: MalformedURLException: " + e.getMessage());
            log.error("failed to find service URL for " + serverUri);
            log.error("reason: " + e.getMessage());
            System.exit(1);
        }
        boolean doVal = true;
        String schemaVal = argMap.getValue(ARG_XSV);
        if (schemaVal != null && "off".equals(schemaVal)) {
            doVal = false;
            log.info("XML schema validation: disabled");
        }
        this.client = new VOSpaceClient(this.baseUrl, doVal);
        this.retryEnabled = !argMap.isSet(ARG_NO_RETRY);
        log.info("server uri: " + serverUri);
        log.info("base url: " + this.baseUrl);
    }

    private void validateCommand(ArgumentMap argMap) throws IllegalArgumentException {
        int numOp = 0;
        if (argMap.isSet(ARG_VIEW)) {
            ++numOp;
            this.operation = Operation.VIEW;
        }
        if (argMap.isSet(ARG_CREATE)) {
            ++numOp;
            this.operation = Operation.CREATE;
        }
        if (argMap.isSet(ARG_DELETE)) {
            ++numOp;
            this.operation = Operation.DELETE;
        }
        if (argMap.isSet(ARG_SET)) {
            ++numOp;
            this.operation = Operation.SET;
        }
        if (argMap.isSet(ARG_COPY)) {
            ++numOp;
            this.operation = Operation.COPY;
        }
        if (argMap.isSet(ARG_MOVE)) {
            ++numOp;
            this.operation = Operation.MOVE;
        }
        if (numOp == 0) {
            throw new IllegalArgumentException("At least one operation must be defined.");
        }
        if (numOp > 1) {
            throw new IllegalArgumentException("Only one operation may be defined.");
        }
    }

    private void validateCommandArguments(ArgumentMap argMap) throws IllegalArgumentException {
        String s;
        String s2;
        if (this.operation.equals((Object)Operation.COPY) || this.operation.equals((Object)Operation.MOVE)) {
            String strSrc = argMap.getValue(ARG_SRC);
            if (strSrc == null) {
                throw new IllegalArgumentException("Argument src is required for " + (Object)((Object)this.operation));
            }
            String strDest = argMap.getValue(ARG_DEST);
            if (strDest == null) {
                throw new IllegalArgumentException("Argument dest is required for " + (Object)((Object)this.operation));
            }
        } else {
            String strTarget = argMap.getValue(ARG_TARGET);
            if (strTarget == null) {
                throw new IllegalArgumentException("Argument target is required for " + (Object)((Object)this.operation));
            }
            if (this.operation.equals((Object)Operation.CREATE)) {
                String strNodeType = argMap.getValue(ARG_CREATE);
                if ("true".equalsIgnoreCase(strNodeType) || "ContainerNode".equalsIgnoreCase(strNodeType)) {
                    this.nodeType = NodeType.CONTAINER_NODE;
                } else if ("DataNode".equalsIgnoreCase(strNodeType) || "UnstructuredDataNode".equalsIgnoreCase(strNodeType)) {
                    this.nodeType = NodeType.UNSTRUCTURED_DATA_NODE;
                } else if ("LinkNode".equalsIgnoreCase(strNodeType)) {
                    String strLink = argMap.getValue(ARG_LINK);
                    if (strLink == null) {
                        throw new IllegalArgumentException("Argument link is required for node type " + strNodeType);
                    }
                    try {
                        this.link = new URI(strLink);
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException("Invalid URI: " + strLink);
                    }
                    this.nodeType = NodeType.LINK_NODE;
                } else if ("StructuredDataNode".equalsIgnoreCase(strNodeType)) {
                    this.nodeType = NodeType.STRUCTURED_DATA_NODE;
                } else {
                    throw new IllegalArgumentException("Unsupported node type: " + strNodeType);
                }
            }
        }
        this.properties = new ArrayList<NodeProperty>();
        String propFile = argMap.getValue(ARG_PROP);
        if (propFile != null) {
            File f = new File(propFile);
            if (f.exists()) {
                if (f.canRead()) {
                    try {
                        Properties p = new Properties();
                        p.load(new FileReader(f));
                        for (String key : p.stringPropertyNames()) {
                            String val = p.getProperty(key);
                            this.properties.add(new NodeProperty(key, val));
                        }
                    }
                    catch (IOException ex) {
                        log.info("failed to read properties file: " + f.getAbsolutePath() + "(" + ex.getMessage() + ", skipping)");
                    }
                } else {
                    log.info("cannot read properties file: " + f.getAbsolutePath() + " (permission denied, skipping)");
                }
            } else {
                log.info("cannot read properties file: " + f.getAbsolutePath() + " (does not exist, skipping)");
            }
        }
        this.contentType = argMap.getValue(ARG_CONTENT_TYPE);
        this.contentEncoding = argMap.getValue(ARG_CONTENT_ENCODING);
        String contentMD5 = argMap.getValue(ARG_CONTENT_MD5);
        String groupRead = argMap.getValue(ARG_GROUP_READ);
        String groupWrite = argMap.getValue(ARG_GROUP_WRITE);
        boolean isPublicSet = argMap.isSet(ARG_PUBLIC);
        boolean isPublicValue = true;
        if (isPublicSet && (s2 = argMap.getValue(ARG_PUBLIC)) != null && s2.trim().length() > 0 && !s2.trim().equalsIgnoreCase("true")) {
            if (s2.equalsIgnoreCase("false")) {
                isPublicValue = false;
            } else {
                isPublicSet = false;
                log.info("--public value not recognized: " + s2.trim() + ".  Ignoring.");
            }
        }
        boolean isLockSet = argMap.isSet(ARG_LOCK);
        boolean isLockValue = true;
        if (isLockSet && (s = argMap.getValue(ARG_LOCK)) != null && s.trim().length() > 0 && !s.trim().equalsIgnoreCase("true")) {
            if (s.equalsIgnoreCase("false")) {
                isLockValue = false;
            } else {
                isLockSet = false;
                log.info("--lock value not recognized: " + s.trim() + ".  Ignoring.");
            }
        }
        this.recursiveMode = argMap.isSet(ARG_RECURSIVE);
        if (this.contentType != null) {
            this.properties.add(new NodeProperty("ivo://ivoa.net/vospace/core#type", this.contentType));
        }
        if (this.contentEncoding != null) {
            this.properties.add(new NodeProperty("ivo://ivoa.net/vospace/core#encoding", this.contentEncoding));
        }
        if (contentMD5 != null) {
            this.properties.add(new NodeProperty("ivo://ivoa.net/vospace/core#MD5", contentMD5));
        }
        if (groupRead != null) {
            this.properties.add(new NodeProperty("ivo://ivoa.net/vospace/core#groupread", groupRead));
        }
        if (groupWrite != null) {
            this.properties.add(new NodeProperty("ivo://ivoa.net/vospace/core#groupwrite", groupWrite));
        }
        if (isLockSet) {
            this.properties.add(new NodeProperty("ivo://cadc.nrc.ca/vospace/core#islocked", Boolean.toString(isLockValue)));
        }
        if (isPublicSet) {
            this.properties.add(new NodeProperty("ivo://ivoa.net/vospace/core#ispublic", Boolean.toString(isPublicValue)));
        }
    }

    public static void usage() {
        String[] um;
        for (String line : um = new String[]{"", "Usage: java -jar cadcVOSClient.jar [-v|--verbose|-d|--debug] [--xsv=off]                          ", CertCmdArgUtil.getCertArgUsage(), "", "  Note: --xsv=off disables XML schema validation; use at your own risk                            ", "", "Help:                                                                                             ", "    <-h | --help>                                                                                 ", "", "Create node:                                                                                      ", "", "    --create[=<ContainerNode|LinkNode|StructuredDataNode|UnstructuredDataNode>]                   ", "    --target=<node URI>                                                                           ", "    [--link=<link URI>]                                                                           ", "    [--prop=<properties file>]                                                                    ", "", "  Note: --create defaults to creating a ContainerNode (directory).                                ", "", "  Note: --link is only required when creating a LinkNode.  It is the URI to which                 ", "          the LinkNode is pointing.                                                               ", "", "View node:                                                                                        ", "", "    --view --target=<target URI>                                                                  ", "", "Delete node:                                                                                      ", "", "    --delete --target=<target URI>                                                                ", "", "Set node:                                                                                         ", "", "    --set --target=<target URI>                                                                   ", "    [--content-type=<mimetype of source>]                                                         ", "    [--content-encoding=<encoding of source>]                                                     ", "    [--group-read=<group URIs (in double quotes, space separated, 4 maximum)>]                    ", "    [--group-write=<group URIs (in double quotes, space separated, 4 maximum)>]                   ", "    [--lock]                                                                                      ", "    [--public]                                                                                    ", "    [--prop=<properties file>]                                                                    ", "    [--recursive]                                                                                 ", "", "Copy file:                                                                                        ", "", "    --copy --src=<source URI> --dest=<destination URI>                                            ", "    [--content-type=<mimetype of source>]                                                         ", "    [--content-encoding=<encoding of source>]                                                     ", "    [--prop=<properties file>]                                                                    ", "    [--noretry]                                                                                   ", "    [--quick]                                                                                     ", "", "  Note: --noretry disables the retry of failed transfers (when the server indicates it was        ", "  temporary)                                                                                      ", "", "  Note: One of --src and --target may be a \"vos\" URI and the other may be an                    ", "  absolute or relative path to a file.  If the target node does not exist, a                      ", "  DataNode is created and data copied.  If it does exist, the data and                            ", "  properties are overwritten.                                                                     ", "", "  Note: Source and destination URIs may include HTTP-like query parameters, some of which will    ", "  result in additional operations being performed.                                                ", "", "  Note: If the --quick options is supplied, and a download is being performed, transfer           ", "  negotiation will be replaced with an optimized download process.                                ", "", "Move file/node:                                                                                   ", "", "    --move --src=<source URI> --dest=<destination URI>                                            ", "", "  Note: If the source URI refers to a VOSpace node, then move is a recursive operation:  the      ", "  source nodes, and all subnodes, are moved.                                                      ", "", "  Note: Only files can be moved from the local file system to VOSpace.  Similarly, only files     ", "  can be moved from VOSpace to the local file system.                                             ", "", "  Note: If the destination URI referes to a VOSpace node, that node must be a directory.  If the  ", "  directory exists, the source URI will be moved into that directory.  If the directory doesn't   ", "  exist, the source URI will be moved into the parent directory and will be renamed to the name   ", "  specified in destination URI.                                                                   "}) {
            Main.msg(line);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AcceptsProvidesAbstraction {
        public List<URI> getViews(Node var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        VIEW,
        CREATE,
        DELETE,
        SET,
        COPY,
        MOVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        CONTAINER_NODE,
        LINK_NODE,
        STRUCTURED_DATA_NODE,
        UNSTRUCTURED_DATA_NODE;

    }
}

