/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import ca.nrc.cadc.vos.Protocol;
import ca.nrc.cadc.vos.Transfer;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.XmlProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class TransferWriter
implements XmlProcessor {
    private static Logger log = Logger.getLogger(TransferWriter.class);

    public void write(Transfer trans, OutputStream out) throws IOException {
        this.write(trans, (Writer)new OutputStreamWriter(out));
    }

    public void write(Transfer trans, Writer writer) throws IOException {
        Element root = this.buildRoot(trans);
        this.write(root, writer);
    }

    private Element buildRoot(Transfer transfer) {
        Namespace vosNamespace = null;
        if (transfer.version == 20) {
            vosNamespace = Namespace.getNamespace("vos", "http://www.ivoa.net/xml/VOSpace/v2.0");
        } else if (transfer.version == 21) {
            vosNamespace = Namespace.getNamespace("vos", "http://www.ivoa.net/xml/VOSpace/v2.1");
        } else {
            throw new IllegalArgumentException("invalid VOSpace version code: " + transfer.version);
        }
        Element root = new Element("transfer", vosNamespace);
        Element e = null;
        e = new Element("target", vosNamespace);
        e.addContent(transfer.getTarget().toASCIIString());
        root.addContent(e);
        e = new Element("direction", vosNamespace);
        e.addContent(transfer.getDirection().getValue());
        root.addContent(e);
        e = new Element("view", vosNamespace);
        if (transfer.getView() != null) {
            e.setAttribute("uri", transfer.getView().getURI().toString());
            for (View.Parameter param : transfer.getView().getParameters()) {
                Element pm = new Element("param", vosNamespace);
                pm.setAttribute("uri", param.getUri().toString());
                pm.setText(param.getValue());
                e.addContent(pm);
            }
            root.addContent(e);
        }
        if (transfer.getProtocols() != null) {
            for (Protocol protocol : transfer.getProtocols()) {
                Element pr = new Element("protocol", vosNamespace);
                pr.setAttribute("uri", protocol.getUri());
                if (protocol.getEndpoint() != null) {
                    Element ep = new Element("endpoint", vosNamespace);
                    ep.addContent(protocol.getEndpoint());
                    pr.addContent(ep);
                }
                if (transfer.version >= 21 && protocol.getSecurityMethod() != null) {
                    Element es = new Element("securityMethod", vosNamespace);
                    es.setAttribute("uri", protocol.getSecurityMethod().toASCIIString());
                    pr.addContent(es);
                }
                root.addContent(pr);
            }
        }
        e = new Element("keepBytes", vosNamespace);
        e.addContent(Boolean.toString(transfer.isKeepBytes()));
        root.addContent(e);
        if (transfer.version >= 21 && transfer.getContentLength() != null) {
            e = new Element("param", vosNamespace);
            e.setAttribute("uri", "ivo://ivoa.net/vospace/core#length");
            e.addContent(transfer.getContentLength().toString());
            root.addContent(e);
        }
        return root;
    }

    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }
}

